/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.KeyedObjects;

public class KeyedObjects2D
implements Cloneable,
Serializable {
    private List rowKeys = new ArrayList();
    private List columnKeys = new ArrayList();
    private List rows = new ArrayList();

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Object getObject(int n, int n2) {
        Comparable comparable;
        Object object = null;
        KeyedObjects keyedObjects = (KeyedObjects)this.rows.get(n);
        if (keyedObjects != null && (comparable = (Comparable)this.columnKeys.get(n2)) != null) {
            object = keyedObjects.getObject(comparable);
        }
        return object;
    }

    public Comparable getRowKey(int n) {
        return (Comparable)this.rowKeys.get(n);
    }

    public int getRowIndex(Comparable comparable) {
        return this.rowKeys.indexOf(comparable);
    }

    public List getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    public Comparable getColumnKey(int n) {
        return (Comparable)this.columnKeys.get(n);
    }

    public int getColumnIndex(Comparable comparable) {
        return this.columnKeys.indexOf(comparable);
    }

    public List getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    public Object getObject(Comparable comparable, Comparable comparable2) {
        Object object = null;
        int n = this.rowKeys.indexOf(comparable);
        if (n >= 0) {
            KeyedObjects keyedObjects = (KeyedObjects)this.rows.get(n);
            object = keyedObjects.getObject(comparable2);
        }
        return object;
    }

    public void addObject(Object object, Comparable comparable, Comparable comparable2) {
        this.setObject(object, comparable, comparable2);
    }

    public void setObject(Object object, Comparable comparable, Comparable comparable2) {
        KeyedObjects keyedObjects;
        int n = this.rowKeys.indexOf(comparable);
        if (n >= 0) {
            keyedObjects = (KeyedObjects)this.rows.get(n);
        } else {
            this.rowKeys.add(comparable);
            keyedObjects = new KeyedObjects();
            this.rows.add(keyedObjects);
        }
        keyedObjects.setObject(comparable2, object);
        int n2 = this.columnKeys.indexOf(comparable2);
        if (n2 < 0) {
            this.columnKeys.add(comparable2);
        }
    }

    public void removeObject(Comparable comparable, Comparable comparable2) {
        this.setObject(null, comparable, comparable2);
    }

    public void removeRow(int n) {
        this.rowKeys.remove(n);
        this.rows.remove(n);
    }

    public void removeRow(Comparable comparable) {
        this.removeRow(this.getRowIndex(comparable));
    }

    public void removeColumn(int n) {
        Comparable comparable = this.getColumnKey(n);
        this.removeColumn(comparable);
    }

    public void removeColumn(Comparable comparable) {
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            KeyedObjects keyedObjects = (KeyedObjects)iterator.next();
            keyedObjects.removeValue(comparable);
        }
        this.columnKeys.remove(comparable);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedObjects2D)) {
            return false;
        }
        KeyedObjects2D keyedObjects2D = (KeyedObjects2D)object;
        if (!this.getRowKeys().equals(keyedObjects2D.getRowKeys())) {
            return false;
        }
        if (!this.getColumnKeys().equals(keyedObjects2D.getColumnKeys())) {
            return false;
        }
        int n = this.getRowCount();
        if (n != keyedObjects2D.getRowCount()) {
            return false;
        }
        int n2 = this.getColumnCount();
        if (n2 != keyedObjects2D.getColumnCount()) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                Object object2 = this.getObject(n3, n4);
                Object object3 = keyedObjects2D.getObject(n3, n4);
                if (object2 == null ? object3 != null : !object2.equals(object3)) {
                    return false;
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public int hashCode() {
        int n = this.rowKeys.hashCode();
        n = 29 * n + this.columnKeys.hashCode();
        n = 29 * n + this.rows.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

