/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.StandardLegend;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.FontChooserPanel;
import org.jfree.ui.FontDisplayField;
import org.jfree.ui.PaintSample;
import org.jfree.ui.StrokeChooserPanel;
import org.jfree.ui.StrokeSample;

class LegendPropertyEditPanel
extends JPanel
implements ActionListener {
    private boolean showLegend;
    private JCheckBox showLegendCheckBox;
    private StrokeSample outlineStroke;
    private JButton selectOutlineStrokeButton;
    private PaintSample outlinePaint;
    private JButton selectOutlinePaintButton;
    private PaintSample backgroundPaint;
    private JButton selectBackgroundPaintButton;
    private Font seriesFont;
    private JButton selectSeriesFontButton;
    private PaintSample seriesPaint;
    private JButton selectSeriesPaintButton;
    private StrokeSample[] availableStrokeSamples;
    private FontDisplayField fontDisplayField;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.ui.LocalizationBundle");

    public LegendPropertyEditPanel(Legend legend) {
        StandardLegend standardLegend = legend != null ? (StandardLegend)legend : new StandardLegend();
        this.showLegend = legend != null;
        this.outlineStroke = new StrokeSample(standardLegend.getOutlineStroke());
        this.outlinePaint = new PaintSample(standardLegend.getOutlinePaint());
        this.backgroundPaint = new PaintSample(standardLegend.getBackgroundPaint());
        this.seriesFont = standardLegend.getItemFont();
        this.seriesPaint = new PaintSample(standardLegend.getItemPaint());
        this.availableStrokeSamples = new StrokeSample[4];
        this.availableStrokeSamples[0] = new StrokeSample((Stroke)new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample((Stroke)new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample((Stroke)new BasicStroke(3.0f));
        this.availableStrokeSamples[3] = new StrokeSample((Stroke)new BasicStroke(4.0f));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), localizationResources.getString("General")));
        JPanel jPanel2 = new JPanel((LayoutManager)new LCBLayout(6));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel2.add(new JLabel(localizationResources.getString("Show_Legend")));
        this.showLegendCheckBox = new JCheckBox();
        this.showLegendCheckBox.setSelected(this.showLegend);
        this.showLegendCheckBox.setActionCommand("ShowLegend");
        this.showLegendCheckBox.addActionListener(this);
        jPanel2.add(new JPanel());
        jPanel2.add(this.showLegendCheckBox);
        jPanel2.add(new JLabel(localizationResources.getString("Outline")));
        jPanel2.add((Component)this.outlineStroke);
        this.selectOutlineStrokeButton = new JButton(localizationResources.getString("Select..."));
        this.selectOutlineStrokeButton.setActionCommand("OutlineStroke");
        this.selectOutlineStrokeButton.addActionListener(this);
        jPanel2.add(this.selectOutlineStrokeButton);
        jPanel2.add(new JLabel(localizationResources.getString("Outline_Paint")));
        this.selectOutlinePaintButton = new JButton(localizationResources.getString("Select..."));
        this.selectOutlinePaintButton.setActionCommand("OutlinePaint");
        this.selectOutlinePaintButton.addActionListener(this);
        jPanel2.add((Component)this.outlinePaint);
        jPanel2.add(this.selectOutlinePaintButton);
        jPanel2.add(new JLabel(localizationResources.getString("Background")));
        this.selectBackgroundPaintButton = new JButton(localizationResources.getString("Select..."));
        this.selectBackgroundPaintButton.setActionCommand("BackgroundPaint");
        this.selectBackgroundPaintButton.addActionListener(this);
        jPanel2.add((Component)this.backgroundPaint);
        jPanel2.add(this.selectBackgroundPaintButton);
        jPanel2.add(new JLabel(localizationResources.getString("Series_label_font")));
        this.selectSeriesFontButton = new JButton(localizationResources.getString("Select..."));
        this.selectSeriesFontButton.setActionCommand("SeriesFont");
        this.selectSeriesFontButton.addActionListener(this);
        this.fontDisplayField = new FontDisplayField(this.seriesFont);
        jPanel2.add((Component)this.fontDisplayField);
        jPanel2.add(this.selectSeriesFontButton);
        jPanel2.add(new JLabel(localizationResources.getString("Series_label_paint")));
        this.selectSeriesPaintButton = new JButton(localizationResources.getString("Select..."));
        this.selectSeriesPaintButton.setActionCommand("SeriesPaint");
        this.selectSeriesPaintButton.addActionListener(this);
        jPanel2.add((Component)this.seriesPaint);
        jPanel2.add(this.selectSeriesPaintButton);
        this.enableOrDisableControls();
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "North");
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke.getStroke();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint.getPaint();
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint.getPaint();
    }

    public Font getSeriesFont() {
        return this.seriesFont;
    }

    public Paint getSeriesPaint() {
        return this.seriesPaint.getPaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OutlineStroke")) {
            this.attemptModifyOutlineStroke();
        } else if (string.equals("OutlinePaint")) {
            this.attemptModifyOutlinePaint();
        } else if (string.equals("BackgroundPaint")) {
            this.attemptModifyBackgroundPaint();
        } else if (string.equals("SeriesFont")) {
            this.attemptModifySeriesFont();
        } else if (string.equals("SeriesPaint")) {
            this.attemptModifySeriesPaint();
        } else if (string.equals("ShowLegend")) {
            this.attemptModifyShowLegend();
        }
    }

    private void attemptModifyOutlineStroke() {
        StrokeChooserPanel strokeChooserPanel = new StrokeChooserPanel(this.outlineStroke, this.availableStrokeSamples);
        int n = JOptionPane.showConfirmDialog(this, strokeChooserPanel, localizationResources.getString("Pen_Stroke_Selection"), 2, -1);
        if (n == 0) {
            this.outlineStroke.setStroke(strokeChooserPanel.getSelectedStroke());
        }
    }

    private void attemptModifyOutlinePaint() {
        Color color = JColorChooser.showDialog(this, localizationResources.getString("Outline_Color"), Color.blue);
        if (color != null) {
            this.outlinePaint.setPaint((Paint)color);
        }
    }

    private void attemptModifyBackgroundPaint() {
        Color color = JColorChooser.showDialog(this, localizationResources.getString("Background_Color"), Color.blue);
        if (color != null) {
            this.backgroundPaint.setPaint((Paint)color);
        }
    }

    public void attemptModifySeriesFont() {
        FontChooserPanel fontChooserPanel = new FontChooserPanel(this.seriesFont);
        int n = JOptionPane.showConfirmDialog(this, fontChooserPanel, localizationResources.getString("Font_Selection"), 2, -1);
        if (n == 0) {
            this.seriesFont = fontChooserPanel.getSelectedFont();
            this.fontDisplayField.setText(String.valueOf(this.seriesFont.getFontName()) + ", " + this.seriesFont.getSize());
        }
    }

    private void attemptModifySeriesPaint() {
        Color color = JColorChooser.showDialog(this, localizationResources.getString("Series_Label_Color"), Color.blue);
        if (color != null) {
            this.seriesPaint.setPaint((Paint)color);
        }
    }

    private void attemptModifyShowLegend() {
        this.showLegend = this.showLegendCheckBox.isSelected();
        this.enableOrDisableControls();
    }

    private void enableOrDisableControls() {
        boolean bl = this.showLegend;
        this.selectOutlineStrokeButton.setEnabled(bl);
        this.selectOutlinePaintButton.setEnabled(bl);
        this.selectBackgroundPaintButton.setEnabled(bl);
        this.selectSeriesFontButton.setEnabled(bl);
        this.selectSeriesPaintButton.setEnabled(bl);
    }

    public void setLegendProperties(JFreeChart jFreeChart) {
        if (this.showLegend) {
            Legend legend = jFreeChart.getLegend();
            if (legend == null) {
                legend = new StandardLegend();
                jFreeChart.setLegend(legend);
            }
            if (legend instanceof StandardLegend) {
                StandardLegend standardLegend = (StandardLegend)legend;
                standardLegend.setOutlineStroke(this.getOutlineStroke());
                standardLegend.setOutlinePaint(this.getOutlinePaint());
                standardLegend.setBackgroundPaint(this.getBackgroundPaint());
                standardLegend.setItemFont(this.getSeriesFont());
                standardLegend.setItemPaint(this.getSeriesPaint());
            }
        } else {
            jFreeChart.setLegend(null);
        }
    }
}

