/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.ui.LegendPropertyEditPanel;
import org.jfree.chart.ui.PlotPropertyEditPanel;
import org.jfree.chart.ui.TitlePropertyEditPanel;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.PaintSample;

public class ChartPropertyEditPanel
extends JPanel
implements ActionListener {
    private TitlePropertyEditPanel titlePropertiesPanel;
    private LegendPropertyEditPanel legendPropertiesPanel;
    private PlotPropertyEditPanel plotPropertiesPanel;
    private JCheckBox antialias;
    private PaintSample background;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.ui.LocalizationBundle");

    public ChartPropertyEditPanel(JFreeChart jFreeChart) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), localizationResources.getString("General")));
        JPanel jPanel3 = new JPanel((LayoutManager)new LCBLayout(6));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.antialias = new JCheckBox(localizationResources.getString("Draw_anti-aliased"));
        this.antialias.setSelected(jFreeChart.getAntiAlias());
        jPanel3.add(this.antialias);
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel(localizationResources.getString("Background_paint")));
        this.background = new PaintSample(jFreeChart.getBackgroundPaint());
        jPanel3.add((Component)this.background);
        JButton jButton = new JButton(localizationResources.getString("Select..."));
        jButton.setActionCommand("BackgroundPaint");
        jButton.addActionListener(this);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel(localizationResources.getString("Series_Paint")));
        JTextField jTextField = new JTextField(localizationResources.getString("No_editor_implemented"));
        jTextField.setEnabled(false);
        jPanel3.add(jTextField);
        jButton = new JButton(localizationResources.getString("Edit..."));
        jButton.setEnabled(false);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel(localizationResources.getString("Series_Stroke")));
        jTextField = new JTextField(localizationResources.getString("No_editor_implemented"));
        jTextField.setEnabled(false);
        jPanel3.add(jTextField);
        jButton = new JButton(localizationResources.getString("Edit..."));
        jButton.setEnabled(false);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel(localizationResources.getString("Series_Outline_Paint")));
        jTextField = new JTextField(localizationResources.getString("No_editor_implemented"));
        jTextField.setEnabled(false);
        jPanel3.add(jTextField);
        jButton = new JButton(localizationResources.getString("Edit..."));
        jButton.setEnabled(false);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel(localizationResources.getString("Series_Outline_Stroke")));
        jTextField = new JTextField(localizationResources.getString("No_editor_implemented"));
        jTextField.setEnabled(false);
        jPanel3.add(jTextField);
        jButton = new JButton(localizationResources.getString("Edit..."));
        jButton.setEnabled(false);
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        TextTitle textTitle = jFreeChart.getTitle();
        Legend legend = jFreeChart.getLegend();
        Plot plot = jFreeChart.getPlot();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.titlePropertiesPanel = new TitlePropertyEditPanel(textTitle);
        this.titlePropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jTabbedPane.addTab(localizationResources.getString("Title"), this.titlePropertiesPanel);
        this.legendPropertiesPanel = new LegendPropertyEditPanel(legend);
        this.legendPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jTabbedPane.addTab(localizationResources.getString("Legend"), this.legendPropertiesPanel);
        this.plotPropertiesPanel = new PlotPropertyEditPanel(plot);
        this.plotPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jTabbedPane.addTab(localizationResources.getString("Plot"), this.plotPropertiesPanel);
        jTabbedPane.add(localizationResources.getString("Other"), jPanel);
        jPanel4.add((Component)jTabbedPane, "North");
        this.add(jPanel4);
    }

    public TitlePropertyEditPanel getTitlePropertyEditPanel() {
        return this.titlePropertiesPanel;
    }

    public LegendPropertyEditPanel getLegendPropertyEditPanel() {
        return this.legendPropertiesPanel;
    }

    public PlotPropertyEditPanel getPlotPropertyEditPanel() {
        return this.plotPropertiesPanel;
    }

    public boolean getAntiAlias() {
        return this.antialias.isSelected();
    }

    public Paint getBackgroundPaint() {
        return this.background.getPaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("BackgroundPaint")) {
            this.attemptModifyBackgroundPaint();
        }
    }

    private void attemptModifyBackgroundPaint() {
        Color color = JColorChooser.showDialog(this, localizationResources.getString("Background_Color"), Color.blue);
        if (color != null) {
            this.background.setPaint((Paint)color);
        }
    }

    public void updateChartProperties(JFreeChart jFreeChart) {
        this.titlePropertiesPanel.setTitleProperties(jFreeChart);
        this.legendPropertiesPanel.setLegendProperties(jFreeChart);
        this.plotPropertiesPanel.updatePlotProperties(jFreeChart.getPlot());
        jFreeChart.setAntiAlias(this.getAntiAlias());
        jFreeChart.setBackgroundPaint(this.getBackgroundPaint());
    }
}

