/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.CenterArrangement;
import org.jfree.chart.block.ColumnArrangement;
import org.jfree.chart.block.FlowArrangement;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.title.LegendGraphic;
import org.jfree.chart.title.Title;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;
import org.jfree.util.ArrayUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class LegendTitle
extends Title
implements Cloneable,
PublicCloneable,
Serializable {
    private LegendItemSource[] sources;
    private transient Paint backgroundPaint;
    private RectangleEdge legendItemGraphicEdge;
    private RectangleAnchor legendItemGraphicAnchor;
    private RectangleAnchor legendItemGraphicLocation;
    private BlockContainer items;
    private Arrangement hLayout;
    private Arrangement vLayout;
    private BlockContainer wrapper;

    public LegendTitle(LegendItemSource legendItemSource) {
        this(legendItemSource, new FlowArrangement(), new ColumnArrangement());
    }

    public LegendTitle(LegendItemSource legendItemSource, Arrangement arrangement, Arrangement arrangement2) {
        this.sources = new LegendItemSource[]{legendItemSource};
        this.items = new BlockContainer(arrangement);
        this.hLayout = arrangement;
        this.vLayout = arrangement2;
        this.backgroundPaint = null;
        this.legendItemGraphicEdge = RectangleEdge.LEFT;
        this.legendItemGraphicAnchor = RectangleAnchor.CENTER;
        this.legendItemGraphicLocation = RectangleAnchor.CENTER;
    }

    public LegendItemSource[] getSources() {
        return this.sources;
    }

    public void setSources(LegendItemSource[] legendItemSourceArray) {
        this.sources = legendItemSourceArray;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
    }

    public RectangleEdge getLegendItemGraphicEdge() {
        return this.legendItemGraphicEdge;
    }

    public void setLegendItemGraphicEdge(RectangleEdge rectangleEdge) {
        if (rectangleEdge == null) {
            throw new IllegalArgumentException("Null 'edge' argument.");
        }
        this.legendItemGraphicEdge = rectangleEdge;
    }

    public RectangleAnchor getLegendItemGraphicAnchor() {
        return this.legendItemGraphicAnchor;
    }

    public void setLegendItemGraphicAnchor(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' point.");
        }
        this.legendItemGraphicAnchor = rectangleAnchor;
    }

    public RectangleAnchor getLegendItemGraphicLocation() {
        return this.legendItemGraphicLocation;
    }

    public void setLegendItemGraphicLocation(RectangleAnchor rectangleAnchor) {
        this.legendItemGraphicLocation = rectangleAnchor;
    }

    protected void fetchLegendItems() {
        this.items.clear();
        RectangleEdge rectangleEdge = this.getPosition();
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            this.items.setArrangement(this.hLayout);
        } else {
            this.items.setArrangement(this.vLayout);
        }
        int n = 0;
        while (n < this.sources.length) {
            LegendItemCollection legendItemCollection = this.sources[n].getLegendItems();
            if (legendItemCollection != null) {
                int n2 = 0;
                while (n2 < legendItemCollection.getItemCount()) {
                    LegendItem legendItem = legendItemCollection.get(n2);
                    Block block = this.createLegendItemBlock(legendItem);
                    this.items.add(block);
                    ++n2;
                }
            }
            ++n;
        }
    }

    protected Block createLegendItemBlock(LegendItem legendItem) {
        BlockContainer blockContainer = null;
        LegendGraphic legendGraphic = new LegendGraphic(legendItem.getShape(), legendItem.getFillPaint());
        legendGraphic.setLine(legendItem.getLine());
        legendGraphic.setLineStroke(legendItem.getLineStroke());
        legendGraphic.setLinePaint(legendItem.getLinePaint());
        legendGraphic.setLineVisible(legendItem.isLineVisible());
        legendGraphic.setShapeVisible(legendItem.isShapeVisible());
        legendGraphic.setShapeOutlineVisible(legendItem.isShapeOutlineVisible());
        legendGraphic.setOutlinePaint(legendItem.getOutlinePaint());
        legendGraphic.setOutlineStroke(legendItem.getOutlineStroke());
        legendGraphic.setWidth(20.0);
        legendGraphic.setHeight(12.0);
        BlockContainer blockContainer2 = new BlockContainer(new BorderArrangement());
        legendGraphic.setShapeAnchor(this.legendItemGraphicAnchor);
        legendGraphic.setShapeLocation(this.getLegendItemGraphicLocation());
        blockContainer2.add(legendGraphic, this.legendItemGraphicEdge);
        blockContainer2.add(new LabelBlock(legendItem.getLabel()));
        blockContainer = new BlockContainer(new CenterArrangement());
        blockContainer.add(blockContainer2);
        return blockContainer;
    }

    public BlockContainer getItemContainer() {
        return this.items;
    }

    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = new Size2D();
        this.fetchLegendItems();
        if (this.items.isEmpty()) {
            return size2D;
        }
        BlockContainer blockContainer = this.wrapper;
        if (blockContainer == null) {
            blockContainer = this.items;
        }
        RectangleConstraint rectangleConstraint2 = this.toContentConstraint(rectangleConstraint);
        Size2D size2D2 = blockContainer.arrange(graphics2D, rectangleConstraint2);
        size2D.height = this.calculateTotalHeight(size2D2.height);
        size2D.width = this.calculateTotalWidth(size2D2.width);
        return size2D;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        rectangle2D2 = this.trimMargin(rectangle2D2);
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D2);
        }
        this.getBorder().draw(graphics2D, rectangle2D2);
        this.getBorder().getInsets().trim(rectangle2D2);
        BlockContainer blockContainer = this.wrapper;
        if (blockContainer == null) {
            blockContainer = this.items;
        }
        rectangle2D2 = this.trimPadding(rectangle2D2);
        blockContainer.draw(graphics2D, rectangle2D2);
    }

    public void setWrapper(BlockContainer blockContainer) {
        this.wrapper = blockContainer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LegendTitle)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        LegendTitle legendTitle = (LegendTitle)object;
        if (!ArrayUtilities.equalReferencesInArrays((Object[])this.sources, (Object[])legendTitle.sources)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.backgroundPaint, (Paint)legendTitle.backgroundPaint)) {
            return false;
        }
        if (this.legendItemGraphicEdge != legendTitle.legendItemGraphicEdge) {
            return false;
        }
        if (this.legendItemGraphicAnchor != legendTitle.legendItemGraphicAnchor) {
            return false;
        }
        if (this.legendItemGraphicLocation != legendTitle.legendItemGraphicLocation) {
            return false;
        }
        if (!this.hLayout.equals(legendTitle.hLayout)) {
            return false;
        }
        return this.vLayout.equals(legendTitle.vLayout);
    }
}

