/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYDifferenceRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private transient Paint positivePaint;
    private transient Paint negativePaint;
    private boolean plotShapes = true;

    public XYDifferenceRenderer() {
        this(Color.green, Color.red, false);
    }

    public XYDifferenceRenderer(Paint paint, Paint paint2, boolean bl) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'positivePaint' argument.");
        }
        if (paint2 == null) {
            throw new IllegalArgumentException("Null 'negativePaint' argument.");
        }
        this.positivePaint = paint;
        this.negativePaint = paint2;
        this.plotShapes = bl;
    }

    public Paint getPositivePaint() {
        return this.positivePaint;
    }

    public void setPositivePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.positivePaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getNegativePaint() {
        return this.negativePaint;
    }

    public void setNegativePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.negativePaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public void setPlotShapes(boolean bl) {
        this.plotShapes = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
    }

    public int getPassCount() {
        return 2;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (n3 == 0) {
            this.drawItemPass0(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState);
        } else if (n3 == 1) {
            this.drawItemPass1(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState);
        }
    }

    protected void drawItemPass0(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState) {
        if (n == 0) {
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d = xYDataset.getYValue(0, n2);
            double d2 = xYDataset.getXValue(1, n2);
            double d3 = xYDataset.getYValue(1, n2);
            double d4 = valueAxis2.valueToJava2D(d, rectangle2D, rectangleEdge2);
            double d5 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
            double d6 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
            if (n2 > 0) {
                Shape shape;
                double d7;
                double d8;
                double d9 = xYDataset.getXValue(0, n2 - 1);
                double d10 = xYDataset.getYValue(0, n2 - 1);
                double d11 = xYDataset.getYValue(1, n2 - 1);
                double d12 = valueAxis.valueToJava2D(d9, rectangle2D, rectangleEdge);
                Shape shape2 = this.getPositiveArea((float)d12, (float)(d8 = valueAxis2.valueToJava2D(d10, rectangle2D, rectangleEdge2)), (float)(d7 = valueAxis2.valueToJava2D(d11, rectangle2D, rectangleEdge2)), (float)d5, (float)d4, (float)d6, plotOrientation);
                if (shape2 != null) {
                    graphics2D.setPaint(this.getPositivePaint());
                    graphics2D.fill(shape2);
                }
                if ((shape = this.getNegativeArea((float)d12, (float)d8, (float)d7, (float)d5, (float)d4, (float)d6, plotOrientation)) != null) {
                    graphics2D.setPaint(this.getNegativePaint());
                    graphics2D.fill(shape);
                }
            }
        }
    }

    protected void drawItemPass1(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState) {
        Object object = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        if (n == 0) {
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d = xYDataset.getXValue(0, n2);
            double d2 = xYDataset.getYValue(0, n2);
            double d3 = xYDataset.getXValue(1, n2);
            double d4 = xYDataset.getYValue(1, n2);
            double d5 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
            double d6 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
            double d7 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
            double d8 = valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge2);
            if (n2 > 0) {
                double d9 = xYDataset.getXValue(0, n2 - 1);
                double d10 = xYDataset.getYValue(0, n2 - 1);
                double d11 = xYDataset.getXValue(1, n2 - 1);
                double d12 = xYDataset.getYValue(1, n2 - 1);
                double d13 = valueAxis.valueToJava2D(d9, rectangle2D, rectangleEdge);
                double d14 = valueAxis2.valueToJava2D(d10, rectangle2D, rectangleEdge2);
                double d15 = valueAxis.valueToJava2D(d11, rectangle2D, rectangleEdge);
                double d16 = valueAxis2.valueToJava2D(d12, rectangle2D, rectangleEdge2);
                Line2D.Double double_ = null;
                Line2D line2D = null;
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    double_ = new Line2D.Double(d6, d5, d14, d13);
                    line2D = new Line2D.Double(d8, d7, d16, d15);
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    double_ = new Line2D.Double(d5, d6, d13, d14);
                    line2D = new Line2D.Double(d7, d8, d15, d16);
                }
                if (double_ != null && double_.intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                    graphics2D.draw(double_);
                }
                if (line2D != null && line2D.intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(1, n2));
                    graphics2D.draw(line2D);
                }
            }
            if (this.getPlotShapes()) {
                Object object2;
                Object object3;
                Shape shape = this.getItemShape(n, n2);
                shape = plotOrientation == PlotOrientation.HORIZONTAL ? ShapeUtilities.createTranslatedShape((Shape)shape, (double)d6, (double)d5) : ShapeUtilities.createTranslatedShape((Shape)shape, (double)d5, (double)d6);
                if (shape.intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                    graphics2D.fill(shape);
                }
                object = shape;
                if (entityCollection != null) {
                    if (object == null) {
                        object = new Rectangle2D.Double(d5 - 2.0, d6 - 2.0, 4.0, 4.0);
                    }
                    object3 = null;
                    XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
                    if (xYToolTipGenerator != null) {
                        object3 = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
                    }
                    object2 = null;
                    if (this.getURLGenerator() != null) {
                        object2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
                    }
                    XYItemEntity xYItemEntity = new XYItemEntity((Shape)object, xYDataset, n, n2, (String)object3, (String)object2);
                    entityCollection.add(xYItemEntity);
                }
                object3 = this.getItemShape(n + 1, n2);
                if ((object3 = ShapeUtilities.createTranslatedShape((Shape)object3, (double)d7, (double)d8)).intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(n + 1, n2));
                    graphics2D.fill((Shape)object3);
                }
                object = object3;
                if (entityCollection != null) {
                    if (object == null) {
                        object = new Rectangle2D.Double(d7 - 2.0, d8 - 2.0, 4.0, 4.0);
                    }
                    String string = null;
                    object2 = this.getToolTipGenerator(n, n2);
                    if (object2 != null) {
                        string = object2.generateToolTip(xYDataset, n + 1, n2);
                    }
                    String string2 = null;
                    if (this.getURLGenerator() != null) {
                        string2 = this.getURLGenerator().generateURL(xYDataset, n + 1, n2);
                    }
                    XYItemEntity xYItemEntity = new XYItemEntity((Shape)object, xYDataset, n + 1, n2, string, string2);
                    entityCollection.add(xYItemEntity);
                }
            }
            this.updateCrosshairValues(crosshairState, d3, d4, d7, d8, plotOrientation);
        }
    }

    protected Shape getPositiveArea(float f, float f2, float f3, float f4, float f5, float f6, PlotOrientation plotOrientation) {
        boolean bl;
        GeneralPath generalPath = null;
        boolean bl2 = f2 >= f3;
        boolean bl3 = bl = f5 >= f6;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            bl2 = f3 >= f2;
            boolean bl4 = bl = f6 >= f5;
        }
        if (bl2) {
            if (bl) {
                generalPath = null;
            } else {
                float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
                GeneralPath generalPath2 = new GeneralPath();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    generalPath2.moveTo(f5, f4);
                    generalPath2.lineTo(fArray[1], fArray[0]);
                    generalPath2.lineTo(f6, f4);
                    generalPath2.closePath();
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f4, f5);
                    generalPath2.lineTo(fArray[0], fArray[1]);
                    generalPath2.lineTo(f4, f6);
                    generalPath2.closePath();
                }
                generalPath = generalPath2;
            }
        } else if (bl) {
            float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
            GeneralPath generalPath3 = new GeneralPath();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                generalPath3.moveTo(f2, f);
                generalPath3.lineTo(fArray[1], fArray[0]);
                generalPath3.lineTo(f3, f);
                generalPath3.closePath();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                generalPath3.moveTo(f, f2);
                generalPath3.lineTo(fArray[0], fArray[1]);
                generalPath3.lineTo(f, f3);
                generalPath3.closePath();
            }
            generalPath = generalPath3;
        } else {
            GeneralPath generalPath4 = new GeneralPath();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                generalPath4.moveTo(f2, f);
                generalPath4.lineTo(f5, f4);
                generalPath4.lineTo(f6, f4);
                generalPath4.lineTo(f3, f);
                generalPath4.closePath();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                generalPath4.moveTo(f, f2);
                generalPath4.lineTo(f4, f5);
                generalPath4.lineTo(f4, f6);
                generalPath4.lineTo(f, f3);
                generalPath4.closePath();
            }
            generalPath = generalPath4;
        }
        return generalPath;
    }

    protected Shape getNegativeArea(float f, float f2, float f3, float f4, float f5, float f6, PlotOrientation plotOrientation) {
        boolean bl;
        GeneralPath generalPath = null;
        boolean bl2 = f2 >= f3;
        boolean bl3 = bl = f5 >= f6;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            bl2 = f3 >= f2;
            boolean bl4 = bl = f6 >= f5;
        }
        if (bl2) {
            if (bl) {
                GeneralPath generalPath2 = new GeneralPath();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    generalPath2.moveTo(f2, f);
                    generalPath2.lineTo(f5, f4);
                    generalPath2.lineTo(f6, f4);
                    generalPath2.lineTo(f3, f);
                    generalPath2.closePath();
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f, f2);
                    generalPath2.lineTo(f4, f5);
                    generalPath2.lineTo(f4, f6);
                    generalPath2.lineTo(f, f3);
                    generalPath2.closePath();
                }
                generalPath = generalPath2;
            } else {
                float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
                GeneralPath generalPath3 = new GeneralPath();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    generalPath3.moveTo(f2, f);
                    generalPath3.lineTo(fArray[1], fArray[0]);
                    generalPath3.lineTo(f3, f);
                    generalPath3.closePath();
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath3.moveTo(f, f2);
                    generalPath3.lineTo(fArray[0], fArray[1]);
                    generalPath3.lineTo(f, f3);
                    generalPath3.closePath();
                }
                generalPath = generalPath3;
            }
        } else if (bl) {
            float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
            GeneralPath generalPath4 = new GeneralPath();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                generalPath4.moveTo(f5, f4);
                generalPath4.lineTo(fArray[1], fArray[0]);
                generalPath4.lineTo(f6, f4);
                generalPath4.closePath();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                generalPath4.moveTo(f4, f5);
                generalPath4.lineTo(fArray[0], fArray[1]);
                generalPath4.lineTo(f4, f6);
                generalPath4.closePath();
            }
            generalPath = generalPath4;
        }
        return generalPath;
    }

    private float[] getIntersection(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = (f7 - f5) * (f2 - f6) - (f8 - f6) * (f - f5);
        float f10 = (f8 - f6) * (f3 - f) - (f7 - f5) * (f4 - f2);
        float f11 = f9 / f10;
        float[] fArray = new float[]{f + f11 * (f3 - f), f2 + f11 * (f4 - f2)};
        return fArray;
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null && this.getItemVisible(n2, 0)) {
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n2);
            Paint paint = this.getSeriesPaint(n2);
            Stroke stroke = this.getSeriesStroke(n2);
            Line2D.Double double_ = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
            legendItem = new LegendItem(string, string2, double_, stroke, paint);
        }
        return legendItem;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.positivePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.negativePaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.positivePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.negativePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

