/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.Effect3D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.ShapeUtilities;

public class LineRenderer3D
extends LineAndShapeRenderer
implements Effect3D {
    public static final double DEFAULT_X_OFFSET = 12.0;
    public static final double DEFAULT_Y_OFFSET = 8.0;
    public static final Paint DEFAULT_WALL_PAINT = new Color(221, 221, 221);
    private double xOffset = 12.0;
    private double yOffset = 8.0;
    private transient Paint wallPaint = DEFAULT_WALL_PAINT;

    public LineRenderer3D() {
        super(true, false);
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public void setxOffset(double d) {
        this.xOffset = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setyOffset(double d) {
        this.yOffset = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getWallPaint() {
        return this.wallPaint;
    }

    public void setWallPaint(Paint paint) {
        this.wallPaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void drawBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = f + (float)Math.abs(this.xOffset);
        float f3 = (float)rectangle2D.getMaxX();
        float f4 = f3 - (float)Math.abs(this.xOffset);
        float f5 = (float)rectangle2D.getMaxY();
        float f6 = f5 - (float)Math.abs(this.yOffset);
        float f7 = (float)rectangle2D.getMinY();
        float f8 = f7 + (float)Math.abs(this.yOffset);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f5);
        generalPath.lineTo(f, f8);
        generalPath.lineTo(f2, f7);
        generalPath.lineTo(f3, f7);
        generalPath.lineTo(f3, f6);
        generalPath.lineTo(f4, f5);
        generalPath.closePath();
        Paint paint = categoryPlot.getBackgroundPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath);
        }
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(f, f5);
        generalPath2.lineTo(f, f8);
        generalPath2.lineTo(f2, f7);
        generalPath2.lineTo(f2, f6);
        generalPath2.closePath();
        graphics2D.setPaint(this.getWallPaint());
        graphics2D.fill(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo(f, f5);
        generalPath3.lineTo(f2, f6);
        generalPath3.lineTo(f3, f6);
        generalPath3.lineTo(f4, f5);
        generalPath3.closePath();
        graphics2D.setPaint(this.getWallPaint());
        graphics2D.fill(generalPath3);
        graphics2D.setPaint(Color.lightGray);
        Line2D.Double double_ = new Line2D.Double(f, f5, f2, f6);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(f2, f6, f2, f7);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(f2, f6, f3, f6);
        graphics2D.draw(double_);
        Image image = categoryPlot.getBackgroundImage();
        if (image != null) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(2, categoryPlot.getBackgroundAlpha()));
            graphics2D.drawImage(image, (int)f2, (int)f7, (int)(f3 - f2 + 1.0f), (int)(f6 - f7 + 1.0f), null);
            graphics2D.setComposite(composite);
        }
    }

    public void drawOutline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = f + (float)Math.abs(this.xOffset);
        float f3 = (float)rectangle2D.getMaxX();
        float f4 = f3 - (float)Math.abs(this.xOffset);
        float f5 = (float)rectangle2D.getMaxY();
        float f6 = f5 - (float)Math.abs(this.yOffset);
        float f7 = (float)rectangle2D.getMinY();
        float f8 = f7 + (float)Math.abs(this.yOffset);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f5);
        generalPath.lineTo(f, f8);
        generalPath.lineTo(f2, f7);
        generalPath.lineTo(f3, f7);
        generalPath.lineTo(f3, f6);
        generalPath.lineTo(f4, f5);
        generalPath.closePath();
        Stroke stroke = categoryPlot.getOutlineStroke();
        Paint paint = categoryPlot.getOutlinePaint();
        if (stroke != null && paint != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(generalPath);
        }
    }

    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d) {
        double d2;
        Line2D.Double double_ = null;
        Line2D.Double double_2 = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d2 = d;
            double d3 = d - this.getYOffset();
            double d4 = rectangle2D.getMinX();
            double d5 = d4 + this.getXOffset();
            double d6 = rectangle2D.getMaxY();
            double_ = new Line2D.Double(d4, d2, d5, d3);
            double_2 = new Line2D.Double(d5, d3, d6, d3);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d2 = d;
            double d7 = d + this.getXOffset();
            double d8 = rectangle2D.getMaxY();
            double d9 = d8 - this.getYOffset();
            double d10 = rectangle2D.getMinY();
            double_ = new Line2D.Double(d2, d8, d7, d9);
            double_2 = new Line2D.Double(d7, d9, d7, d10);
        }
        Paint paint = categoryPlot.getDomainGridlinePaint();
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        double d2;
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        Line2D.Double double_2 = null;
        Line2D.Double double_3 = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d2 = valueAxis.valueToJava2D(d, double_, categoryPlot.getRangeAxisEdge());
            double d3 = d2 + this.getXOffset();
            double d4 = rectangle2D.getMaxY();
            double d5 = d4 - this.getYOffset();
            double d6 = rectangle2D.getMinY();
            double_2 = new Line2D.Double(d2, d4, d3, d5);
            double_3 = new Line2D.Double(d3, d5, d3, d6);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d2 = valueAxis.valueToJava2D(d, double_, categoryPlot.getRangeAxisEdge());
            double d7 = d2 - this.getYOffset();
            double d8 = rectangle2D.getMinX();
            double d9 = d8 + this.getXOffset();
            double d10 = rectangle2D.getMaxX();
            double_2 = new Line2D.Double(d8, d2, d9, d7);
            double_3 = new Line2D.Double(d9, d7, d10, d7);
        }
        Paint paint = categoryPlot.getRangeGridlinePaint();
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_2);
        graphics2D.draw(double_3);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d)) {
                return;
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
            GeneralPath generalPath = null;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                float f = (float)valueAxis.valueToJava2D(d, double_, categoryPlot.getRangeAxisEdge());
                float f2 = (float)double_.getMaxY();
                generalPath = new GeneralPath();
                generalPath.moveTo(f, f2);
                generalPath.lineTo((float)((double)f + this.getXOffset()), f2 - (float)this.getYOffset());
                generalPath.lineTo((float)((double)f + this.getXOffset()), (float)(double_.getMinY() - this.getYOffset()));
                generalPath.lineTo(f, (float)double_.getMinY());
                generalPath.closePath();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                float f = (float)valueAxis.valueToJava2D(d, double_, categoryPlot.getRangeAxisEdge());
                float f3 = (float)rectangle2D.getX();
                generalPath = new GeneralPath();
                generalPath.moveTo(f3, f);
                generalPath.lineTo(f3 + (float)this.xOffset, f - (float)this.yOffset);
                generalPath.lineTo((float)(double_.getMaxX() + this.xOffset), f - (float)this.yOffset);
                generalPath.lineTo((float)double_.getMaxX(), f);
                generalPath.closePath();
            }
            graphics2D.setPaint(marker.getPaint());
            graphics2D.fill(generalPath);
            graphics2D.setPaint(marker.getOutlinePaint());
            graphics2D.draw(generalPath);
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Object object;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), double_, categoryPlot.getDomainAxisEdge());
        double d2 = number.doubleValue();
        double d3 = valueAxis.valueToJava2D(d2, double_, categoryPlot.getRangeAxisEdge());
        Shape shape = this.getItemShape(n, n2);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)d3, (double)d);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)d, (double)d3);
        }
        if (this.isLinesVisible() && n2 != 0 && (object = categoryDataset.getValue(n, n2 - 1)) != null) {
            double d4 = ((Number)object).doubleValue();
            double d5 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), double_, categoryPlot.getDomainAxisEdge());
            double d6 = valueAxis.valueToJava2D(d4, double_, categoryPlot.getRangeAxisEdge());
            double d7 = d5 + this.getXOffset();
            double d8 = d6 - this.getYOffset();
            double d9 = d + this.getXOffset();
            double d10 = d3 - this.getYOffset();
            GeneralPath generalPath = new GeneralPath();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                generalPath.moveTo((float)d6, (float)d5);
                generalPath.lineTo((float)d3, (float)d);
                generalPath.lineTo((float)d10, (float)d9);
                generalPath.lineTo((float)d8, (float)d7);
                generalPath.lineTo((float)d6, (float)d5);
                generalPath.closePath();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                generalPath.moveTo((float)d5, (float)d6);
                generalPath.lineTo((float)d, (float)d3);
                generalPath.lineTo((float)d9, (float)d10);
                generalPath.lineTo((float)d7, (float)d8);
                generalPath.lineTo((float)d5, (float)d6);
                generalPath.closePath();
            }
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.fill(generalPath);
            graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(generalPath);
        }
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d, d3, d2 < 0.0);
        }
        if (categoryItemRendererState.getInfo() != null && (object = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null && shape != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(shape, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            object.add(categoryItemEntity);
        }
    }
}

