/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class LevelRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    public static final double DEFAULT_ITEM_MARGIN = 0.2;
    private double itemMargin = 0.2;
    private double maxItemWidth = 1.0;

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d) {
        this.itemMargin = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public double getMaxItemWidth() {
        return this.maxItemWidth;
    }

    public void setMaxItemWidth(double d) {
        this.maxItemWidth = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, int n, PlotRenderingInfo plotRenderingInfo) {
        CategoryItemRendererState categoryItemRendererState = super.initialise(graphics2D, rectangle2D, categoryPlot, n, plotRenderingInfo);
        this.calculateItemWidth(categoryPlot, rectangle2D, n, categoryItemRendererState);
        return categoryItemRendererState;
    }

    protected void calculateItemWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            double d = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = d * this.getMaxItemWidth();
            double d3 = 0.0;
            double d4 = 0.0;
            if (n2 > 1) {
                d3 = categoryAxis.getCategoryMargin();
            }
            if (n3 > 1) {
                d4 = this.getItemMargin();
            }
            double d5 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d3 - d4);
            if (n3 * n2 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d5 / (double)(n3 * n2), d2));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d5, d2));
            }
        }
    }

    protected double calculateBarW0(CategoryPlot categoryPlot, PlotOrientation plotOrientation, Rectangle2D rectangle2D, CategoryAxis categoryAxis, CategoryItemRendererState categoryItemRendererState, int n, int n2) {
        double d = 0.0;
        d = plotOrientation == PlotOrientation.HORIZONTAL ? rectangle2D.getHeight() : rectangle2D.getWidth();
        double d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            double d3 = d * this.getItemMargin() / (double)(n4 * (n3 - 1));
            double d4 = this.calculateSeriesWidth(d, categoryAxis, n4, n3);
            d2 = d2 + (double)n * (d4 + d3) + d4 / 2.0 - categoryItemRendererState.getBarWidth() / 2.0;
        } else {
            d2 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        }
        return d2;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        Line2D.Double double_ = null;
        double d4 = 0.0;
        double d5 = 0.0;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d4 = d3;
            d5 = d2 + categoryItemRendererState.getBarWidth() / 2.0;
            double_ = new Line2D.Double(d3, d2, d3, d2 + categoryItemRendererState.getBarWidth());
        } else {
            d4 = d2 + categoryItemRendererState.getBarWidth() / 2.0;
            d5 = d3;
            double_ = new Line2D.Double(d2, d3, d2 + categoryItemRendererState.getBarWidth(), d3);
        }
        Stroke stroke = this.getItemStroke(n, n2);
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
        CategoryLabelGenerator categoryLabelGenerator = this.getLabelGenerator(n, n2);
        if (categoryLabelGenerator != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d4, d5, d < 0.0);
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_.getBounds(), string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            entityCollection.add(categoryItemEntity);
        }
    }

    protected double calculateSeriesWidth(double d, CategoryAxis categoryAxis, int n, int n2) {
        double d2 = 1.0 - this.getItemMargin() - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin();
        if (n > 1) {
            d2 -= categoryAxis.getCategoryMargin();
        }
        return d * d2 / (double)(n * n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof LevelRenderer) {
            LevelRenderer levelRenderer = (LevelRenderer)object;
            boolean bl = this.itemMargin == levelRenderer.itemMargin;
            return bl;
        }
        return false;
    }
}

