/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class GroupedStackedBarRenderer
extends StackedBarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private KeyToGroupMap seriesToGroupMap = new KeyToGroupMap();

    public void setSeriesToGroupMap(KeyToGroupMap keyToGroupMap) {
        if (keyToGroupMap == null) {
            throw new IllegalArgumentException("Null 'map' argument.");
        }
        this.seriesToGroupMap = keyToGroupMap;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        Range range = DatasetUtilities.findStackedRangeBounds(categoryDataset, this.seriesToGroupMap);
        return range;
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = categoryPlot.getDomainAxisForDataset(n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = d * this.getMaxBarWidth();
            int n2 = this.seriesToGroupMap.getGroupCount();
            int n3 = categoryDataset.getColumnCount();
            int n4 = n2 * n3;
            double d3 = 0.0;
            double d4 = 0.0;
            if (n3 > 1) {
                d3 = categoryAxis.getCategoryMargin();
            }
            if (n2 > 1) {
                d4 = this.getItemMargin();
            }
            double d5 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d3 - d4);
            if (n4 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d5 / (double)n4, d2));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d5, d2));
            }
        }
    }

    protected double calculateBarW0(CategoryPlot categoryPlot, PlotOrientation plotOrientation, Rectangle2D rectangle2D, CategoryAxis categoryAxis, CategoryItemRendererState categoryItemRendererState, int n, int n2) {
        double d = 0.0;
        d = plotOrientation == PlotOrientation.HORIZONTAL ? rectangle2D.getHeight() : rectangle2D.getWidth();
        double d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n3 = this.seriesToGroupMap.getGroupCount();
        int n4 = this.seriesToGroupMap.getGroupIndex(this.seriesToGroupMap.getGroup(categoryPlot.getDataset().getRowKey(n)));
        int n5 = this.getColumnCount();
        if (n3 > 1) {
            double d3 = d * this.getItemMargin() / (double)(n5 * (n3 - 1));
            double d4 = this.calculateSeriesWidth(d, categoryAxis, n5, n3);
            d2 = d2 + (double)n4 * (d4 + d3) + d4 / 2.0 - categoryItemRendererState.getBarWidth() / 2.0;
        } else {
            d2 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        }
        return d2;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        Object object;
        double d;
        double d2;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d3 = number.doubleValue();
        Comparable comparable = this.seriesToGroupMap.getGroup(categoryDataset.getRowKey(n));
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d4 = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
        double d5 = 0.0;
        double d6 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            Number number2;
            if (comparable.equals(this.seriesToGroupMap.getGroup(categoryDataset.getRowKey(n4))) && (number2 = categoryDataset.getValue(n4, n2)) != null) {
                d2 = number2.doubleValue();
                if (d2 > 0.0) {
                    d5 += d2;
                } else {
                    d6 += d2;
                }
            }
            ++n4;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        if (d3 > 0.0) {
            d = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
            d2 = valueAxis.valueToJava2D(d5 + d3, rectangle2D, rectangleEdge);
        } else {
            d = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge);
            d2 = valueAxis.valueToJava2D(d6 + d3, rectangle2D, rectangleEdge);
        }
        double d7 = Math.min(d, d2);
        double d8 = Math.max(Math.abs(d2 - d), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d7, d4, d8, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d4, d7, categoryItemRendererState.getBarWidth(), d8);
        Paint paint = this.getItemPaint(n, n2);
        if (this.getGradientPaintTransformer() != null && paint instanceof GradientPaint) {
            object = (GradientPaint)paint;
            paint = this.getGradientPaintTransformer().transform((GradientPaint)object, (Shape)double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_);
        }
        if ((object = this.getLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, (CategoryLabelGenerator)object, double_, d3 < 0.0);
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            entityCollection.add(categoryItemEntity);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GroupedStackedBarRenderer && super.equals(object)) {
            GroupedStackedBarRenderer groupedStackedBarRenderer = (GroupedStackedBarRenderer)object;
            return groupedStackedBarRenderer.seriesToGroupMap.equals(this.seriesToGroupMap);
        }
        return false;
    }
}

