/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.LengthAdjustmentType;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public abstract class AbstractCategoryItemRenderer
extends AbstractRenderer
implements CategoryItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private CategoryPlot plot;
    private CategoryLabelGenerator labelGenerator = null;
    private ObjectList labelGeneratorList = new ObjectList();
    private CategoryLabelGenerator baseLabelGenerator;
    private CategoryToolTipGenerator toolTipGenerator = null;
    private ObjectList toolTipGeneratorList = new ObjectList();
    private CategoryToolTipGenerator baseToolTipGenerator;
    private CategoryURLGenerator itemURLGenerator = null;
    private ObjectList itemURLGeneratorList = new ObjectList();
    private CategoryURLGenerator baseItemURLGenerator;
    private transient int rowCount;
    private transient int columnCount;

    protected AbstractCategoryItemRenderer() {
    }

    public int getPassCount() {
        return 1;
    }

    public CategoryPlot getPlot() {
        return this.plot;
    }

    public void setPlot(CategoryPlot categoryPlot) {
        if (categoryPlot == null) {
            throw new IllegalArgumentException("Null 'plot' argument.");
        }
        this.plot = categoryPlot;
    }

    public CategoryLabelGenerator getLabelGenerator(int n, int n2) {
        return this.getSeriesLabelGenerator(n);
    }

    public CategoryLabelGenerator getSeriesLabelGenerator(int n) {
        if (this.labelGenerator != null) {
            return this.labelGenerator;
        }
        CategoryLabelGenerator categoryLabelGenerator = (CategoryLabelGenerator)this.labelGeneratorList.get(n);
        if (categoryLabelGenerator == null) {
            categoryLabelGenerator = this.baseLabelGenerator;
        }
        return categoryLabelGenerator;
    }

    public void setLabelGenerator(CategoryLabelGenerator categoryLabelGenerator) {
        this.labelGenerator = categoryLabelGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesLabelGenerator(int n, CategoryLabelGenerator categoryLabelGenerator) {
        this.labelGeneratorList.set(n, (Object)categoryLabelGenerator);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryLabelGenerator getBaseLabelGenerator() {
        return this.baseLabelGenerator;
    }

    public void setBaseLabelGenerator(CategoryLabelGenerator categoryLabelGenerator) {
        this.baseLabelGenerator = categoryLabelGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryToolTipGenerator getToolTipGenerator(int n, int n2) {
        CategoryToolTipGenerator categoryToolTipGenerator = null;
        if (this.toolTipGenerator != null) {
            categoryToolTipGenerator = this.toolTipGenerator;
        } else {
            categoryToolTipGenerator = this.getSeriesToolTipGenerator(n);
            if (categoryToolTipGenerator == null) {
                categoryToolTipGenerator = this.baseToolTipGenerator;
            }
        }
        return categoryToolTipGenerator;
    }

    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        this.toolTipGenerator = categoryToolTipGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryToolTipGenerator getSeriesToolTipGenerator(int n) {
        return (CategoryToolTipGenerator)this.toolTipGeneratorList.get(n);
    }

    public void setSeriesToolTipGenerator(int n, CategoryToolTipGenerator categoryToolTipGenerator) {
        this.toolTipGeneratorList.set(n, (Object)categoryToolTipGenerator);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    public void setBaseToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        this.baseToolTipGenerator = categoryToolTipGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public CategoryURLGenerator getItemURLGenerator(int n, int n2) {
        return this.getSeriesItemURLGenerator(n);
    }

    public CategoryURLGenerator getSeriesItemURLGenerator(int n) {
        if (this.itemURLGenerator != null) {
            return this.itemURLGenerator;
        }
        CategoryURLGenerator categoryURLGenerator = (CategoryURLGenerator)this.itemURLGeneratorList.get(n);
        if (categoryURLGenerator == null) {
            categoryURLGenerator = this.baseItemURLGenerator;
        }
        return categoryURLGenerator;
    }

    public void setItemURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.itemURLGenerator = categoryURLGenerator;
    }

    public void setSeriesItemURLGenerator(int n, CategoryURLGenerator categoryURLGenerator) {
        this.itemURLGeneratorList.set(n, (Object)categoryURLGenerator);
    }

    public CategoryURLGenerator getBaseItemURLGenerator() {
        return this.baseItemURLGenerator;
    }

    public void setBaseItemURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.baseItemURLGenerator = categoryURLGenerator;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, int n, PlotRenderingInfo plotRenderingInfo) {
        this.setPlot(categoryPlot);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            this.rowCount = categoryDataset.getRowCount();
            this.columnCount = categoryDataset.getColumnCount();
        } else {
            this.rowCount = 0;
            this.columnCount = 0;
        }
        return new CategoryItemRendererState(plotRenderingInfo);
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return DatasetUtilities.findRangeBounds(categoryDataset);
    }

    public void drawBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawBackground(graphics2D, rectangle2D);
    }

    public void drawOutline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawOutline(graphics2D, rectangle2D);
    }

    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d) {
        Line2D.Double double_ = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d, rectangle2D.getMinY(), d, rectangle2D.getMaxY());
        }
        Paint paint = categoryPlot.getDomainGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        Paint paint = categoryPlot.getRangeGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d)) {
                return;
            }
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            }
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), marker.getLabelOffsetTypeForDomain(), marker.getLabelOffsetTypeForRange(), rectangleAnchor);
                TextUtilities.drawAlignedString((String)string, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)marker.getLabelTextAnchor());
            }
        } else if (marker instanceof IntervalMarker) {
            GradientPaintTransformer gradientPaintTransformer;
            Object object;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d = intervalMarker.getStartValue();
            double d3 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d, d3)) {
                return;
            }
            d = range.constrain(d);
            d3 = range.constrain(d3);
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(d4, rectangle2D.getMinY(), d5 - d4, rectangle2D.getHeight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), Math.min(d4, d5), rectangle2D.getWidth(), Math.abs(d5 - d4));
            }
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object = (GradientPaint)paint;
                gradientPaintTransformer = intervalMarker.getGradientPaintTransformer();
                if (gradientPaintTransformer != null) {
                    object = gradientPaintTransformer.transform((GradientPaint)object, (Shape)double_);
                }
                graphics2D.setPaint((Paint)object);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            object = marker.getLabel();
            gradientPaintTransformer = marker.getLabelAnchor();
            if (object != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), marker.getLabelOffsetTypeForDomain(), marker.getLabelOffsetTypeForRange(), (RectangleAnchor)gradientPaintTransformer);
                TextUtilities.drawAlignedString((String)object, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)marker.getLabelTextAnchor());
            }
        }
    }

    private Point2D calculateRangeMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, LengthAdjustmentType lengthAdjustmentType2, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType2, lengthAdjustmentType);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, lengthAdjustmentType2);
        }
        return RectangleAnchor.coordinates((Rectangle2D)rectangle2D3, (RectangleAnchor)rectangleAnchor);
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        String string2 = string = categoryDataset.getRowKey(n2).toString();
        Shape shape = this.getSeriesShape(n2);
        Paint paint = this.getSeriesPaint(n2);
        Paint paint2 = this.getSeriesOutlinePaint(n2);
        Stroke stroke = this.getSeriesOutlineStroke(n2);
        return new LegendItem(string, string2, shape, paint, stroke, paint2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractCategoryItemRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)object;
        if (!ObjectUtilities.equal((Object)this.labelGenerator, (Object)abstractCategoryItemRenderer.labelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.labelGeneratorList, (Object)abstractCategoryItemRenderer.labelGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.baseLabelGenerator, (Object)abstractCategoryItemRenderer.baseLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.toolTipGenerator, (Object)abstractCategoryItemRenderer.toolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.toolTipGeneratorList, (Object)abstractCategoryItemRenderer.toolTipGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.baseToolTipGenerator, (Object)abstractCategoryItemRenderer.baseToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.itemURLGenerator, (Object)abstractCategoryItemRenderer.itemURLGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.itemURLGeneratorList, (Object)abstractCategoryItemRenderer.itemURLGeneratorList)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.baseItemURLGenerator, (Object)abstractCategoryItemRenderer.baseItemURLGenerator);
    }

    public int hashCode() {
        int n = super.hashCode();
        return n;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot != null) {
            drawingSupplier = categoryPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    protected void drawItemLabel(Graphics2D graphics2D, PlotOrientation plotOrientation, CategoryDataset categoryDataset, int n, int n2, double d, double d2, boolean bl) {
        CategoryLabelGenerator categoryLabelGenerator = this.getLabelGenerator(n, n2);
        if (categoryLabelGenerator != null) {
            Font font = this.getItemLabelFont(n, n2);
            Paint paint = this.getItemLabelPaint(n, n2);
            graphics2D.setFont(font);
            graphics2D.setPaint(paint);
            String string = categoryLabelGenerator.generateLabel(categoryDataset, n, n2);
            ItemLabelPosition itemLabelPosition = null;
            itemLabelPosition = !bl ? this.getPositiveItemLabelPosition(n, n2) : this.getNegativeItemLabelPosition(n, n2);
            Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), d, d2, plotOrientation);
            TextUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)itemLabelPosition.getTextAnchor(), (double)itemLabelPosition.getAngle(), (TextAnchor)itemLabelPosition.getRotationAnchor());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PublicCloneable publicCloneable;
        AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)super.clone();
        if (this.labelGenerator != null) {
            if (this.labelGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)this.labelGenerator;
                abstractCategoryItemRenderer.labelGenerator = (CategoryLabelGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("ItemLabelGenerator not cloneable.");
            }
        }
        if (this.labelGeneratorList != null) {
            abstractCategoryItemRenderer.labelGeneratorList = (ObjectList)this.labelGeneratorList.clone();
        }
        if (this.baseLabelGenerator != null) {
            if (this.baseLabelGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)this.baseLabelGenerator;
                abstractCategoryItemRenderer.baseLabelGenerator = (CategoryLabelGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("ItemLabelGenerator not cloneable.");
            }
        }
        if (this.toolTipGenerator != null) {
            if (this.toolTipGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)this.toolTipGenerator;
                abstractCategoryItemRenderer.toolTipGenerator = (CategoryToolTipGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Tool tip generator not cloneable.");
            }
        }
        if (this.toolTipGeneratorList != null) {
            abstractCategoryItemRenderer.toolTipGeneratorList = (ObjectList)this.toolTipGeneratorList.clone();
        }
        if (this.baseToolTipGenerator != null) {
            if (this.baseToolTipGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)this.baseToolTipGenerator;
                abstractCategoryItemRenderer.baseToolTipGenerator = (CategoryToolTipGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Base tool tip generator not cloneable.");
            }
        }
        if (this.itemURLGenerator != null) {
            if (this.itemURLGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)this.itemURLGenerator;
                abstractCategoryItemRenderer.itemURLGenerator = (CategoryURLGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Item URL generator not cloneable.");
            }
        }
        if (this.itemURLGeneratorList != null) {
            abstractCategoryItemRenderer.itemURLGeneratorList = (ObjectList)this.itemURLGeneratorList.clone();
        }
        if (this.baseItemURLGenerator != null) {
            if (this.baseItemURLGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)this.baseItemURLGenerator;
                abstractCategoryItemRenderer.baseItemURLGenerator = (CategoryURLGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Base item URL generator not cloneable.");
            }
        }
        return abstractCategoryItemRenderer;
    }

    protected CategoryAxis getDomainAxis(CategoryPlot categoryPlot, int n) {
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis(n);
        if (categoryAxis == null) {
            categoryAxis = categoryPlot.getDomainAxis();
        }
        return categoryAxis;
    }

    protected ValueAxis getRangeAxis(CategoryPlot categoryPlot, int n) {
        ValueAxis valueAxis = categoryPlot.getRangeAxis(n);
        if (valueAxis == null) {
            valueAxis = categoryPlot.getRangeAxis();
        }
        return valueAxis;
    }

    public LegendItemCollection getLegendItems() {
        if (this.plot == null) {
            return new LegendItemCollection();
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        int n = this.plot.getIndexOf(this);
        CategoryDataset categoryDataset = this.plot.getDataset(n);
        if (categoryDataset != null) {
            int n2 = categoryDataset.getRowCount();
            int n3 = 0;
            while (n3 < n2) {
                LegendItem legendItem = this.getLegendItem(n, n3);
                if (legendItem != null) {
                    legendItemCollection.add(legendItem);
                }
                ++n3;
            }
        }
        return legendItemCollection;
    }
}

