/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.io.SerialUtilities;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextMeasurer;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Align;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public abstract class Plot
implements AxisChangeListener,
DatasetChangeListener,
LegendItemSource,
PublicCloneable,
Cloneable,
Serializable {
    public static final Number ZERO = new Integer(0);
    public static final Insets DEFAULT_INSETS = new Insets(4, 8, 4, 8);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(0.5f);
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final float DEFAULT_FOREGROUND_ALPHA = 1.0f;
    public static final float DEFAULT_BACKGROUND_ALPHA = 1.0f;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    public static final int MINIMUM_WIDTH_TO_DRAW = 10;
    public static final int MINIMUM_HEIGHT_TO_DRAW = 10;
    public static final Shape DEFAULT_LEGEND_ITEM_BOX = new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
    public static final Shape DEFAULT_LEGEND_ITEM_CIRCLE = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    private Plot parent = null;
    private DatasetGroup datasetGroup;
    private String noDataMessage;
    private Font noDataMessageFont;
    private transient Paint noDataMessagePaint;
    private Insets insets;
    private transient Stroke outlineStroke;
    private transient Paint outlinePaint;
    private transient Paint backgroundPaint;
    private transient Image backgroundImage;
    private int backgroundImageAlignment = 15;
    private float foregroundAlpha;
    private float backgroundAlpha;
    private DrawingSupplier drawingSupplier;
    private transient EventListenerList listenerList;
    private double dataAreaRatio = 0.0;
    static /* synthetic */ Class class$0;

    protected Plot() {
        this.insets = new Insets(Plot.DEFAULT_INSETS.top, Plot.DEFAULT_INSETS.left, Plot.DEFAULT_INSETS.bottom, Plot.DEFAULT_INSETS.right);
        this.backgroundPaint = DEFAULT_BACKGROUND_PAINT;
        this.backgroundAlpha = 1.0f;
        this.backgroundImage = null;
        this.outlineStroke = DEFAULT_OUTLINE_STROKE;
        this.outlinePaint = DEFAULT_OUTLINE_PAINT;
        this.foregroundAlpha = 1.0f;
        this.noDataMessage = null;
        this.noDataMessageFont = new Font("SansSerif", 0, 12);
        this.noDataMessagePaint = Color.black;
        this.drawingSupplier = new DefaultDrawingSupplier();
        this.listenerList = new EventListenerList();
    }

    public DatasetGroup getDatasetGroup() {
        return this.datasetGroup;
    }

    protected void setDatasetGroup(DatasetGroup datasetGroup) {
        this.datasetGroup = datasetGroup;
    }

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public void setNoDataMessage(String string) {
        this.noDataMessage = string;
    }

    public Font getNoDataMessageFont() {
        return this.noDataMessageFont;
    }

    public void setNoDataMessageFont(Font font) {
        this.noDataMessageFont = font;
    }

    public Paint getNoDataMessagePaint() {
        return this.noDataMessagePaint;
    }

    public void setNoDataMessagePaint(Paint paint) {
        this.noDataMessagePaint = paint;
    }

    public abstract String getPlotType();

    public Plot getParent() {
        return this.parent;
    }

    public void setParent(Plot plot) {
        this.parent = plot;
    }

    public Plot getRootPlot() {
        Plot plot = this.getParent();
        if (plot == null) {
            return this;
        }
        return plot.getRootPlot();
    }

    public boolean isSubplot() {
        return this.getParent() != null;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.setInsets(insets, true);
    }

    public void setInsets(Insets insets, boolean bl) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        if (!this.insets.equals(insets)) {
            this.insets = insets;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            if (this.backgroundPaint != null) {
                this.backgroundPaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.backgroundPaint != null && this.backgroundPaint.equals(paint)) {
                return;
            }
            this.backgroundPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float f) {
        if (this.backgroundAlpha != f) {
            this.backgroundAlpha = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        Plot plot = this.getParent();
        drawingSupplier = plot != null ? plot.getDrawingSupplier() : this.drawingSupplier;
        return drawingSupplier;
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        this.drawingSupplier = drawingSupplier;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getBackgroundImageAlignment() {
        return this.backgroundImageAlignment;
    }

    public void setBackgroundImageAlignment(int n) {
        if (this.backgroundImageAlignment != n) {
            this.backgroundImageAlignment = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            if (this.outlineStroke != null) {
                this.outlineStroke = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlineStroke != null && this.outlineStroke.equals(stroke)) {
                return;
            }
            this.outlineStroke = stroke;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            if (this.outlinePaint != null) {
                this.outlinePaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlinePaint != null && this.outlinePaint.equals(paint)) {
                return;
            }
            this.outlinePaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float f) {
        if (this.foregroundAlpha != f) {
            this.foregroundAlpha = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void addChangeListener(PlotChangeListener plotChangeListener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.event.PlotChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, plotChangeListener);
    }

    public void removeChangeListener(PlotChangeListener plotChangeListener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.event.PlotChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, plotChangeListener);
    }

    public void notifyListeners(PlotChangeEvent plotChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jfree.chart.event.PlotChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((PlotChangeListener)objectArray[n + 1]).plotChanged(plotChangeEvent);
            }
            n -= 2;
        }
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, PlotState var3, PlotRenderingInfo var4);

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        this.draw(graphics2D, rectangle2D, plotState, plotRenderingInfo);
    }

    public void drawBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.fillBackground(graphics2D, rectangle2D);
        this.drawBackgroundImage(graphics2D, rectangle2D);
    }

    protected void fillBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.backgroundPaint != null) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundAlpha));
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
            graphics2D.setComposite(composite);
        }
    }

    protected void drawBackgroundImage(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.backgroundImage != null) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(2, this.backgroundAlpha));
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null));
            Align.align((Rectangle2D)double_, (Rectangle2D)rectangle2D, (int)this.backgroundImageAlignment);
            graphics2D.drawImage(this.backgroundImage, (int)((RectangularShape)double_).getX(), (int)((RectangularShape)double_).getY(), (int)((RectangularShape)double_).getWidth() + 1, (int)((RectangularShape)double_).getHeight() + 1, null);
            graphics2D.setComposite(composite);
        }
    }

    public void drawOutline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.outlineStroke != null && this.outlinePaint != null) {
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.draw(rectangle2D);
        }
    }

    protected void drawNoDataMessage(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        String string = this.noDataMessage;
        if (string != null) {
            graphics2D.setFont(this.noDataMessageFont);
            graphics2D.setPaint(this.noDataMessagePaint);
            TextBlock textBlock = TextUtilities.createTextBlock((String)this.noDataMessage, (Font)this.noDataMessageFont, (Paint)this.noDataMessagePaint, (float)(0.9f * (float)rectangle2D.getWidth()), (TextMeasurer)new G2TextMeasurer(graphics2D));
            textBlock.draw(graphics2D, (float)rectangle2D.getCenterX(), (float)rectangle2D.getCenterY(), TextBlockAnchor.CENTER);
        }
        graphics2D.setClip(shape);
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
    }

    public void zoom(double d) {
    }

    public void axisChanged(AxisChangeEvent axisChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
        plotChangeEvent.setType(ChartChangeEventType.DATASET_UPDATED);
        this.notifyListeners(plotChangeEvent);
    }

    protected double getRectX(double d, double d2, double d3, RectangleEdge rectangleEdge) {
        double d4 = d;
        if (rectangleEdge == RectangleEdge.LEFT) {
            d4 += d2;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            d4 += d3;
        }
        return d4;
    }

    protected double getRectY(double d, double d2, double d3, RectangleEdge rectangleEdge) {
        double d4 = d;
        if (rectangleEdge == RectangleEdge.TOP) {
            d4 += d2;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            d4 += d3;
        }
        return d4;
    }

    public double getDataAreaRatio() {
        return this.dataAreaRatio;
    }

    public void setDataAreaRatio(double d) {
        this.dataAreaRatio = d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Plot)) {
            return false;
        }
        Plot plot = (Plot)object;
        if (!ObjectUtilities.equal((Object)this.noDataMessage, (Object)plot.noDataMessage)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.noDataMessageFont, (Object)plot.noDataMessageFont)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.noDataMessagePaint, (Object)plot.noDataMessagePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.insets, (Object)plot.insets)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.outlineStroke, (Object)plot.outlineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.outlinePaint, (Object)plot.outlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.backgroundPaint, (Object)plot.backgroundPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.backgroundImage, (Object)plot.backgroundImage)) {
            return false;
        }
        if (this.backgroundImageAlignment != plot.backgroundImageAlignment) {
            return false;
        }
        if (this.foregroundAlpha != plot.foregroundAlpha) {
            return false;
        }
        return this.backgroundAlpha == plot.backgroundAlpha;
    }

    public Object clone() throws CloneNotSupportedException {
        Plot plot = (Plot)super.clone();
        if (this.datasetGroup != null) {
            plot.datasetGroup = (DatasetGroup)ObjectUtilities.clone((Object)this.datasetGroup);
        }
        plot.drawingSupplier = (DrawingSupplier)ObjectUtilities.clone((Object)this.drawingSupplier);
        plot.listenerList = new EventListenerList();
        return plot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.noDataMessagePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.outlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.backgroundPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.noDataMessagePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.listenerList = new EventListenerList();
    }

    public static RectangleEdge resolveDomainAxisLocation(AxisLocation axisLocation, PlotOrientation plotOrientation) {
        if (axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        RectangleEdge rectangleEdge = null;
        if (axisLocation == AxisLocation.TOP_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.RIGHT;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.TOP;
            }
        } else if (axisLocation == AxisLocation.TOP_OR_LEFT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.LEFT;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.TOP;
            }
        } else if (axisLocation == AxisLocation.BOTTOM_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.RIGHT;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.BOTTOM;
            }
        } else if (axisLocation == AxisLocation.BOTTOM_OR_LEFT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.LEFT;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.BOTTOM;
            }
        }
        if (rectangleEdge == null) {
            throw new IllegalStateException("resolveDomainAxisLocation()");
        }
        return rectangleEdge;
    }

    public static RectangleEdge resolveRangeAxisLocation(AxisLocation axisLocation, PlotOrientation plotOrientation) {
        if (axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        RectangleEdge rectangleEdge = null;
        if (axisLocation == AxisLocation.TOP_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.TOP;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.RIGHT;
            }
        } else if (axisLocation == AxisLocation.TOP_OR_LEFT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.TOP;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.LEFT;
            }
        } else if (axisLocation == AxisLocation.BOTTOM_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.BOTTOM;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.RIGHT;
            }
        } else if (axisLocation == AxisLocation.BOTTOM_OR_LEFT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                rectangleEdge = RectangleEdge.BOTTOM;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                rectangleEdge = RectangleEdge.LEFT;
            }
        }
        if (rectangleEdge == null) {
            throw new IllegalStateException("resolveRangeAxisLocation()");
        }
        return rectangleEdge;
    }
}

