/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Size2D;

public class LabelBlock
extends AbstractBlock
implements Block {
    private TextBlock label;
    private Font font;

    public LabelBlock(String string) {
        this(string, new Font("Bitstream Vera Sans", 0, 11));
    }

    public LabelBlock(String string, Font font) {
        this.label = TextUtilities.createTextBlock((String)string, (Font)font, (Paint)Color.black);
        this.font = font;
    }

    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        graphics2D.setFont(this.font);
        Size2D size2D = this.label.calculateDimensions(graphics2D);
        return size2D;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setPaint(Color.black);
        graphics2D.setFont(this.font);
        this.label.draw(graphics2D, (float)rectangle2D.getX(), (float)rectangle2D.getY(), TextBlockAnchor.TOP_LEFT);
    }
}

