/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.ui.Size2D;

public class CenterArrangement
implements Arrangement,
Serializable {
    public void add(Block block, Object object) {
    }

    public Size2D arrange(BlockContainer blockContainer, RectangleConstraint rectangleConstraint, Graphics2D graphics2D) {
        LengthConstraintType lengthConstraintType = rectangleConstraint.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint.getHeightConstraintType();
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeNN(blockContainer, graphics2D);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeFN(blockContainer, rectangleConstraint, graphics2D);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeRN(blockContainer, rectangleConstraint, graphics2D);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeRF(blockContainer, rectangleConstraint, graphics2D);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeRR(blockContainer, rectangleConstraint, graphics2D);
            }
        }
        throw new IllegalArgumentException("Unknown LengthConstraintType.");
    }

    protected Size2D arrangeFN(BlockContainer blockContainer, RectangleConstraint rectangleConstraint, Graphics2D graphics2D) {
        List list = blockContainer.getBlocks();
        Block block = (Block)list.get(0);
        Size2D size2D = block.arrange(graphics2D, RectangleConstraint.NONE);
        double d = rectangleConstraint.getWidth();
        Rectangle2D.Double double_ = new Rectangle2D.Double((d - size2D.width) / 2.0, 0.0, size2D.width, size2D.height);
        block.setBounds(double_);
        return new Size2D((d - size2D.width) / 2.0, size2D.height);
    }

    protected Size2D arrangeFR(BlockContainer blockContainer, RectangleConstraint rectangleConstraint, Graphics2D graphics2D) {
        Size2D size2D = this.arrangeFN(blockContainer, rectangleConstraint, graphics2D);
        if (rectangleConstraint.getHeightRange().contains(size2D.height)) {
            return size2D;
        }
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedHeight(rectangleConstraint.getHeightRange().constrain(size2D.getHeight()));
        return this.arrangeFF(blockContainer, rectangleConstraint2, graphics2D);
    }

    protected Size2D arrangeFF(BlockContainer blockContainer, RectangleConstraint rectangleConstraint, Graphics2D graphics2D) {
        return this.arrangeFN(blockContainer, rectangleConstraint, graphics2D);
    }

    protected Size2D arrangeRR(BlockContainer blockContainer, RectangleConstraint rectangleConstraint, Graphics2D graphics2D) {
        Size2D size2D = this.arrangeNN(blockContainer, graphics2D);
        if (rectangleConstraint.getWidthRange().contains(size2D.width)) {
            return size2D;
        }
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedWidth(rectangleConstraint.getWidthRange().getUpperBound());
        return this.arrangeFR(blockContainer, rectangleConstraint2, graphics2D);
    }

    protected Size2D arrangeRF(BlockContainer blockContainer, RectangleConstraint rectangleConstraint, Graphics2D graphics2D) {
        Size2D size2D = this.arrangeNF(blockContainer, rectangleConstraint, graphics2D);
        if (rectangleConstraint.getWidthRange().contains(size2D.width)) {
            return size2D;
        }
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedWidth(rectangleConstraint.getWidthRange().constrain(size2D.getWidth()));
        return this.arrangeFF(blockContainer, rectangleConstraint2, graphics2D);
    }

    protected Size2D arrangeRN(BlockContainer blockContainer, RectangleConstraint rectangleConstraint, Graphics2D graphics2D) {
        Size2D size2D = this.arrangeNN(blockContainer, graphics2D);
        if (rectangleConstraint.getWidthRange().contains(size2D.width)) {
            return size2D;
        }
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedWidth(rectangleConstraint.getWidthRange().getUpperBound());
        return this.arrangeFN(blockContainer, rectangleConstraint2, graphics2D);
    }

    protected Size2D arrangeNN(BlockContainer blockContainer, Graphics2D graphics2D) {
        List list = blockContainer.getBlocks();
        Block block = (Block)list.get(0);
        Size2D size2D = block.arrange(graphics2D, RectangleConstraint.NONE);
        return new Size2D(size2D.width, size2D.height);
    }

    protected Size2D arrangeNF(BlockContainer blockContainer, RectangleConstraint rectangleConstraint, Graphics2D graphics2D) {
        return this.arrangeNN(blockContainer, graphics2D);
    }

    public void clear() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof CenterArrangement;
    }
}

