/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.PublicCloneable;

public class PeriodAxis
extends ValueAxis
implements Cloneable,
PublicCloneable,
Serializable {
    private RegularTimePeriod first;
    private RegularTimePeriod last;
    private TimeZone timeZone;
    private Class autoRangeTimePeriodClass;
    private Class majorTickTimePeriodClass;
    private boolean minorTickMarksVisible;
    private Class minorTickTimePeriodClass;
    private float minorTickMarkInsideLength = 0.0f;
    private float minorTickMarkOutsideLength = 2.0f;
    private transient Stroke minorTickMarkStroke = new BasicStroke(0.5f);
    private transient Paint minorTickMarkPaint = Color.black;
    private PeriodAxisLabelInfo[] labelInfo;
    private static final LogContext LOGGER;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.PeriodAxis");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Log.createContext((Class)clazz);
    }

    public PeriodAxis(String string) {
        this(string, new Day(), new Day());
    }

    public PeriodAxis(String string, RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2) {
        this(string, regularTimePeriod, regularTimePeriod2, TimeZone.getDefault());
    }

    public PeriodAxis(String string, RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2, TimeZone timeZone) {
        super(string, null);
        this.first = regularTimePeriod;
        this.last = regularTimePeriod2;
        this.timeZone = timeZone;
        this.autoRangeTimePeriodClass = regularTimePeriod.getClass();
        this.majorTickTimePeriodClass = regularTimePeriod.getClass();
        this.minorTickMarksVisible = false;
        this.minorTickTimePeriodClass = RegularTimePeriod.downsize(this.majorTickTimePeriodClass);
        this.setAutoRange(true);
        this.labelInfo = new PeriodAxisLabelInfo[2];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.data.time.Month");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.labelInfo[0] = new PeriodAxisLabelInfo(clazz, new SimpleDateFormat("MMM"));
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.jfree.data.time.Year");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.labelInfo[1] = new PeriodAxisLabelInfo(clazz2, new SimpleDateFormat("yyyy"));
    }

    public RegularTimePeriod getFirst() {
        return this.first;
    }

    public void setFirst(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("Null 'first' argument.");
        }
        this.first = regularTimePeriod;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public RegularTimePeriod getLast() {
        return this.last;
    }

    public void setLast(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("Null 'last' argument.");
        }
        this.last = regularTimePeriod;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("Null 'zone' argument.");
        }
        this.timeZone = timeZone;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Class getAutoRangeTimePeriodClass() {
        return this.autoRangeTimePeriodClass;
    }

    public void setAutoRangeTimePeriodClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null 'c' argument.");
        }
        this.autoRangeTimePeriodClass = clazz;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Class getMajorTickTimePeriodClass() {
        return this.majorTickTimePeriodClass;
    }

    public void setMajorTickTimePeriodClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null 'c' argument.");
        }
        this.majorTickTimePeriodClass = clazz;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isMinorTickMarksVisible() {
        return this.minorTickMarksVisible;
    }

    public void setMinorTickMarksVisible(boolean bl) {
        this.minorTickMarksVisible = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Class getMinorTickTimePeriodClass() {
        return this.minorTickTimePeriodClass;
    }

    public void setMinorTickTimePeriodClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null 'c' argument.");
        }
        this.minorTickTimePeriodClass = clazz;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Stroke getMinorTickMarkStroke() {
        return this.minorTickMarkStroke;
    }

    public void setMinorTickMarkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.minorTickMarkStroke = stroke;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getMinorTickMarkPaint() {
        return this.minorTickMarkPaint;
    }

    public void setMinorTickMarkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.minorTickMarkPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getMinorTickMarkInsideLength() {
        return this.minorTickMarkInsideLength;
    }

    public void setMinorTickMarkInsideLength(float f) {
        this.minorTickMarkInsideLength = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getMinorTickMarkOutsideLength() {
        return this.minorTickMarkOutsideLength;
    }

    public void setMinorTickMarkOutsideLength(float f) {
        this.minorTickMarkOutsideLength = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public PeriodAxisLabelInfo[] getLabelInfo() {
        return this.labelInfo;
    }

    public void setLabelInfo(PeriodAxisLabelInfo[] periodAxisLabelInfoArray) {
        this.labelInfo = periodAxisLabelInfoArray;
    }

    public Range getRange() {
        return new Range(this.first.getFirstMillisecond(this.timeZone), this.last.getLastMillisecond(this.timeZone));
    }

    public void configure() {
        this.autoAdjustRange();
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d = this.getFixedDimension();
        if (d > 0.0) {
            axisSpace.ensureAtLeast(d, rectangleEdge);
        }
        Rectangle2D rectangle2D2 = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while (n < this.labelInfo.length) {
            PeriodAxisLabelInfo periodAxisLabelInfo = this.labelInfo[n];
            FontMetrics fontMetrics = graphics2D.getFontMetrics(periodAxisLabelInfo.getLabelFont());
            d4 += periodAxisLabelInfo.getPadding().extendHeight((double)fontMetrics.getHeight());
            ++n;
        }
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d2 = rectangle2D2.getHeight();
            axisSpace.add(d2 + d4, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d3 = rectangle2D2.getWidth();
            axisSpace.add(d3 + d4, rectangleEdge);
        }
        double d5 = 0.0;
        if (this.isTickMarksVisible()) {
            d5 = this.getTickMarkOutsideLength();
        }
        if (this.minorTickMarksVisible) {
            d5 = Math.max(d5, (double)this.minorTickMarkOutsideLength);
        }
        axisSpace.add(d5, rectangleEdge);
        return axisSpace;
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        LOGGER.debug((Object)("In draw() method (cursor = " + d + ")"));
        AxisState axisState = new AxisState(d);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        this.drawTickMarks(graphics2D, axisState, rectangle2D2, rectangleEdge);
        int n = 0;
        while (n < this.labelInfo.length) {
            axisState = this.drawTickLabels(n, graphics2D, axisState, rectangle2D2, rectangleEdge);
            ++n;
        }
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    protected void drawTickMarks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            this.drawTickMarksHorizontal(graphics2D, axisState, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            this.drawTickMarksVertical(graphics2D, axisState, rectangle2D, rectangleEdge);
        }
    }

    protected void drawTickMarksHorizontal(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = rectangle2D.getX();
        double d2 = axisState.getCursor();
        double d3 = this.getTickMarkInsideLength();
        double d4 = this.getTickMarkOutsideLength();
        RegularTimePeriod regularTimePeriod = RegularTimePeriod.createInstance(this.majorTickTimePeriodClass, this.first.getStart(), this.getTimeZone());
        long l = regularTimePeriod.getFirstMillisecond(this.getTimeZone());
        Line2D.Double double_ = null;
        Line2D.Double double_2 = null;
        while (l < this.getLast().getLastMillisecond(this.getTimeZone())) {
            l = regularTimePeriod.getFirstMillisecond(this.getTimeZone());
            d = this.valueToJava2D(l, rectangle2D, rectangleEdge);
            if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(d, d2, d, d2 + d3);
                double_2 = new Line2D.Double(d, d2, d, d2 - d4);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(d, d2, d, d2 - d3);
                double_2 = new Line2D.Double(d, d2, d, d2 + d4);
            }
            graphics2D.setPaint(this.getTickMarkPaint());
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.draw(double_);
            graphics2D.draw(double_2);
            if (this.minorTickMarksVisible) {
                RegularTimePeriod regularTimePeriod2 = RegularTimePeriod.createInstance(this.minorTickTimePeriodClass, new Date(l), this.getTimeZone());
                long l2 = regularTimePeriod2.getFirstMillisecond(this.getTimeZone());
                while (l2 < regularTimePeriod.getLastMillisecond(this.getTimeZone())) {
                    l2 = regularTimePeriod2.getFirstMillisecond(this.getTimeZone());
                    double d5 = this.valueToJava2D(l2, rectangle2D, rectangleEdge);
                    if (rectangleEdge == RectangleEdge.TOP) {
                        double_ = new Line2D.Double(d5, d2, d5, d2 + (double)this.minorTickMarkInsideLength);
                        double_2 = new Line2D.Double(d5, d2, d5, d2 - (double)this.minorTickMarkOutsideLength);
                    } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                        double_ = new Line2D.Double(d5, d2, d5, d2 - (double)this.minorTickMarkInsideLength);
                        double_2 = new Line2D.Double(d5, d2, d5, d2 + (double)this.minorTickMarkOutsideLength);
                    }
                    graphics2D.setPaint(this.minorTickMarkPaint);
                    graphics2D.setStroke(this.minorTickMarkStroke);
                    graphics2D.draw(double_);
                    graphics2D.draw(double_2);
                    regularTimePeriod2 = regularTimePeriod2.next();
                }
            }
            regularTimePeriod = regularTimePeriod.next();
        }
        if (rectangleEdge == RectangleEdge.TOP) {
            axisState.cursorUp(Math.max(d4, (double)this.minorTickMarkOutsideLength));
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            axisState.cursorDown(Math.max(d4, (double)this.minorTickMarkOutsideLength));
        }
    }

    protected void drawTickMarksVertical(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
    }

    protected AxisState drawTickLabels(int n, Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.labelInfo[n].getLabelFont());
        if (rectangleEdge == RectangleEdge.BOTTOM) {
            d = this.labelInfo[n].getPadding().calculateTopOutset((double)fontMetrics.getHeight());
        } else if (rectangleEdge == RectangleEdge.TOP) {
            d = this.labelInfo[n].getPadding().calculateBottomOutset((double)fontMetrics.getHeight());
        }
        axisState.moveCursor(d, rectangleEdge);
        long l = this.first.getFirstMillisecond(this.timeZone);
        long l2 = this.last.getLastMillisecond(this.timeZone);
        graphics2D.setFont(this.labelInfo[n].getLabelFont());
        graphics2D.setPaint(this.labelInfo[n].getLabelPaint());
        RegularTimePeriod regularTimePeriod = this.labelInfo[n].createInstance(new Date(l), this.timeZone);
        RegularTimePeriod regularTimePeriod2 = this.labelInfo[n].createInstance(new Date(l2), this.timeZone);
        String string = this.labelInfo[n].getDateFormat().format(new Date(regularTimePeriod.getMiddleMillisecond(this.timeZone)));
        String string2 = this.labelInfo[n].getDateFormat().format(new Date(regularTimePeriod2.getMiddleMillisecond(this.timeZone)));
        Rectangle2D rectangle2D2 = TextUtilities.getTextBounds((String)string, (Graphics2D)graphics2D, (FontMetrics)graphics2D.getFontMetrics());
        Rectangle2D rectangle2D3 = TextUtilities.getTextBounds((String)string2, (Graphics2D)graphics2D, (FontMetrics)graphics2D.getFontMetrics());
        double d2 = Math.max(rectangle2D2.getWidth(), rectangle2D3.getWidth());
        long l3 = Math.round(this.java2DToValue(rectangle2D.getX() + d2 + 5.0, rectangle2D, rectangleEdge)) - l;
        long l4 = regularTimePeriod.getLastMillisecond(this.timeZone) - regularTimePeriod.getFirstMillisecond(this.timeZone);
        int n2 = (int)(l3 / l4) + 1;
        RegularTimePeriod regularTimePeriod3 = this.labelInfo[n].createInstance(new Date(l), this.timeZone);
        RectangularShape rectangularShape = null;
        long l5 = 0L;
        float f = (float)axisState.getCursor();
        TextAnchor textAnchor = TextAnchor.TOP_CENTER;
        float f2 = (float)rectangle2D2.getHeight();
        if (rectangleEdge == RectangleEdge.TOP) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
            f2 = -f2;
        }
        while (regularTimePeriod3.getFirstMillisecond(this.timeZone) <= l2) {
            float f3;
            Rectangle2D rectangle2D4;
            float f4 = (float)this.valueToJava2D(regularTimePeriod3.getMiddleMillisecond(this.timeZone), rectangle2D, rectangleEdge);
            DateFormat dateFormat = this.labelInfo[n].getDateFormat();
            String string3 = dateFormat.format(new Date(regularTimePeriod3.getMiddleMillisecond(this.timeZone)));
            long l6 = regularTimePeriod3.getFirstMillisecond(this.timeZone);
            long l7 = regularTimePeriod3.getLastMillisecond(this.timeZone);
            if (l7 > l2 && (double)f4 + (rectangle2D4 = TextUtilities.getTextBounds((String)string3, (Graphics2D)graphics2D, (FontMetrics)graphics2D.getFontMetrics())).getWidth() / 2.0 > rectangle2D.getMaxX()) {
                f3 = (float)this.valueToJava2D(Math.max(l6, l), rectangle2D, rectangleEdge);
                if (rectangle2D4.getWidth() < rectangle2D.getMaxX() - (double)f3) {
                    f4 = ((float)rectangle2D.getMaxX() + f3) / 2.0f;
                } else {
                    string3 = null;
                }
            }
            if (l6 < l && (double)f4 - (rectangle2D4 = TextUtilities.getTextBounds((String)string3, (Graphics2D)graphics2D, (FontMetrics)graphics2D.getFontMetrics())).getWidth() / 2.0 < rectangle2D.getX()) {
                f3 = (float)this.valueToJava2D(Math.min(l7, l2), rectangle2D, rectangleEdge);
                if (rectangle2D4.getWidth() < (double)f3 - rectangle2D.getX()) {
                    f4 = (f3 + (float)rectangle2D.getX()) / 2.0f;
                } else {
                    string3 = null;
                }
            }
            if (string3 != null) {
                graphics2D.setPaint(this.labelInfo[n].getLabelPaint());
                rectangularShape = TextUtilities.drawAlignedString((String)string3, (Graphics2D)graphics2D, (float)f4, (float)f, (TextAnchor)textAnchor);
            }
            if (l5 > 0L && this.labelInfo[n].getDrawDividers()) {
                long l8 = regularTimePeriod3.getFirstMillisecond(this.timeZone);
                long l9 = (l5 + l8) / 2L;
                float f5 = (float)this.valueToJava2D(l9, rectangle2D, rectangleEdge);
                graphics2D.setStroke(this.labelInfo[n].getDividerStroke());
                graphics2D.setPaint(this.labelInfo[n].getDividerPaint());
                graphics2D.draw(new Line2D.Float(f5, f, f5, f + f2));
            }
            l5 = l7;
            int n3 = 0;
            while (n3 < n2) {
                regularTimePeriod3 = regularTimePeriod3.next();
                ++n3;
            }
        }
        double d3 = 0.0;
        if (rectangularShape != null) {
            d3 = rectangularShape.getHeight();
            if (rectangleEdge == RectangleEdge.BOTTOM) {
                d3 += this.labelInfo[n].getPadding().calculateBottomOutset((double)fontMetrics.getHeight());
            } else if (rectangleEdge == RectangleEdge.TOP) {
                d3 += this.labelInfo[n].getPadding().calculateTopOutset((double)fontMetrics.getHeight());
            }
        }
        axisState.moveCursor(d3, rectangleEdge);
        return axisState;
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        return new ArrayList();
    }

    public double valueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = Double.NaN;
        double d3 = this.first.getFirstMillisecond(this.timeZone);
        double d4 = this.last.getLastMillisecond(this.timeZone);
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            double d5 = rectangle2D.getX();
            double d6 = rectangle2D.getMaxX();
            d2 = this.isInverted() ? d6 + (d - d3) / (d4 - d3) * (d5 - d6) : d5 + (d - d3) / (d4 - d3) * (d6 - d5);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            double d7 = rectangle2D.getMinY();
            double d8 = rectangle2D.getMaxY();
            d2 = this.isInverted() ? d7 + (d - d3) / (d4 - d3) * (d8 - d7) : d8 - (d - d3) / (d4 - d3) * (d8 - d7);
        }
        return d2;
    }

    public double java2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = Double.NaN;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.first.getFirstMillisecond(this.timeZone);
        double d6 = this.last.getLastMillisecond(this.timeZone);
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d3 = rectangle2D.getX();
            d4 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d3 = rectangle2D.getMaxY();
            d4 = rectangle2D.getY();
        }
        d2 = this.isInverted() ? d6 - (d - d3) / (d4 - d3) * (d6 - d5) : d5 + (d - d3) / (d4 - d3) * (d6 - d5);
        return d2;
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            long l = Math.round(range.getUpperBound());
            long l2 = Math.round(range.getLowerBound());
            this.first = this.createInstance(this.autoRangeTimePeriodClass, new Date(l2), this.timeZone);
            this.last = this.createInstance(this.autoRangeTimePeriodClass, new Date(l), this.timeZone);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PeriodAxis && super.equals(object)) {
            PeriodAxis periodAxis = (PeriodAxis)object;
            if (!this.first.equals(periodAxis.first)) {
                return false;
            }
            if (!this.last.equals(periodAxis.last)) {
                return false;
            }
            if (!this.timeZone.equals(periodAxis.timeZone)) {
                return false;
            }
            if (!this.autoRangeTimePeriodClass.equals(periodAxis.autoRangeTimePeriodClass)) {
                return false;
            }
            if (this.isMinorTickMarksVisible() != periodAxis.isMinorTickMarksVisible()) {
                return false;
            }
            if (!this.majorTickTimePeriodClass.equals(periodAxis.majorTickTimePeriodClass)) {
                return false;
            }
            if (!this.minorTickTimePeriodClass.equals(periodAxis.minorTickTimePeriodClass)) {
                return false;
            }
            if (!this.minorTickMarkPaint.equals(periodAxis.minorTickMarkPaint)) {
                return false;
            }
            if (!this.minorTickMarkStroke.equals(periodAxis.minorTickMarkStroke)) {
                return false;
            }
            return Arrays.equals(this.labelInfo, periodAxis.labelInfo);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PeriodAxis periodAxis = (PeriodAxis)super.clone();
        periodAxis.timeZone = (TimeZone)this.timeZone.clone();
        periodAxis.labelInfo = new PeriodAxisLabelInfo[this.labelInfo.length];
        int n = 0;
        while (n < this.labelInfo.length) {
            periodAxis.labelInfo[n] = this.labelInfo[n];
            ++n;
        }
        return periodAxis;
    }

    private RegularTimePeriod createInstance(Class clazz, Date date, TimeZone timeZone) {
        RegularTimePeriod regularTimePeriod = null;
        try {
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("java.util.Date");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("java.util.TimeZone");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            regularTimePeriod = (RegularTimePeriod)constructor.newInstance(date, timeZone);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return regularTimePeriod;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke((Stroke)this.minorTickMarkStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.minorTickMarkPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.minorTickMarkStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.minorTickMarkPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

