/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.MarkerAxisBand;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.data.RangeType;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public class NumberAxis
extends ValueAxis
implements Cloneable,
Serializable {
    public static final boolean DEFAULT_AUTO_RANGE_INCLUDES_ZERO = true;
    public static final boolean DEFAULT_AUTO_RANGE_STICKY_ZERO = true;
    public static final NumberTickUnit DEFAULT_TICK_UNIT = new NumberTickUnit(1.0, new DecimalFormat("0"));
    public static final boolean DEFAULT_VERTICAL_TICK_LABELS = false;
    private RangeType rangeType = RangeType.FULL;
    private boolean autoRangeIncludesZero = true;
    private boolean autoRangeStickyZero = true;
    private NumberTickUnit tickUnit = DEFAULT_TICK_UNIT;
    private NumberFormat numberFormatOverride = null;
    private MarkerAxisBand markerBand = null;

    public NumberAxis() {
        this(null);
    }

    public NumberAxis(String string) {
        super(string, NumberAxis.createStandardTickUnits());
    }

    public RangeType getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(RangeType rangeType) {
        if (rangeType == null) {
            throw new IllegalArgumentException("Null 'rangeType' argument.");
        }
        this.rangeType = rangeType;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean autoRangeIncludesZero() {
        return this.autoRangeIncludesZero;
    }

    public void setAutoRangeIncludesZero(boolean bl) {
        if (this.autoRangeIncludesZero != bl) {
            this.autoRangeIncludesZero = bl;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean autoRangeStickyZero() {
        return this.autoRangeStickyZero;
    }

    public void setAutoRangeStickyZero(boolean bl) {
        if (this.autoRangeStickyZero != bl) {
            this.autoRangeStickyZero = bl;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.setTickUnit(numberTickUnit, true, true);
    }

    public void setTickUnit(NumberTickUnit numberTickUnit, boolean bl, boolean bl2) {
        if (numberTickUnit == null) {
            throw new IllegalArgumentException("Null 'unit' argument.");
        }
        this.tickUnit = numberTickUnit;
        if (bl2) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat numberFormat) {
        this.numberFormatOverride = numberFormat;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public MarkerAxisBand getMarkerBand() {
        return this.markerBand;
    }

    public void setMarkerBand(MarkerAxisBand markerAxisBand) {
        this.markerBand = markerAxisBand;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d = range.getUpperBound();
            double d2 = range.getLowerBound();
            if (this.rangeType == RangeType.POSITIVE) {
                d2 = Math.max(0.0, d2);
                d = Math.max(0.0, d);
            } else if (this.rangeType == RangeType.NEGATIVE) {
                d2 = Math.min(0.0, d2);
                d = Math.min(0.0, d);
            }
            if (this.autoRangeIncludesZero()) {
                d2 = Math.min(d2, 0.0);
                d = Math.max(d, 0.0);
            }
            double d3 = d - d2;
            double d4 = this.getFixedAutoRange();
            if (d4 > 0.0) {
                d2 = d - d4;
            } else {
                double d5 = this.getAutoRangeMinimumSize();
                if (d3 < d5) {
                    double d6 = (d5 - d3) / 2.0;
                    d += d6;
                    d2 -= d6;
                    if (this.rangeType == RangeType.POSITIVE) {
                        if (d2 < 0.0) {
                            d -= d2;
                            d2 = 0.0;
                        }
                    } else if (this.rangeType == RangeType.NEGATIVE && d > 0.0) {
                        d2 -= d;
                        d = 0.0;
                    }
                }
                if (this.autoRangeStickyZero()) {
                    d = d <= 0.0 ? Math.min(0.0, d + this.getUpperMargin() * d3) : (d += this.getUpperMargin() * d3);
                    d2 = d2 >= 0.0 ? Math.max(0.0, d2 - this.getLowerMargin() * d3) : (d2 -= this.getLowerMargin() * d3);
                } else {
                    d += this.getUpperMargin() * d3;
                    d2 -= this.getLowerMargin() * d3;
                }
            }
            this.setRange(new Range(d2, d), false, false);
        }
    }

    public double valueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d5 = rectangle2D.getMinY();
            d4 = rectangle2D.getMaxY();
        }
        if (this.isInverted()) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double java2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getY();
        }
        if (this.isInverted()) {
            return d3 - (d - d4) / (d5 - d4) * (d3 - d2);
        }
        return d2 + (d - d4) / (d5 - d4) * (d3 - d2);
    }

    public double calculateLowestVisibleTickValue() {
        double d = this.getTickUnit().getSize();
        double d2 = Math.ceil(this.getRange().getLowerBound() / d);
        return d2 * d;
    }

    public double calculateHighestVisibleTickValue() {
        double d = this.getTickUnit().getSize();
        double d2 = Math.floor(this.getRange().getUpperBound() / d);
        return d2 * d;
    }

    public int calculateVisibleTickCount() {
        double d = this.getTickUnit().getSize();
        Range range = this.getRange();
        return (int)(Math.floor(range.getUpperBound() / d) - Math.ceil(range.getLowerBound() / d) + 1.0);
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState = null;
        if (!this.isVisible()) {
            axisState = new AxisState(d);
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            return axisState;
        }
        axisState = this.drawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    public static TickUnitSource createStandardTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(1.0E-7, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(1.0E-6, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(1.0E-5, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(1.0E-4, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.001, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.01, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(0.1, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(1.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(10.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(100.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(1000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(10000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(100000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1000000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E9, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E10, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E11, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E-7, new DecimalFormat("0.00000000")));
        tickUnits.add(new NumberTickUnit(2.5E-6, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(2.5E-5, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(2.5E-4, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(0.0025, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.025, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.25, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(2.5, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(25.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(250.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(2500.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(25000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(250000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2500000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E9, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E10, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E11, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E-7, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(5.0E-6, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(5.0E-5, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(5.0E-4, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.005, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.05, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(0.5, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(5.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(50.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(500.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(5000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(50000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(500000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E9, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E10, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E11, new DecimalFormat("#,###,###,##0")));
        return tickUnits;
    }

    public static TickUnitSource createIntegerTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(1.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(2.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(5.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(10.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(20.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(50.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(100.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(200.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(500.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(1000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(10000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(20000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(50000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(100000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(200000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(500000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E10, new DecimalFormat("#,##0")));
        return tickUnits;
    }

    public static TickUnitSource createStandardTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        tickUnits.add(new NumberTickUnit(1.0E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.001, numberFormat));
        tickUnits.add(new NumberTickUnit(0.01, numberFormat));
        tickUnits.add(new NumberTickUnit(0.1, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E10, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.0025, numberFormat));
        tickUnits.add(new NumberTickUnit(0.025, numberFormat));
        tickUnits.add(new NumberTickUnit(0.25, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5, numberFormat));
        tickUnits.add(new NumberTickUnit(25.0, numberFormat));
        tickUnits.add(new NumberTickUnit(250.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(25000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(250000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E8, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E9, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E10, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.005, numberFormat));
        tickUnits.add(new NumberTickUnit(0.05, numberFormat));
        tickUnits.add(new NumberTickUnit(0.5, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E10, numberFormat));
        return tickUnits;
    }

    public static TickUnitSource createIntegerTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        tickUnits.add(new NumberTickUnit(1.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10.0, numberFormat));
        tickUnits.add(new NumberTickUnit(20.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100.0, numberFormat));
        tickUnits.add(new NumberTickUnit(200.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(20000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(200000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E10, numberFormat));
        return tickUnits;
    }

    protected double estimateMaximumTickLabelHeight(Graphics2D graphics2D) {
        Insets insets = this.getTickLabelInsets();
        double d = insets.top + insets.bottom;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return d += (double)font.getLineMetrics("123", fontRenderContext).getHeight();
    }

    protected double estimateMaximumTickLabelWidth(Graphics2D graphics2D, TickUnit tickUnit) {
        Insets insets = this.getTickLabelInsets();
        double d = insets.left + insets.right;
        if (this.isVerticalTickLabels()) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            LineMetrics lineMetrics = this.getTickLabelFont().getLineMetrics("0", fontRenderContext);
            d += (double)lineMetrics.getHeight();
        } else {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getTickLabelFont());
            Range range = this.getRange();
            double d2 = range.getLowerBound();
            double d3 = range.getUpperBound();
            String string = tickUnit.valueToString(d2);
            String string2 = tickUnit.valueToString(d3);
            double d4 = fontMetrics.stringWidth(string);
            double d5 = fontMetrics.stringWidth(string2);
            d += Math.max(d4, d5);
        }
        return d;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            this.selectHorizontalAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            this.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d2 = this.lengthToJava2D(tickUnit.getSize(), rectangle2D2, rectangleEdge);
        double d3 = d / d2 * tickUnit.getSize();
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnitSource.getCeilingTickUnit(d3);
        double d4 = this.lengthToJava2D(numberTickUnit.getSize(), rectangle2D2, rectangleEdge);
        d = this.estimateMaximumTickLabelWidth(graphics2D, numberTickUnit);
        if (d > d4) {
            numberTickUnit = (NumberTickUnit)tickUnitSource.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d = this.estimateMaximumTickLabelHeight(graphics2D);
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d2 = this.lengthToJava2D(tickUnit.getSize(), rectangle2D2, rectangleEdge);
        double d3 = d / d2 * tickUnit.getSize();
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnitSource.getCeilingTickUnit(d3);
        double d4 = this.lengthToJava2D(numberTickUnit.getSize(), rectangle2D2, rectangleEdge);
        d = this.estimateMaximumTickLabelHeight(graphics2D);
        if (d > d4) {
            numberTickUnit = (NumberTickUnit)tickUnitSource.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        List list = new ArrayList();
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            list = this.refreshHorizontalTicks(graphics2D, axisState.getCursor(), rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            list = this.refreshVerticalTicks(graphics2D, axisState.getCursor(), rectangle2D, rectangle2D2, rectangleEdge);
        }
        return list;
    }

    protected List refreshHorizontalTicks(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
        double d2 = this.getTickUnit().getSize();
        int n = this.calculateVisibleTickCount();
        double d3 = this.calculateLowestVisibleTickValue();
        if (n <= 500) {
            int n2 = 0;
            while (n2 < n) {
                double d4 = d3 + (double)n2 * d2;
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d4) : this.getTickUnit().valueToString(d4);
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d5 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    d5 = rectangleEdge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                } else {
                    textAnchor = TextAnchor.TOP_CENTER;
                    textAnchor2 = TextAnchor.TOP_CENTER;
                }
                NumberTick numberTick = new NumberTick(new Double(d4), string, textAnchor, textAnchor2, d5);
                arrayList.add(numberTick);
                ++n2;
            }
        }
        return arrayList;
    }

    protected List refreshVerticalTicks(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        arrayList.clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
        double d2 = this.getTickUnit().getSize();
        int n = this.calculateVisibleTickCount();
        double d3 = this.calculateLowestVisibleTickValue();
        if (n <= 500) {
            int n2 = 0;
            while (n2 < n) {
                double d4 = d3 + (double)n2 * d2;
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d4) : this.getTickUnit().valueToString(d4);
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d5 = 0.0;
                if (this.isVerticalTickLabels()) {
                    if (rectangleEdge == RectangleEdge.LEFT) {
                        textAnchor = TextAnchor.BOTTOM_CENTER;
                        textAnchor2 = TextAnchor.BOTTOM_CENTER;
                        d5 = -1.5707963267948966;
                    } else {
                        textAnchor = TextAnchor.BOTTOM_CENTER;
                        textAnchor2 = TextAnchor.BOTTOM_CENTER;
                        d5 = 1.5707963267948966;
                    }
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                } else {
                    textAnchor = TextAnchor.CENTER_LEFT;
                    textAnchor2 = TextAnchor.CENTER_LEFT;
                }
                NumberTick numberTick = new NumberTick(new Double(d4), string, textAnchor, textAnchor2, d5);
                arrayList.add(numberTick);
                ++n2;
            }
        }
        return arrayList;
    }

    public Object clone() throws CloneNotSupportedException {
        NumberAxis numberAxis = (NumberAxis)super.clone();
        if (this.numberFormatOverride != null) {
            numberAxis.numberFormatOverride = (NumberFormat)this.numberFormatOverride.clone();
        }
        return numberAxis;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberAxis)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NumberAxis numberAxis = (NumberAxis)object;
        if (this.autoRangeIncludesZero != numberAxis.autoRangeIncludesZero) {
            return false;
        }
        if (this.autoRangeStickyZero != numberAxis.autoRangeStickyZero) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.tickUnit, (Object)numberAxis.tickUnit)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.numberFormatOverride, (Object)numberAxis.numberFormatOverride);
    }
}

