/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class XYShapeAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private transient Shape shape;
    private transient Stroke stroke;
    private transient Paint outlinePaint;
    private transient Paint fillPaint;

    public XYShapeAnnotation(Shape shape) {
        this(shape, new BasicStroke(1.0f), Color.black);
    }

    public XYShapeAnnotation(Shape shape, Stroke stroke, Paint paint) {
        this(shape, stroke, paint, null);
    }

    public XYShapeAnnotation(Shape shape, Stroke stroke, Paint paint, Paint paint2) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.shape = shape;
        this.stroke = stroke;
        this.outlinePaint = paint;
        this.fillPaint = paint2;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        double d = valueAxis.valueToJava2D(0.0, rectangle2D, rectangleEdge);
        double d2 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge2);
        double d3 = valueAxis.valueToJava2D(1.0, rectangle2D, rectangleEdge) - d;
        double d4 = valueAxis2.valueToJava2D(1.0, rectangle2D, rectangleEdge2) - d2;
        Shape shape = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            AffineTransform affineTransform = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
            AffineTransform affineTransform2 = new AffineTransform(d4, 0.0, 0.0, d3, d2, d);
            shape = affineTransform.createTransformedShape(this.shape);
            shape = affineTransform2.createTransformedShape(shape);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            AffineTransform affineTransform = new AffineTransform(d3, 0.0, 0.0, d4, d, d2);
            shape = affineTransform.createTransformedShape(this.shape);
        }
        if (this.fillPaint != null) {
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(shape);
        }
        if (this.stroke != null && this.outlinePaint != null) {
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(shape);
        }
        this.addEntity(plotRenderingInfo, shape, n, this.getToolTipText(), this.getURL());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYShapeAnnotation)) {
            return false;
        }
        XYShapeAnnotation xYShapeAnnotation = (XYShapeAnnotation)object;
        if (!this.shape.equals(xYShapeAnnotation.shape)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.stroke, (Object)xYShapeAnnotation.stroke)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.outlinePaint, (Object)xYShapeAnnotation.outlinePaint)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.fillPaint, (Object)xYShapeAnnotation.fillPaint);
    }

    public int hashCode() {
        return this.shape.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape((Shape)this.shape, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.stroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.fillPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.shape = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.stroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.fillPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

