/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.CodePointIterator;

final class CharArrayCodePointIterator
extends CodePointIterator {
    private char[] text;
    private int start;
    private int limit;
    private int index;

    public CharArrayCodePointIterator(char[] cArray) {
        this.text = cArray;
        this.limit = cArray.length;
    }

    public CharArrayCodePointIterator(char[] cArray, int n2, int n3) {
        if (n2 < 0 || n3 < n2 || n3 > cArray.length) {
            throw new IllegalArgumentException();
        }
        this.text = cArray;
        this.start = this.index = n2;
        this.limit = n3;
    }

    public void setToStart() {
        this.index = this.start;
    }

    public void setToLimit() {
        this.index = this.limit;
    }

    public int next() {
        if (this.index < this.limit) {
            char c2;
            char c3;
            if (Character.isHighSurrogate(c3 = this.text[this.index++]) && this.index < this.limit && Character.isLowSurrogate(c2 = this.text[this.index])) {
                ++this.index;
                return Character.toCodePoint(c3, c2);
            }
            return c3;
        }
        return -1;
    }

    public int prev() {
        if (this.index > this.start) {
            char c2;
            char c3;
            if (Character.isLowSurrogate(c3 = this.text[--this.index]) && this.index > this.start && Character.isHighSurrogate(c2 = this.text[this.index - 1])) {
                --this.index;
                return Character.toCodePoint(c2, c3);
            }
            return c3;
        }
        return -1;
    }

    public int charIndex() {
        return this.index;
    }
}

