/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;
import sun.security.provider.SeedGenerator;

public final class SecureRandom
extends SecureRandomSpi
implements Serializable {
    private static final long serialVersionUID = 3581829991155417889L;
    private static SecureRandom seeder;
    private static final int DIGEST_SIZE = 20;
    private transient MessageDigest digest;
    private byte[] state;
    private byte[] remainder;
    private int remCount;

    public SecureRandom() {
        this.init(null);
    }

    private SecureRandom(byte[] byArray) {
        this.init(byArray);
    }

    private void init(byte[] byArray) {
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    public byte[] engineGenerateSeed(int n2) {
        byte[] byArray = new byte[n2];
        SeedGenerator.generateSeed(byArray);
        return byArray;
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        if (this.state != null) {
            this.digest.update(this.state);
            for (int i2 = 0; i2 < this.state.length; ++i2) {
                this.state[i2] = 0;
            }
        }
        this.state = this.digest.digest(byArray);
    }

    private static void updateState(byte[] byArray, byte[] byArray2) {
        int n2 = 1;
        int n3 = 0;
        byte by = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n3 = byArray[i2] + byArray2[i2] + n2;
            by = (byte)n3;
            bl2 |= byArray[i2] != by;
            byArray[i2] = by;
            n2 = n3 >> 8;
        }
        if (!bl2) {
            byArray[0] = (byte)(byArray[0] + 1);
        }
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        byte[] byArray2 = this.remainder;
        if (this.state == null) {
            if (seeder == null) {
                seeder = new SecureRandom(SeedGenerator.getSystemEntropy());
                seeder.engineSetSeed(this.engineGenerateSeed(20));
            }
            byte[] byArray3 = new byte[20];
            seeder.engineNextBytes(byArray3);
            this.state = this.digest.digest(byArray3);
        }
        if ((n4 = this.remCount) > 0) {
            n3 = byArray.length - n5 < 20 - n4 ? byArray.length - n5 : 20 - n4;
            for (n2 = 0; n2 < n3; ++n2) {
                byArray[n2] = byArray2[n4];
                byArray2[n4++] = 0;
            }
            this.remCount += n3;
            n5 += n3;
        }
        while (n5 < byArray.length) {
            this.digest.update(this.state);
            byArray2 = this.digest.digest();
            SecureRandom.updateState(this.state, byArray2);
            n3 = byArray.length - n5 > 20 ? 20 : byArray.length - n5;
            for (n2 = 0; n2 < n3; ++n2) {
                byArray[n5++] = byArray2[n2];
                byArray2[n2] = 0;
            }
            this.remCount += n3;
        }
        this.remainder = byArray2;
        this.remCount %= 20;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
    }
}

