/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.a9;
import sun.security.krb5.internal.r;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncTicketPart {
    public TicketFlags flags;
    public EncryptionKey key;
    public Realm crealm;
    public PrincipalName cname;
    public a9 transited;
    public KerberosTime authtime;
    public KerberosTime starttime;
    public KerberosTime endtime;
    public KerberosTime renewTill;
    public HostAddresses caddr;
    public r authorizationData;

    public EncTicketPart(TicketFlags ticketFlags, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, a9 a92, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses, r r2) {
        this.flags = ticketFlags;
        this.key = encryptionKey;
        this.crealm = realm;
        this.cname = principalName;
        this.transited = a92;
        this.authtime = kerberosTime;
        this.starttime = kerberosTime2;
        this.endtime = kerberosTime3;
        this.renewTill = kerberosTime4;
        this.caddr = hostAddresses;
        this.authorizationData = r2;
    }

    public EncTicketPart(byte[] byArray) throws Asn1Exception, KrbException, IOException {
        this.init(new DerValue(byArray));
    }

    public EncTicketPart(DerValue derValue) throws Asn1Exception, KrbException, IOException {
        this.init(derValue);
    }

    private static String getHexBytes(byte[] byArray, int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] >> 4 & 0xF;
            int n4 = byArray[i2] & 0xF;
            stringBuffer.append(Integer.toHexString(n3));
            stringBuffer.append(Integer.toHexString(n4));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private void init(DerValue derValue) throws Asn1Exception, IOException, RealmException {
        this.renewTill = null;
        this.caddr = null;
        this.authorizationData = null;
        if ((derValue.getTag() & 0x1F) != 3 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.flags = TicketFlags.parse(derValue2.getData(), (byte)0, false);
        this.key = EncryptionKey.parse(derValue2.getData(), (byte)1, false);
        this.crealm = Realm.parse(derValue2.getData(), (byte)2, false);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)3, false);
        this.transited = a9.a(derValue2.getData(), (byte)4, false);
        this.authtime = KerberosTime.parse(derValue2.getData(), (byte)5, false);
        this.starttime = KerberosTime.parse(derValue2.getData(), (byte)6, true);
        this.endtime = KerberosTime.parse(derValue2.getData(), (byte)7, false);
        if (derValue2.getData().available() > 0) {
            this.renewTill = KerberosTime.parse(derValue2.getData(), (byte)8, true);
        }
        if (derValue2.getData().available() > 0) {
            this.caddr = HostAddresses.parse(derValue2.getData(), (byte)9, true);
        }
        if (derValue2.getData().available() > 0) {
            this.authorizationData = r.a(derValue2.getData(), (byte)10, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), this.flags.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), this.key.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), this.crealm.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), this.cname.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)4), this.transited.a());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)5), this.authtime.asn1Encode());
        if (this.starttime != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)6), this.starttime.asn1Encode());
        }
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)7), this.endtime.asn1Encode());
        if (this.renewTill != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)8), this.renewTill.asn1Encode());
        }
        if (this.caddr != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)9), this.caddr.asn1Encode());
        }
        if (this.authorizationData != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)10), this.authorizationData.a());
        }
        derOutputStream2.write((byte)48, derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)64, true, (byte)3), derOutputStream2);
        return derOutputStream.toByteArray();
    }
}

