/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.registry;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.misc.URLClassPath;
import sun.rmi.server.LoaderHandler;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;
import sun.rmi.transport.LiveRef;

public class RegistryImpl
extends RemoteServer
implements Registry {
    private static final long serialVersionUID = 4666870661827494597L;
    private Hashtable bindings = new Hashtable(101);
    private static Hashtable allowedAccessCache = new Hashtable(3);
    private static RegistryImpl registry;
    private static ObjID id;
    private static ResourceBundle resources;

    public RegistryImpl(int n2, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        LiveRef liveRef = new LiveRef(id, n2, rMIClientSocketFactory, rMIServerSocketFactory);
        this.setup(new UnicastServerRef2(liveRef));
    }

    public RegistryImpl(int n2) throws RemoteException {
        LiveRef liveRef = new LiveRef(id, n2);
        this.setup(new UnicastServerRef(liveRef));
    }

    private void setup(UnicastServerRef unicastServerRef) throws RemoteException {
        this.ref = unicastServerRef;
        unicastServerRef.exportObject(this, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote lookup(String string) throws RemoteException, NotBoundException {
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote = (Remote)this.bindings.get(string);
            if (remote == null) {
                throw new NotBoundException(string);
            }
            return remote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
        RegistryImpl.checkAccess("Registry.bind");
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote2 = (Remote)this.bindings.get(string);
            if (remote2 != null) {
                throw new AlreadyBoundException(string);
            }
            this.bindings.put(string, remote);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String string) throws RemoteException, NotBoundException, AccessException {
        RegistryImpl.checkAccess("Registry.unbind");
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote = (Remote)this.bindings.get(string);
            if (remote == null) {
                throw new NotBoundException(string);
            }
            this.bindings.remove(string);
        }
    }

    public void rebind(String string, Remote remote) throws RemoteException, AccessException {
        RegistryImpl.checkAccess("Registry.rebind");
        this.bindings.put(string, remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list() throws RemoteException {
        String[] stringArray;
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            int n2 = this.bindings.size();
            stringArray = new String[n2];
            Enumeration enumeration = this.bindings.keys();
            while (--n2 >= 0) {
                stringArray[n2] = (String)enumeration.nextElement();
            }
        }
        return stringArray;
    }

    public static void checkAccess(String string) throws AccessException {
        block7: {
            try {
                final String string2 = RegistryImpl.getClientHost();
                InetAddress inetAddress = null;
                try {
                    inetAddress = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws UnknownHostException {
                            return InetAddress.getByName(string2);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (UnknownHostException)privilegedActionException.getException();
                }
                if (allowedAccessCache.get(inetAddress) != null) break block7;
                try {
                    final InetAddress inetAddress2 = inetAddress;
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            new ServerSocket(0, 10, inetAddress2).close();
                            allowedAccessCache.put(inetAddress2, inetAddress2);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new AccessException("Registry." + string + " disallowed; origin " + inetAddress + " is non-local host");
                }
            }
            catch (ServerNotActiveException serverNotActiveException) {
            }
            catch (UnknownHostException unknownHostException) {
                throw new AccessException("Registry." + string + " disallowed; origin is unknown host");
            }
        }
    }

    public static ObjID getID() {
        return id;
    }

    private static String getTextResource(String string) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("sun.rmi.registry.resources.rmiregistry");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resources == null) {
                return "[missing resource file: " + string + "]";
            }
        }
        String string2 = null;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 == null) {
            return "[missing resource: " + string + "]";
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            String string = System.getProperty("env.class.path");
            if (string == null) {
                string = ".";
            }
            URL[] uRLArray = URLClassPath.pathToURLs(string);
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            LoaderHandler.registerCodebaseLoader(uRLClassLoader);
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
            int n2 = 1099;
            if (stringArray.length >= 1) {
                n2 = Integer.parseInt(stringArray[0]);
            }
            registry = new RegistryImpl(n2);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(MessageFormat.format(RegistryImpl.getTextResource("rmiregistry.port.badnumber"), stringArray[0]));
            System.err.println(MessageFormat.format(RegistryImpl.getTextResource("rmiregistry.usage"), "rmiregistry"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(1);
    }

    static {
        id = new ObjID(0);
        resources = null;
    }
}

