/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class SingleByteEncoder
extends CharsetEncoder {
    private final short[] index1;
    private final String index2;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected SingleByteEncoder(Charset charset, short[] sArray, String string, int n2, int n3, int n4) {
        super(charset, 1.0f, 1.0f);
        this.index1 = sArray;
        this.index2 = string;
        this.mask1 = n2;
        this.mask2 = n3;
        this.shift = n4;
    }

    public boolean canEncode(char c2) {
        char c3 = this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
        return c3 != '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.position();
        int n3 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n2 <= n3);
        byte[] byArray = byteBuffer.array();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n5 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n4 <= n5);
        n4 = n4 <= n5 ? n4 : n5;
        try {
            for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; ++n2) {
                char c2 = cArray[n2];
                if (Surrogate.is(c2)) {
                    if (this.sgp.parse(c2, cArray, n2, n3) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c2 >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (n5 - n4 < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char c3 = this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
                if (c3 == '\u0000' && c2 != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                byArray[n4++] = (byte)c3;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n2 - charBuffer.arrayOffset());
            byteBuffer.position(n4 - byteBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n2 = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c2 = charBuffer.get();
                if (Surrogate.is(c2)) {
                    if (this.sgp.parse(c2, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c2 >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!byteBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char c3 = this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
                if (c3 == '\u0000' && c2 != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                ++n2;
                byteBuffer.put((byte)c3);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n2);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    public byte encode(char c2) {
        return (byte)this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
    }
}

