/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import sun.misc.CEFormatException;
import sun.misc.CEStreamExhausted;
import sun.misc.CharacterDecoder;

public class UUDecoder
extends CharacterDecoder {
    public String bufferName;
    public int mode;
    private byte[] decoderBuffer = new byte[4];

    protected int bytesPerAtom() {
        return 3;
    }

    protected int bytesPerLine() {
        return 45;
    }

    protected void decodeAtom(PushbackInputStream pushbackInputStream, OutputStream outputStream, int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = pushbackInputStream.read();
            if (n3 == -1) {
                throw new CEStreamExhausted();
            }
            stringBuffer.append((char)n3);
            this.decoderBuffer[i2] = (byte)(n3 - 32 & 0x3F);
        }
        int n4 = this.decoderBuffer[0] << 2 & 0xFC | this.decoderBuffer[1] >>> 4 & 3;
        int n5 = this.decoderBuffer[1] << 4 & 0xF0 | this.decoderBuffer[2] >>> 2 & 0xF;
        int n6 = this.decoderBuffer[2] << 6 & 0xC0 | this.decoderBuffer[3] & 0x3F;
        outputStream.write((byte)(n4 & 0xFF));
        if (n2 > 1) {
            outputStream.write((byte)(n5 & 0xFF));
        }
        if (n2 > 2) {
            outputStream.write((byte)(n6 & 0xFF));
        }
    }

    protected void decodeBufferPrefix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(32);
        boolean bl2 = true;
        while (true) {
            if ((n2 = pushbackInputStream.read()) == -1) {
                throw new CEFormatException("UUDecoder: No begin line.");
            }
            if (n2 == 98 && bl2 && (n2 = pushbackInputStream.read()) == 101) break;
            bl2 = n2 == 10 || n2 == 13;
        }
        while (n2 != 10 && n2 != 13) {
            n2 = pushbackInputStream.read();
            if (n2 == -1) {
                throw new CEFormatException("UUDecoder: No begin line.");
            }
            if (n2 == 10 || n2 == 13) continue;
            stringBuffer.append((char)n2);
        }
        String string = stringBuffer.toString();
        if (string.indexOf(32) != 3) {
            throw new CEFormatException("UUDecoder: Malformed begin line.");
        }
        this.mode = Integer.parseInt(string.substring(4, 7));
        this.bufferName = string.substring(string.indexOf(32, 6) + 1);
        if (n2 == 13 && (n2 = pushbackInputStream.read()) != 10 && n2 != -1) {
            pushbackInputStream.unread(n2);
        }
    }

    protected int decodeLinePrefix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        int n2 = pushbackInputStream.read();
        if (n2 == 32) {
            n2 = pushbackInputStream.read();
            n2 = pushbackInputStream.read();
            if (n2 != 10 && n2 != -1) {
                pushbackInputStream.unread(n2);
            }
            throw new CEStreamExhausted();
        }
        if (n2 == -1) {
            throw new CEFormatException("UUDecoder: Short Buffer.");
        }
        if ((n2 = n2 - 32 & 0x3F) > this.bytesPerLine()) {
            throw new CEFormatException("UUDecoder: Bad Line Length.");
        }
        return n2;
    }

    protected void decodeLineSuffix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        block3: {
            int n2;
            do {
                if ((n2 = pushbackInputStream.read()) == -1) {
                    throw new CEStreamExhausted();
                }
                if (n2 == 10) break block3;
            } while (n2 != 13);
            n2 = pushbackInputStream.read();
            if (n2 != 10 && n2 != -1) {
                pushbackInputStream.unread(n2);
            }
        }
    }

    protected void decodeBufferSuffix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        int n2 = pushbackInputStream.read(this.decoderBuffer);
        if (this.decoderBuffer[0] != 101 || this.decoderBuffer[1] != 110 || this.decoderBuffer[2] != 100) {
            throw new CEFormatException("UUDecoder: Missing 'end' line.");
        }
    }
}

