/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.OSMBeanFactory;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementPermission;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogManager;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import sun.management.ClassLoadingImpl;
import sun.management.CompilationImpl;
import sun.management.GarbageCollectorImpl;
import sun.management.HotspotClassLoading;
import sun.management.HotspotClassLoadingMBean;
import sun.management.HotspotCompilation;
import sun.management.HotspotCompilationMBean;
import sun.management.HotspotMemory;
import sun.management.HotspotMemoryMBean;
import sun.management.HotspotRuntime;
import sun.management.HotspotRuntimeMBean;
import sun.management.HotspotThread;
import sun.management.HotspotThreadMBean;
import sun.management.MemoryImpl;
import sun.management.MemoryManagerImpl;
import sun.management.MemoryPoolImpl;
import sun.management.OperatingSystemImpl;
import sun.management.RuntimeImpl;
import sun.management.ThreadImpl;
import sun.management.Util;
import sun.management.VMManagement;
import sun.management.VMManagementImpl;
import sun.misc.VM;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    private static VMManagement jvm;
    private static boolean mbeansCreated;
    private static ClassLoadingImpl classMBean;
    private static MemoryImpl memoryMBean;
    private static ThreadImpl threadMBean;
    private static RuntimeImpl runtimeMBean;
    private static CompilationImpl compileMBean;
    private static OperatingSystemImpl osMBean;
    private static HotspotRuntime hsRuntimeMBean;
    private static HotspotClassLoading hsClassMBean;
    private static HotspotThread hsThreadMBean;
    private static HotspotCompilation hsCompileMBean;
    private static HotspotMemory hsMemoryMBean;
    private static Permission monitorPermission;
    private static Permission controlPermission;
    private static final String HOTSPOT_CLASS_LOADING_MBEAN_NAME = "sun.management:type=HotspotClassLoading";
    private static final String HOTSPOT_COMPILATION_MBEAN_NAME = "sun.management:type=HotspotCompilation";
    private static final String HOTSPOT_MEMORY_MBEAN_NAME = "sun.management:type=HotspotMemory";
    private static final String HOTSPOT_RUNTIME_MBEAN_NAME = "sun.management:type=HotspotRuntime";
    private static final String HOTSPOT_THREAD_MBEAN_NAME = "sun.management:type=HotspotThreading";
    private static final String HOTSPOT_INTERNAL_MBEAN_NAME = "sun.management:type=HotspotInternal";
    private static ObjectName hsInternalObjName;
    private static final int JMM_THREAD_STATE_FLAG_MASK = -1048576;
    private static final int JMM_THREAD_STATE_FLAG_SUSPENDED = 0x100000;
    private static final int JMM_THREAD_STATE_FLAG_NATIVE = 0x400000;

    private ManagementFactory() {
    }

    public static synchronized ClassLoadingMXBean getClassLoadingMXBean() {
        if (classMBean == null) {
            classMBean = new ClassLoadingImpl(jvm);
        }
        return classMBean;
    }

    public static synchronized MemoryMXBean getMemoryMXBean() {
        if (memoryMBean == null) {
            memoryMBean = new MemoryImpl(jvm);
        }
        return memoryMBean;
    }

    public static synchronized ThreadMXBean getThreadMXBean() {
        if (threadMBean == null) {
            threadMBean = new ThreadImpl(jvm);
        }
        return threadMBean;
    }

    public static synchronized RuntimeMXBean getRuntimeMXBean() {
        if (runtimeMBean == null) {
            runtimeMBean = new RuntimeImpl(jvm);
        }
        return runtimeMBean;
    }

    public static synchronized CompilationMXBean getCompilationMXBean() {
        if (compileMBean == null && jvm.getCompilerName() != null) {
            compileMBean = new CompilationImpl(jvm);
        }
        return compileMBean;
    }

    public static synchronized OperatingSystemMXBean getOperatingSystemMXBean() {
        if (osMBean == null) {
            osMBean = (OperatingSystemImpl)OSMBeanFactory.getOperatingSystemMXBean(jvm);
        }
        return osMBean;
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        MemoryPoolMXBean[] memoryPoolMXBeanArray = MemoryImpl.getMemoryPools();
        ArrayList<MemoryPoolMXBean> arrayList = new ArrayList<MemoryPoolMXBean>(memoryPoolMXBeanArray.length);
        for (int i2 = 0; i2 < memoryPoolMXBeanArray.length; ++i2) {
            MemoryPoolMXBean memoryPoolMXBean = memoryPoolMXBeanArray[i2];
            arrayList.add(memoryPoolMXBean);
        }
        return arrayList;
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        MemoryManagerMXBean[] memoryManagerMXBeanArray = MemoryImpl.getMemoryManagers();
        ArrayList<MemoryManagerMXBean> arrayList = new ArrayList<MemoryManagerMXBean>(memoryManagerMXBeanArray.length);
        for (int i2 = 0; i2 < memoryManagerMXBeanArray.length; ++i2) {
            MemoryManagerMXBean memoryManagerMXBean = memoryManagerMXBeanArray[i2];
            arrayList.add(memoryManagerMXBean);
        }
        return arrayList;
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        MemoryManagerMXBean[] memoryManagerMXBeanArray = MemoryImpl.getMemoryManagers();
        ArrayList<GarbageCollectorMXBean> arrayList = new ArrayList<GarbageCollectorMXBean>(memoryManagerMXBeanArray.length);
        for (int i2 = 0; i2 < memoryManagerMXBeanArray.length; ++i2) {
            if (!(memoryManagerMXBeanArray[i2] instanceof GarbageCollectorMXBean)) continue;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)memoryManagerMXBeanArray[i2];
            arrayList.add(garbageCollectorMXBean);
        }
        return arrayList;
    }

    public static synchronized HotspotRuntimeMBean getHotspotRuntimeMBean() {
        if (hsRuntimeMBean == null) {
            hsRuntimeMBean = new HotspotRuntime(jvm);
        }
        return hsRuntimeMBean;
    }

    public static synchronized HotspotClassLoadingMBean getHotspotClassLoadingMBean() {
        if (hsClassMBean == null) {
            hsClassMBean = new HotspotClassLoading(jvm);
        }
        return hsClassMBean;
    }

    public static synchronized HotspotThreadMBean getHotspotThreadMBean() {
        if (hsThreadMBean == null) {
            hsThreadMBean = new HotspotThread(jvm);
        }
        return hsThreadMBean;
    }

    public static synchronized HotspotMemoryMBean getHotspotMemoryMBean() {
        if (hsMemoryMBean == null) {
            hsMemoryMBean = new HotspotMemory(jvm);
        }
        return hsMemoryMBean;
    }

    public static synchronized HotspotCompilationMBean getHotspotCompilationMBean() {
        if (hsCompileMBean == null) {
            hsCompileMBean = new HotspotCompilation(jvm);
        }
        return hsCompileMBean;
    }

    static void checkAccess(Permission permission) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }

    static void checkMonitorAccess() throws SecurityException {
        ManagementFactory.checkAccess(monitorPermission);
    }

    static void checkControlAccess() throws SecurityException {
        ManagementFactory.checkAccess(controlPermission);
    }

    private static void addMBean(MBeanServer mBeanServer, Object object, String string) {
        ManagementFactory.addMBean(mBeanServer, object, string, false);
    }

    private static void addMBean(MBeanServer mBeanServer, Object object, String string, boolean bl2) {
        try {
            final ObjectName objectName = new ObjectName(string);
            final MBeanServer mBeanServer2 = mBeanServer;
            final Object object2 = object;
            final boolean bl3 = bl2;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                    try {
                        ObjectInstance objectInstance = mBeanServer2.registerMBean(object2, objectName);
                        return null;
                    }
                    catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                        if (!bl3) {
                            throw instanceAlreadyExistsException;
                        }
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw Util.newException(privilegedActionException.getException());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw Util.newException(malformedObjectNameException);
        }
    }

    public static MBeanServer createPlatformMBeanServer() {
        MBeanServer mBeanServer = MBeanServerFactory.createMBeanServer();
        ManagementFactory.addMBean(mBeanServer, ManagementFactory.getClassLoadingMXBean(), "java.lang:type=ClassLoading");
        ManagementFactory.addMBean(mBeanServer, ManagementFactory.getMemoryMXBean(), "java.lang:type=Memory");
        ManagementFactory.addMBean(mBeanServer, ManagementFactory.getOperatingSystemMXBean(), "java.lang:type=OperatingSystem");
        ManagementFactory.addMBean(mBeanServer, ManagementFactory.getRuntimeMXBean(), "java.lang:type=Runtime");
        ManagementFactory.addMBean(mBeanServer, ManagementFactory.getThreadMXBean(), "java.lang:type=Threading");
        if (ManagementFactory.getCompilationMXBean() != null) {
            ManagementFactory.addMBean(mBeanServer, ManagementFactory.getCompilationMXBean(), "java.lang:type=Compilation");
        }
        ManagementFactory.addMemoryManagers(mBeanServer);
        ManagementFactory.addMemoryPools(mBeanServer);
        ManagementFactory.addMBean(mBeanServer, LogManager.getLoggingMXBean(), "java.util.logging:type=Logging");
        return mBeanServer;
    }

    static synchronized ObjectName getHotspotInternalObjectName() {
        if (hsInternalObjName == null) {
            try {
                hsInternalObjName = new ObjectName(HOTSPOT_INTERNAL_MBEAN_NAME);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw Util.newException(malformedObjectNameException);
            }
        }
        return hsInternalObjName;
    }

    static void registerInternalMBeans(MBeanServer mBeanServer) {
        ManagementFactory.addMBean(mBeanServer, ManagementFactory.getHotspotClassLoadingMBean(), HOTSPOT_CLASS_LOADING_MBEAN_NAME, true);
        ManagementFactory.addMBean(mBeanServer, ManagementFactory.getHotspotMemoryMBean(), HOTSPOT_MEMORY_MBEAN_NAME, true);
        ManagementFactory.addMBean(mBeanServer, ManagementFactory.getHotspotRuntimeMBean(), HOTSPOT_RUNTIME_MBEAN_NAME, true);
        ManagementFactory.addMBean(mBeanServer, ManagementFactory.getHotspotThreadMBean(), HOTSPOT_THREAD_MBEAN_NAME, true);
        if (ManagementFactory.getCompilationMXBean() != null) {
            ManagementFactory.addMBean(mBeanServer, ManagementFactory.getHotspotCompilationMBean(), HOTSPOT_COMPILATION_MBEAN_NAME, true);
        }
    }

    private static void unregisterMBean(MBeanServer mBeanServer, String string) {
        try {
            final ObjectName objectName = new ObjectName(string);
            final MBeanServer mBeanServer2 = mBeanServer;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MBeanRegistrationException, RuntimeOperationsException {
                    try {
                        mBeanServer2.unregisterMBean(objectName);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw Util.newException(privilegedActionException.getException());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw Util.newException(malformedObjectNameException);
        }
    }

    static void unregisterInternalMBeans(MBeanServer mBeanServer) {
        ManagementFactory.unregisterMBean(mBeanServer, HOTSPOT_CLASS_LOADING_MBEAN_NAME);
        ManagementFactory.unregisterMBean(mBeanServer, HOTSPOT_MEMORY_MBEAN_NAME);
        ManagementFactory.unregisterMBean(mBeanServer, HOTSPOT_RUNTIME_MBEAN_NAME);
        ManagementFactory.unregisterMBean(mBeanServer, HOTSPOT_THREAD_MBEAN_NAME);
        if (ManagementFactory.getCompilationMXBean() != null) {
            ManagementFactory.unregisterMBean(mBeanServer, HOTSPOT_COMPILATION_MBEAN_NAME);
        }
    }

    private static synchronized void addMemoryPools(MBeanServer mBeanServer) {
        MemoryPoolMXBean[] memoryPoolMXBeanArray = MemoryImpl.getMemoryPools();
        for (int i2 = 0; i2 < memoryPoolMXBeanArray.length; ++i2) {
            String string = Util.getMBeanObjectName(memoryPoolMXBeanArray[i2]);
            ManagementFactory.addMBean(mBeanServer, memoryPoolMXBeanArray[i2], string);
        }
    }

    private static synchronized void addMemoryManagers(MBeanServer mBeanServer) {
        MemoryManagerMXBean[] memoryManagerMXBeanArray = MemoryImpl.getMemoryManagers();
        for (int i2 = 0; i2 < memoryManagerMXBeanArray.length; ++i2) {
            String string = Util.getMBeanObjectName(memoryManagerMXBeanArray[i2]);
            ManagementFactory.addMBean(mBeanServer, memoryManagerMXBeanArray[i2], string);
        }
    }

    private static MemoryPoolMXBean createMemoryPool(String string, boolean bl2, long l2, long l3) {
        return new MemoryPoolImpl(string, bl2, l2, l3);
    }

    private static MemoryManagerMXBean createMemoryManager(String string) {
        return new MemoryManagerImpl(string);
    }

    private static GarbageCollectorMXBean createGarbageCollector(String string, String string2) {
        return new GarbageCollectorImpl(string);
    }

    public static boolean isThreadSuspended(int n2) {
        return (n2 & 0x100000) != 0;
    }

    public static boolean isThreadRunningNative(int n2) {
        return (n2 & 0x400000) != 0;
    }

    public static Thread.State toThreadState(int n2) {
        int n3 = n2 & 0xFFFFF;
        return VM.toThreadState(n3);
    }

    static {
        mbeansCreated = false;
        classMBean = null;
        memoryMBean = null;
        threadMBean = null;
        runtimeMBean = null;
        compileMBean = null;
        osMBean = null;
        hsRuntimeMBean = null;
        hsClassMBean = null;
        hsThreadMBean = null;
        hsCompileMBean = null;
        hsMemoryMBean = null;
        monitorPermission = new ManagementPermission("monitor");
        controlPermission = new ManagementPermission("control");
        hsInternalObjName = null;
        AccessController.doPrivileged(new LoadLibraryAction("management"));
        jvm = new VMManagementImpl();
    }
}

