/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import sun.management.CompilerThreadStat;
import sun.management.HotspotCompilationMBean;
import sun.management.MethodInfo;
import sun.management.VMManagement;
import sun.management.counter.Counter;
import sun.management.counter.LongCounter;
import sun.management.counter.StringCounter;

class HotspotCompilation
implements HotspotCompilationMBean {
    private VMManagement jvm;
    private static final String JAVA_CI = "java.ci.";
    private static final String COM_SUN_CI = "com.sun.ci.";
    private static final String SUN_CI = "sun.ci.";
    private static final String CI_COUNTER_NAME_PATTERN = "java.ci.|com.sun.ci.|sun.ci.";
    private LongCounter compilerThreads;
    private LongCounter totalCompiles;
    private LongCounter totalBailouts;
    private LongCounter totalInvalidates;
    private LongCounter nmethodCodeSize;
    private LongCounter nmethodSize;
    private StringCounter lastMethod;
    private LongCounter lastSize;
    private LongCounter lastType;
    private StringCounter lastFailedMethod;
    private LongCounter lastFailedType;
    private StringCounter lastInvalidatedMethod;
    private LongCounter lastInvalidatedType;
    private CompilerThreadInfo[] threads;
    private int numActiveThreads;
    private Map counters;

    HotspotCompilation(VMManagement vMManagement) {
        this.jvm = vMManagement;
        this.initCompilerCounters();
    }

    private Counter lookup(String string) {
        Counter counter = null;
        counter = (Counter)this.counters.get(SUN_CI + string);
        if (counter != null) {
            return counter;
        }
        counter = (Counter)this.counters.get(COM_SUN_CI + string);
        if (counter != null) {
            return counter;
        }
        counter = (Counter)this.counters.get(JAVA_CI + string);
        if (counter != null) {
            return counter;
        }
        throw new InternalError("Counter " + string + " does not exist");
    }

    private void initCompilerCounters() {
        ListIterator listIterator = this.getInternalCompilerCounters().listIterator();
        this.counters = new TreeMap();
        while (listIterator.hasNext()) {
            Counter counter = (Counter)listIterator.next();
            this.counters.put(counter.getName(), counter);
        }
        this.compilerThreads = (LongCounter)this.lookup("threads");
        this.totalCompiles = (LongCounter)this.lookup("totalCompiles");
        this.totalBailouts = (LongCounter)this.lookup("totalBailouts");
        this.totalInvalidates = (LongCounter)this.lookup("totalInvalidates");
        this.nmethodCodeSize = (LongCounter)this.lookup("nmethodCodeSize");
        this.nmethodSize = (LongCounter)this.lookup("nmethodSize");
        this.lastMethod = (StringCounter)this.lookup("lastMethod");
        this.lastSize = (LongCounter)this.lookup("lastSize");
        this.lastType = (LongCounter)this.lookup("lastType");
        this.lastFailedMethod = (StringCounter)this.lookup("lastFailedMethod");
        this.lastFailedType = (LongCounter)this.lookup("lastFailedType");
        this.lastInvalidatedMethod = (StringCounter)this.lookup("lastInvalidatedMethod");
        this.lastInvalidatedType = (LongCounter)this.lookup("lastInvalidatedType");
        this.numActiveThreads = (int)this.compilerThreads.longValue();
        this.threads = new CompilerThreadInfo[this.numActiveThreads + 1];
        if (this.counters.containsKey("sun.ci.adapterThread.compiles")) {
            this.threads[0] = new CompilerThreadInfo("adapterThread", 0);
            ++this.numActiveThreads;
        } else {
            this.threads[0] = null;
        }
        for (int i2 = 1; i2 < this.threads.length; ++i2) {
            this.threads[i2] = new CompilerThreadInfo("compilerThread", i2 - 1);
        }
    }

    public int getCompilerThreadCount() {
        return this.numActiveThreads;
    }

    public long getTotalCompileCount() {
        return this.totalCompiles.longValue();
    }

    public long getBailoutCompileCount() {
        return this.totalBailouts.longValue();
    }

    public long getInvalidatedCompileCount() {
        return this.totalInvalidates.longValue();
    }

    public long getCompiledMethodCodeSize() {
        return this.nmethodCodeSize.longValue();
    }

    public long getCompiledMethodSize() {
        return this.nmethodSize.longValue();
    }

    public List getCompilerThreadStats() {
        ArrayList<CompilerThreadStat> arrayList = new ArrayList<CompilerThreadStat>(this.threads.length);
        int n2 = 0;
        if (this.threads[0] == null) {
            n2 = 1;
        }
        while (n2 < this.threads.length) {
            arrayList.add(this.threads[n2].getCompilerThreadStat());
            ++n2;
        }
        return arrayList;
    }

    public MethodInfo getLastCompile() {
        return new MethodInfo(this.lastMethod.stringValue(), (int)this.lastType.longValue(), (int)this.lastSize.longValue());
    }

    public MethodInfo getFailedCompile() {
        return new MethodInfo(this.lastFailedMethod.stringValue(), (int)this.lastFailedType.longValue(), -1);
    }

    public MethodInfo getInvalidatedCompile() {
        return new MethodInfo(this.lastInvalidatedMethod.stringValue(), (int)this.lastInvalidatedType.longValue(), -1);
    }

    public List getInternalCompilerCounters() {
        return this.jvm.getInternalCounters(CI_COUNTER_NAME_PATTERN);
    }

    private class CompilerThreadInfo {
        int index;
        String name;
        StringCounter method;
        LongCounter type;
        LongCounter compiles;
        LongCounter time;

        CompilerThreadInfo(String string, int n2) {
            String string2 = string + "." + n2 + ".";
            this.name = string + "-" + n2;
            this.method = (StringCounter)HotspotCompilation.this.lookup(string2 + "method");
            this.type = (LongCounter)HotspotCompilation.this.lookup(string2 + "type");
            this.compiles = (LongCounter)HotspotCompilation.this.lookup(string2 + "compiles");
            this.time = (LongCounter)HotspotCompilation.this.lookup(string2 + "time");
        }

        CompilerThreadInfo(String string) {
            String string2 = string + ".";
            this.name = string;
            this.method = (StringCounter)HotspotCompilation.this.lookup(string2 + "method");
            this.type = (LongCounter)HotspotCompilation.this.lookup(string2 + "type");
            this.compiles = (LongCounter)HotspotCompilation.this.lookup(string2 + "compiles");
            this.time = (LongCounter)HotspotCompilation.this.lookup(string2 + "time");
        }

        CompilerThreadStat getCompilerThreadStat() {
            MethodInfo methodInfo = new MethodInfo(this.method.stringValue(), (int)this.type.longValue(), -1);
            return new CompilerThreadStat(this.name, this.compiles.longValue(), this.time.longValue(), methodInfo);
        }
    }
}

