/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import sun.management.counter.Counter;
import sun.management.counter.Units;
import sun.management.counter.perf.PerfInstrumentation;
import sun.misc.Perf;

public class ConnectorAddressLink {
    private static final String CONNECTOR_ADDRESS_COUNTER = "sun.management.JMXConnectorServer.address";

    public static void export(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("address not specified");
        }
        Perf perf = Perf.getPerf();
        perf.createString(CONNECTOR_ADDRESS_COUNTER, 1, Units.STRING.intValue(), string);
    }

    public static String importFrom(int n2) throws IOException {
        ByteBuffer byteBuffer;
        Perf perf = Perf.getPerf();
        try {
            byteBuffer = perf.attach(n2, "r");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        List list = new PerfInstrumentation(byteBuffer).findByPattern(CONNECTOR_ADDRESS_COUNTER);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            Counter counter = (Counter)iterator.next();
            return (String)counter.getValue();
        }
        return null;
    }
}

