/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import javax.swing.text.TabStop;

public class TabSet
implements Serializable {
    private TabStop[] tabs;
    private int hashCode = Integer.MAX_VALUE;

    public TabSet(TabStop[] tabStopArray) {
        if (tabStopArray != null) {
            int n2 = tabStopArray.length;
            this.tabs = new TabStop[n2];
            System.arraycopy(tabStopArray, 0, this.tabs, 0, n2);
        } else {
            this.tabs = null;
        }
    }

    public int getTabCount() {
        return this.tabs == null ? 0 : this.tabs.length;
    }

    public TabStop getTab(int n2) {
        int n3 = this.getTabCount();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException(n2 + " is outside the range of tabs");
        }
        return this.tabs[n2];
    }

    public TabStop getTabAfter(float f2) {
        int n2 = this.getTabIndexAfter(f2);
        return n2 == -1 ? null : this.tabs[n2];
    }

    public int getTabIndex(TabStop tabStop) {
        for (int i2 = this.getTabCount() - 1; i2 >= 0; --i2) {
            if (this.getTab(i2) != tabStop) continue;
            return i2;
        }
        return -1;
    }

    public int getTabIndexAfter(float f2) {
        int n2 = 0;
        int n3 = this.getTabCount();
        while (n2 != n3) {
            int n4 = (n3 - n2) / 2 + n2;
            if (f2 > this.tabs[n4].getPosition()) {
                if (n2 == n4) {
                    n2 = n3;
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 == 0 || f2 > this.tabs[n4 - 1].getPosition()) {
                return n4;
            }
            n3 = n4;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TabSet) {
            TabSet tabSet = (TabSet)object;
            int n2 = this.getTabCount();
            if (tabSet.getTabCount() != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                TabStop tabStop = this.getTab(i2);
                TabStop tabStop2 = tabSet.getTab(i2);
                if ((tabStop != null || tabStop2 == null) && (tabStop == null || this.getTab(i2).equals(tabSet.getTab(i2)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MAX_VALUE) {
            this.hashCode = 0;
            int n2 = this.getTabCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                TabStop tabStop = this.getTab(i2);
                this.hashCode ^= tabStop != null ? this.getTab(i2).hashCode() : 0;
            }
            if (this.hashCode == Integer.MAX_VALUE) {
                --this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        int n2 = this.getTabCount();
        StringBuffer stringBuffer = new StringBuffer("[ ");
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" - ");
            }
            stringBuffer.append(this.getTab(i2).toString());
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

