/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthBorder;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.swing.plaf.synth.SynthUI;

class SynthTableUI
extends BasicTableUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;
    private boolean useTableColors;
    private boolean useUIBorder;
    private TableCellRenderer dateRenderer;
    private TableCellRenderer numberRenderer;
    private TableCellRenderer doubleRender;
    private TableCellRenderer floatRenderer;
    private TableCellRenderer iconRenderer;
    private TableCellRenderer imageIconRenderer;
    private TableCellRenderer booleanRenderer;
    private TableCellRenderer objectRenderer;

    SynthTableUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTableUI();
    }

    protected void installDefaults() {
        this.dateRenderer = this.installRendererIfPossible(Date.class, null);
        this.numberRenderer = this.installRendererIfPossible(Number.class, null);
        this.doubleRender = this.installRendererIfPossible(Double.class, null);
        this.floatRenderer = this.installRendererIfPossible(Float.class, null);
        this.iconRenderer = this.installRendererIfPossible(Icon.class, null);
        this.imageIconRenderer = this.installRendererIfPossible(ImageIcon.class, null);
        this.booleanRenderer = this.installRendererIfPossible(Boolean.class, new SynthBooleanTableCellRenderer());
        this.objectRenderer = this.installRendererIfPossible(Object.class, new SynthTableCellRenderer());
        this.updateStyle(this.table);
    }

    private TableCellRenderer installRendererIfPossible(Class clazz, TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.table.getDefaultRenderer(clazz);
        if (tableCellRenderer2 instanceof UIResource) {
            this.table.setDefaultRenderer(clazz, tableCellRenderer);
        }
        return tableCellRenderer2;
    }

    private void updateStyle(JTable jTable) {
        SynthContext synthContext = this.getContext(jTable, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Color color;
            synthContext.setComponentState(513);
            Color color2 = this.table.getSelectionBackground();
            if (color2 == null || color2 instanceof UIResource) {
                this.table.setSelectionBackground(this.style.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            if ((color = this.table.getSelectionForeground()) == null || color instanceof UIResource) {
                this.table.setSelectionForeground(this.style.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            synthContext.setComponentState(1);
            Color color3 = this.table.getGridColor();
            if (color3 == null || color3 instanceof UIResource) {
                color3 = (Color)this.style.get(synthContext, "Table.gridColor");
                if (color3 == null) {
                    color3 = this.style.getColor(synthContext, ColorType.FOREGROUND);
                }
                this.table.setGridColor(color3);
            }
            this.useTableColors = this.style.getBoolean(synthContext, "Table.rendererUseTableColors", true);
            this.useUIBorder = this.style.getBoolean(synthContext, "Table.rendererUseUIBorder", true);
            Object object = this.style.get(synthContext, "Table.rowHeight");
            if (object != null) {
                LookAndFeel.installProperty(this.table, "rowHeight", object);
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    protected void installListeners() {
        super.installListeners();
        this.table.addPropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        this.table.setDefaultRenderer(Date.class, this.dateRenderer);
        this.table.setDefaultRenderer(Number.class, this.numberRenderer);
        this.table.setDefaultRenderer(Double.class, this.doubleRender);
        this.table.setDefaultRenderer(Float.class, this.floatRenderer);
        this.table.setDefaultRenderer(Icon.class, this.iconRenderer);
        this.table.setDefaultRenderer(ImageIcon.class, this.imageIconRenderer);
        this.table.setDefaultRenderer(Boolean.class, this.booleanRenderer);
        this.table.setDefaultRenderer(Object.class, this.objectRenderer);
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
        SynthContext synthContext = this.getContext(this.table, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.table.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintTableBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintTableBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        boolean bl2;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.rowAtPoint(point2);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = this.table.getRowCount() - 1;
        }
        int n4 = this.table.columnAtPoint((bl2 = this.table.getComponentOrientation().isLeftToRight()) ? point : point2);
        int n5 = this.table.columnAtPoint(bl2 ? point2 : point);
        if (n4 == -1) {
            n4 = 0;
        }
        if (n5 == -1) {
            n5 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(synthContext, graphics, n2, n3, n4, n5);
        this.paintCells(synthContext, graphics, n2, n3, n4, n5);
    }

    private void paintGrid(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        graphics.setColor(this.table.getGridColor());
        Rectangle rectangle = this.table.getCellRect(n2, n4, true);
        Rectangle rectangle2 = this.table.getCellRect(n3, n5, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        SynthGraphicsUtils synthGraphicsUtils = synthContext.getStyle().getGraphicsUtils(synthContext);
        if (this.table.getShowHorizontalLines()) {
            int n8 = rectangle3.x + rectangle3.width;
            n7 = rectangle3.y;
            for (n6 = n2; n6 <= n3; ++n6) {
                synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, rectangle3.x, (n7 += this.table.getRowHeight(n6)) - 1, n8 - 1, n7 - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n7 = rectangle3.y + rectangle3.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                n6 = rectangle3.x;
                for (int i2 = n4; i2 <= n5; ++i2) {
                    int n9 = tableColumnModel.getColumn(i2).getWidth();
                    synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, (n6 += n9) - 1, 0, n6 - 1, n7 - 1);
                }
            } else {
                n6 = rectangle3.x + rectangle3.width;
                for (int i3 = n4; i3 < n5; ++i3) {
                    int n10 = tableColumnModel.getColumn(i3).getWidth();
                    synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, (n6 -= n10) - 1, 0, n6 - 1, n7 - 1);
                }
                synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, n6 -= tableColumnModel.getColumn(n5).getWidth(), 0, n6, n7 - 1);
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    private void paintCells(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n6 = tableColumnModel.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                Rectangle rectangle = this.table.getCellRect(i2, n4, false);
                for (int i3 = n4; i3 <= n5; ++i3) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(i3);
                    int n7 = tableColumn2.getWidth();
                    rectangle.width = n7 - n6;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(synthContext, graphics, rectangle, i2, i3);
                    }
                    rectangle.x += n7;
                }
            }
        } else {
            for (int i4 = n2; i4 <= n3; ++i4) {
                int n8;
                Rectangle rectangle = this.table.getCellRect(i4, n4, false);
                TableColumn tableColumn3 = tableColumnModel.getColumn(n4);
                if (tableColumn3 != tableColumn) {
                    n8 = tableColumn3.getWidth();
                    rectangle.width = n8 - n6;
                    this.paintCell(synthContext, graphics, rectangle, i4, n4);
                }
                for (int i5 = n4 + 1; i5 <= n5; ++i5) {
                    tableColumn3 = tableColumnModel.getColumn(i5);
                    n8 = tableColumn3.getWidth();
                    rectangle.width = n8 - n6;
                    rectangle.x -= n8;
                    if (tableColumn3 == tableColumn) continue;
                    this.paintCell(synthContext, graphics, rectangle, i4, i5);
                }
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(synthContext, graphics, n2, n3, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(SynthContext synthContext, Graphics graphics, int n2, int n3, TableColumn tableColumn, int n4) {
        int n5;
        int n6;
        int n7 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n2, n7, true);
        Rectangle rectangle2 = this.table.getCellRect(n3, n7, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n4;
        graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.BACKGROUND));
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        SynthGraphicsUtils synthGraphicsUtils = synthContext.getStyle().getGraphicsUtils(synthContext);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n6 = rectangle3.x;
            int n8 = rectangle3.y;
            int n9 = n6 + rectangle3.width - 1;
            n5 = n8 + rectangle3.height - 1;
            synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, n6 - 1, n8, n6 - 1, n5);
            synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, n9, n8, n9, n5);
        }
        for (n6 = n2; n6 <= n3; ++n6) {
            Rectangle rectangle4 = this.table.getCellRect(n6, n7, false);
            rectangle4.x += n4;
            this.paintCell(synthContext, graphics, rectangle4, n6, n7);
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle5 = this.table.getCellRect(n6, n7, true);
            rectangle5.x += n4;
            n5 = rectangle5.x;
            int n10 = rectangle5.y;
            int n11 = n5 + rectangle5.width - 1;
            int n12 = n10 + rectangle5.height - 1;
            synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, n5, n12, n11, n12);
        }
    }

    private void paintCell(SynthContext synthContext, Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (this.table.isEditing() && this.table.getEditingRow() == n2 && this.table.getEditingColumn() == n3) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n2, n3);
            Component component = this.table.prepareRenderer(tableCellRenderer, n2, n3);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JTable)propertyChangeEvent.getSource());
        }
    }

    private class SynthBooleanTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public SynthBooleanTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                return "Table.cellRenderer";
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (bl2) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    private class SynthTableCellRenderer
    extends DefaultTableCellRenderer {
        private Object numberFormat;
        private Object dateFormat;
        private boolean opaque;

        private SynthTableCellRenderer() {
        }

        public void setOpaque(boolean bl2) {
            this.opaque = bl2;
        }

        public boolean isOpaque() {
            return this.opaque;
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                return "Table.cellRenderer";
            }
            return string;
        }

        public void setBorder(Border border) {
            if (SynthTableUI.this.useUIBorder || border instanceof SynthBorder) {
                super.setBorder(border);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (!SynthTableUI.this.useTableColors && (bl2 || bl3)) {
                SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), bl2, bl3, jTable.isEnabled());
            } else {
                SynthLookAndFeel.resetSelectedUI();
            }
            super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            this.setIcon(null);
            Class<?> clazz = jTable.getColumnClass(n3);
            this.configureValue(object, clazz);
            return this;
        }

        private void configureValue(Object object, Class clazz) {
            if (clazz == Object.class || clazz == null) {
                this.setHorizontalAlignment(10);
            } else if (clazz == Float.class || clazz == Double.class) {
                if (this.numberFormat == null) {
                    this.numberFormat = NumberFormat.getInstance();
                }
                this.setHorizontalAlignment(11);
                this.setText(object == null ? "" : ((NumberFormat)this.numberFormat).format(object));
            } else if (clazz == Number.class) {
                this.setHorizontalAlignment(11);
            } else if (clazz == Icon.class || clazz == ImageIcon.class) {
                this.setHorizontalAlignment(0);
                this.setIcon((Icon)object);
                this.setText("");
            } else if (clazz == Date.class) {
                if (this.dateFormat == null) {
                    this.dateFormat = DateFormat.getDateInstance();
                }
                this.setHorizontalAlignment(10);
                this.setText(object == null ? "" : ((Format)this.dateFormat).format(object));
            } else {
                this.configureValue(object, clazz.getSuperclass());
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

