/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.plaf.synth.SynthUI;

class SynthTabbedPaneUI
extends BasicTabbedPaneUI
implements SynthUI,
PropertyChangeListener {
    private SynthContext tabAreaContext;
    private SynthContext tabContext;
    private SynthContext tabContentContext;
    private SynthStyle style;
    private SynthStyle tabStyle;
    private SynthStyle tabAreaStyle;
    private SynthStyle tabContentStyle;
    private Rectangle tabAreaBounds = new Rectangle();

    SynthTabbedPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTabbedPaneUI();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    protected void installDefaults() {
        this.updateStyle(this.tabPane);
    }

    private void updateStyle(JTabbedPane jTabbedPane) {
        SynthContext synthContext = this.getContext((JComponent)jTabbedPane, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.tabRunOverlay = this.style.getInt(synthContext, "TabbedPane.tabRunOverlay", 0);
            this.textIconGap = this.style.getInt(synthContext, "TabbedPane.textIconGap", 0);
            this.selectedTabPadInsets = (Insets)this.style.get(synthContext, "TabbedPane.selectedTabPadInsets");
            if (this.selectedTabPadInsets == null) {
                this.selectedTabPadInsets = new Insets(0, 0, 0, 0);
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
        if (this.tabContext != null) {
            this.tabContext.dispose();
        }
        this.tabContext = this.getContext(jTabbedPane, Region.TABBED_PANE_TAB, 1);
        this.tabStyle = SynthLookAndFeel.updateStyle(this.tabContext, this);
        this.tabInsets = this.tabStyle.getInsets(this.tabContext, null);
        if (this.tabAreaContext != null) {
            this.tabAreaContext.dispose();
        }
        this.tabAreaContext = this.getContext(jTabbedPane, Region.TABBED_PANE_TAB_AREA, 1);
        this.tabAreaStyle = SynthLookAndFeel.updateStyle(this.tabAreaContext, this);
        this.tabAreaInsets = this.tabAreaStyle.getInsets(this.tabAreaContext, null);
        if (this.tabContentContext != null) {
            this.tabContentContext.dispose();
        }
        this.tabContentContext = this.getContext(jTabbedPane, Region.TABBED_PANE_CONTENT, 1);
        this.tabContentStyle = SynthLookAndFeel.updateStyle(this.tabContentContext, this);
        this.contentBorderInsets = this.tabContentStyle.getInsets(this.tabContentContext, null);
    }

    protected void installListeners() {
        super.installListeners();
        this.tabPane.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removePropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.tabPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        this.tabStyle.uninstallDefaults(this.tabContext);
        this.tabContext.dispose();
        this.tabContext = null;
        this.tabStyle = null;
        this.tabAreaStyle.uninstallDefaults(this.tabAreaContext);
        this.tabAreaContext.dispose();
        this.tabAreaContext = null;
        this.tabAreaStyle = null;
        this.tabContentStyle.uninstallDefaults(this.tabContentContext);
        this.tabContentContext.dispose();
        this.tabContentContext = null;
        this.tabContentStyle = null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        SynthStyle synthStyle = null;
        Class<SynthContext> clazz = SynthContext.class;
        if (region == Region.TABBED_PANE_TAB) {
            synthStyle = this.tabStyle;
        } else if (region == Region.TABBED_PANE_TAB_AREA) {
            synthStyle = this.tabAreaStyle;
        } else if (region == Region.TABBED_PANE_CONTENT) {
            synthStyle = this.tabContentStyle;
        }
        return SynthContext.getContext(clazz, jComponent, region, synthStyle, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    protected JButton createScrollButton(int n2) {
        return new SynthScrollableTabButton(n2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle(this.tabPane);
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintTabbedPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintTabbedPaneBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        int n2 = this.tabPane.getSelectedIndex();
        int n3 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            Insets insets = this.tabPane.getInsets();
            int n4 = insets.left;
            int n5 = insets.top;
            int n6 = this.tabPane.getWidth() - insets.left - insets.right;
            int n7 = this.tabPane.getHeight() - insets.top - insets.bottom;
            switch (n3) {
                case 2: {
                    n6 = this.calculateTabAreaWidth(n3, this.runCount, this.maxTabWidth);
                    break;
                }
                case 4: {
                    int n8 = this.calculateTabAreaWidth(n3, this.runCount, this.maxTabWidth);
                    n4 = n4 + n6 - n8;
                    n6 = n8;
                    break;
                }
                case 3: {
                    int n9 = this.calculateTabAreaHeight(n3, this.runCount, this.maxTabHeight);
                    n5 = n5 + n7 - n9;
                    n7 = n9;
                    break;
                }
                default: {
                    n7 = this.calculateTabAreaHeight(n3, this.runCount, this.maxTabHeight);
                }
            }
            this.tabAreaBounds.setBounds(n4, n5, n6, n7);
            if (graphics.getClipBounds().intersects(this.tabAreaBounds)) {
                this.paintTabArea(this.tabAreaContext, graphics, n3, n2, this.tabAreaBounds);
            }
        }
        this.paintContentBorder(this.tabContentContext, graphics, n3, n2);
    }

    protected void paintTabArea(Graphics graphics, int n2, int n3) {
        Insets insets = this.tabPane.getInsets();
        int n4 = insets.left;
        int n5 = insets.top;
        int n6 = this.tabPane.getWidth() - insets.left - insets.right;
        int n7 = this.tabPane.getHeight() - insets.top - insets.bottom;
        this.paintTabArea(this.tabAreaContext, graphics, n2, n3, new Rectangle(n4, n5, n6, n7));
    }

    protected void paintTabArea(SynthContext synthContext, Graphics graphics, int n2, int n3, Rectangle rectangle) {
        Rectangle rectangle2 = graphics.getClipBounds();
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        synthContext.getPainter().paintTabbedPaneTabAreaBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        synthContext.getPainter().paintTabbedPaneTabAreaBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n4 = this.tabPane.getTabCount();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        for (int i2 = this.runCount - 1; i2 >= 0; --i2) {
            int n5 = this.tabRuns[i2];
            int n6 = this.tabRuns[i2 == this.runCount - 1 ? 0 : i2 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n4 - 1;
            for (int i3 = n5; i3 <= n7; ++i3) {
                if (!this.rects[i3].intersects(rectangle2) || n3 == i3) continue;
                this.paintTab(this.tabContext, graphics, n2, this.rects, i3, rectangle3, rectangle4);
            }
        }
        if (n3 >= 0 && this.rects[n3].intersects(rectangle2)) {
            this.paintTab(this.tabContext, graphics, n2, this.rects, n3, rectangle3, rectangle4);
        }
    }

    protected void paintTab(SynthContext synthContext, Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangleArray[n3];
        int n4 = this.tabPane.getSelectedIndex();
        boolean bl2 = n4 == n3;
        this.updateTabContext(n3, bl2, false, this.getFocusIndex() == n3);
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle3);
        this.tabContext.getPainter().paintTabbedPaneTabBackground(this.tabContext, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, n3);
        this.tabContext.getPainter().paintTabbedPaneTabBorder(this.tabContext, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, n3);
        String string = this.tabPane.getTitleAt(n3);
        Font font = synthContext.getStyle().getFont(synthContext);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.tabPane, graphics, font);
        Icon icon = this.getIconForTab(n3);
        this.layoutLabel(synthContext, n2, fontMetrics, n3, string, icon, rectangle3, rectangle, rectangle2, bl2);
        this.paintText(synthContext, graphics, n2, font, fontMetrics, n3, string, rectangle2, bl2);
        this.paintIcon(graphics, n2, n3, icon, rectangle, bl2);
    }

    protected void layoutLabel(SynthContext synthContext, int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl2) {
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        synthContext.getStyle().getGraphicsUtils(synthContext).layoutText(synthContext, fontMetrics, string, icon, 0, 0, 10, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int n4 = this.getTabLabelShiftX(n2, n3, bl2);
        int n5 = this.getTabLabelShiftY(n2, n3, bl2);
        rectangle2.x += n4;
        rectangle2.y += n5;
        rectangle3.x += n4;
        rectangle3.y += n5;
    }

    protected void paintText(SynthContext synthContext, Graphics graphics, int n2, Font font, FontMetrics fontMetrics, int n3, String string, Rectangle rectangle, boolean bl2) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n4 = this.tabPane.getDisplayedMnemonicIndexAt(n3);
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
            synthContext.getStyle().getGraphicsUtils(synthContext).paintText(synthContext, graphics, string, rectangle, n4);
        }
    }

    protected void paintContentBorder(SynthContext synthContext, Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getWidth();
        int n5 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = n4 - insets.right - insets.left;
        int n9 = n5 - insets.top - insets.bottom;
        switch (n2) {
            case 2: {
                n8 -= (n6 += this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n8 -= this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n9 -= this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n9 -= (n7 += this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        SynthLookAndFeel.updateSubregion(synthContext, graphics, new Rectangle(n6, n7, n8, n9));
        synthContext.getPainter().paintTabbedPaneContentBackground(synthContext, graphics, n6, n7, n8, n9);
        synthContext.getPainter().paintTabbedPaneContentBorder(synthContext, graphics, n6, n7, n8, n9);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    protected int calculateMaxTabHeight(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        int n5 = fontMetrics.getHeight();
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = Math.max(this.calculateTabHeight(n2, i2, n5), n4);
        }
        return n4;
    }

    protected int calculateTabWidth(int n2, int n3, FontMetrics fontMetrics) {
        View view;
        Icon icon = this.getIconForTab(n3);
        Insets insets = this.getTabInsets(n2, n3);
        int n4 = insets.left + insets.right + 3;
        if (icon != null) {
            n4 += icon.getIconWidth() + this.textIconGap;
        }
        if ((view = this.getTextViewForTab(n3)) != null) {
            n4 += (int)view.getPreferredSpan(0);
        } else {
            String string = this.tabPane.getTitleAt(n3);
            n4 += this.tabContext.getStyle().getGraphicsUtils(this.tabContext).computeStringWidth(this.tabContext, fontMetrics.getFont(), fontMetrics, string);
        }
        return n4;
    }

    protected int calculateMaxTabWidth(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = Math.max(this.calculateTabWidth(n2, i2, fontMetrics), n4);
        }
        return n4;
    }

    protected Insets getTabInsets(int n2, int n3) {
        this.updateTabContext(n3, false, false, this.getFocusIndex() == n3);
        return this.tabInsets;
    }

    protected FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
    }

    protected FontMetrics getFontMetrics(Font font) {
        return this.tabPane.getFontMetrics(font);
    }

    private void updateTabContext(int n2, boolean bl2, boolean bl3, boolean bl4) {
        int n3 = 0;
        if (!this.tabPane.isEnabledAt(n2)) {
            n3 |= 8;
        } else if (bl2) {
            n3 |= 0x201;
        } else if (bl3) {
            n3 |= 3;
        } else {
            n3 = SynthLookAndFeel.getComponentState(this.tabPane);
            n3 &= 0xFFFFFEFF;
        }
        if (bl4 && this.tabPane.hasFocus()) {
            n3 |= 0x100;
        }
        this.tabContext.setComponentState(n3);
    }

    private class SynthScrollableTabButton
    extends SynthArrowButton
    implements UIResource {
        public SynthScrollableTabButton(int n2) {
            super(n2);
        }
    }
}

