/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthBorder;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthListUI
extends BasicListUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private boolean useListColors;
    private boolean useUIBorder;

    SynthListUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthListUI();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintListBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        synthContext.dispose();
        this.paint(graphics, jComponent);
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintListBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    protected void installListeners() {
        super.installListeners();
        this.list.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JList)propertyChangeEvent.getSource());
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.list.removePropertyChangeListener(this);
    }

    protected void installDefaults() {
        if (this.list.getCellRenderer() == null || this.list.getCellRenderer() instanceof UIResource) {
            this.list.setCellRenderer(new SynthListCellRenderer());
        }
        this.updateStyle(this.list);
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(this.list, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Color color;
            synthContext.setComponentState(512);
            Color color2 = this.list.getSelectionBackground();
            if (color2 == null || color2 instanceof UIResource) {
                this.list.setSelectionBackground(this.style.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            if ((color = this.list.getSelectionForeground()) == null || color instanceof UIResource) {
                this.list.setSelectionForeground(this.style.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            this.useListColors = this.style.getBoolean(synthContext, "List.rendererUseListColors", true);
            this.useUIBorder = this.style.getBoolean(synthContext, "List.rendererUseUIBorder", true);
            int n2 = this.style.getInt(synthContext, "List.cellHeight", -1);
            if (n2 != -1) {
                this.list.setFixedCellHeight(n2);
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        SynthContext synthContext = this.getContext(this.list, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private class SynthListCellRenderer
    extends DefaultListCellRenderer.UIResource {
        private SynthListCellRenderer() {
        }

        public String getName() {
            return "List.cellRenderer";
        }

        public void setBorder(Border border) {
            if (SynthListUI.this.useUIBorder || border instanceof SynthBorder) {
                super.setBorder(border);
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            if (!SynthListUI.this.useListColors && (bl2 || bl3)) {
                SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), bl2, bl3, jList.isEnabled());
            } else {
                SynthLookAndFeel.resetSelectedUI();
            }
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            return this;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

