/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.View;
import sun.swing.UIAction;

public class BasicMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    Handler handler;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("doClick"));
        BasicLookAndFeel.installAudioActionMap(lazyActionMap);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuItemUI();
    }

    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        Object object = UIManager.get(this.getPropertyPrefix() + ".opaque");
        if (object != null) {
            LookAndFeel.installProperty(this.menuItem, "opaque", object);
        } else {
            LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.TRUE);
        }
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(string + ".margin"));
        }
        this.defaultTextIconGap = 4;
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        LookAndFeel.installProperty(this.menuItem, "borderPainted", UIManager.get(string + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(string + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(string + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(string + ".checkIcon");
        }
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        this.menuItem.addPropertyChangeListener(this.getHandler());
    }

    protected void installKeyboardActions() {
        this.installLazyActionMap();
        this.updateAcceleratorBinding();
    }

    void installLazyActionMap() {
        LazyActionMap.installLazyActionMap(this.menuItem, BasicMenuItemUI.class, this.getPropertyPrefix() + ".actionMap");
    }

    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent jComponent2 = (JComponent)container;
            jComponent2.putClientProperty(MAX_ACC_WIDTH, null);
            jComponent2.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        this.menuItem.removePropertyChangeListener(this.getHandler());
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return this.getHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return this.getHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return null;
    }

    Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    InputMap createInputMap(int n2) {
        if (n2 == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        InputMap inputMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (inputMap != null) {
            inputMap.clear();
        }
        if (keyStroke != null) {
            if (inputMap == null) {
                inputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, inputMap);
            }
            inputMap.put(keyStroke, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n2) {
        Serializable serializable;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n3;
            int n4 = keyStroke.getModifiers();
            if (n4 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n4);
                string2 = string2 + this.acceleratorDelimiter;
            }
            string2 = (n3 = keyStroke.getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n3) : string2 + keyStroke.getKeyChar();
        }
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : n2, n2);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(BasicMenuItemUI.iconRect.x, BasicMenuItemUI.iconRect.y, BasicMenuItemUI.iconRect.width, BasicMenuItemUI.iconRect.height, r);
        Container container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int n5;
            serializable = (JComponent)container;
            Integer n6 = (Integer)((JComponent)serializable).getClientProperty(MAX_TEXT_WIDTH);
            Integer n7 = (Integer)((JComponent)serializable).getClientProperty(MAX_ACC_WIDTH);
            int n8 = n6 != null ? n6 : 0;
            int n9 = n5 = n7 != null ? n7 : 0;
            if (BasicMenuItemUI.r.width < n8) {
                BasicMenuItemUI.r.width = n8;
            } else {
                ((JComponent)serializable).putClientProperty(MAX_TEXT_WIDTH, new Integer(BasicMenuItemUI.r.width));
            }
            if (BasicMenuItemUI.acceleratorRect.width > n5) {
                n5 = BasicMenuItemUI.acceleratorRect.width;
                ((JComponent)serializable).putClientProperty(MAX_ACC_WIDTH, new Integer(BasicMenuItemUI.acceleratorRect.width));
            }
            BasicMenuItemUI.r.width += n5;
            BasicMenuItemUI.r.width += n2;
        }
        if (this.useCheckAndArrow()) {
            BasicMenuItemUI.r.width += BasicMenuItemUI.checkIconRect.width;
            BasicMenuItemUI.r.width += n2;
            BasicMenuItemUI.r.width += n2;
            BasicMenuItemUI.r.width += BasicMenuItemUI.arrowIconRect.width;
        }
        BasicMenuItemUI.r.width += 2 * n2;
        serializable = jMenuItem.getInsets();
        if (serializable != null) {
            BasicMenuItemUI.r.width += ((Insets)serializable).left + ((Insets)serializable).right;
            BasicMenuItemUI.r.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if (BasicMenuItemUI.r.width % 2 == 0) {
            ++BasicMenuItemUI.r.width;
        }
        if (BasicMenuItemUI.r.height % 2 == 0) {
            ++BasicMenuItemUI.r.height;
        }
        return r.getSize();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n2) {
        Object object;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n3 = jMenuItem.getWidth();
        int n4 = jMenuItem.getHeight();
        Insets insets = jComponent.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, n3, n4);
        BasicMenuItemUI.viewRect.x += insets.left;
        BasicMenuItemUI.viewRect.y += insets.top;
        BasicMenuItemUI.viewRect.width -= insets.right + BasicMenuItemUI.viewRect.x;
        BasicMenuItemUI.viewRect.height -= insets.bottom + BasicMenuItemUI.viewRect.y;
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics, font2);
        FontMetrics fontMetrics2 = SwingUtilities2.getFontMetrics(jComponent, graphics, this.acceleratorFont);
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n5;
            int n6 = keyStroke.getModifiers();
            if (n6 > 0) {
                string = KeyEvent.getKeyModifiersText(n6);
                string = string + this.acceleratorDelimiter;
            }
            string = (n5 = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n5) : string + keyStroke.getKeyChar();
        }
        String string2 = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n2, n2);
        this.paintBackground(graphics, jMenuItem, color);
        Color color3 = graphics.getColor();
        if (icon != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color3);
            }
            if (this.useCheckAndArrow()) {
                icon.paintIcon(jComponent, graphics, BasicMenuItemUI.checkIconRect.x, BasicMenuItemUI.checkIconRect.y);
            }
            graphics.setColor(color3);
        }
        if (jMenuItem.getIcon() != null) {
            if (!buttonModel.isEnabled()) {
                object = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                object = jMenuItem.getPressedIcon();
                if (object == null) {
                    object = jMenuItem.getIcon();
                }
            } else {
                object = jMenuItem.getIcon();
            }
            if (object != null) {
                object.paintIcon(jComponent, graphics, BasicMenuItemUI.iconRect.x, BasicMenuItemUI.iconRect.y);
            }
        }
        if (string2 != null) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, textRect);
            } else {
                this.paintText(graphics, jMenuItem, textRect, string2);
            }
        }
        if (string != null && !string.equals("")) {
            int n7 = 0;
            Container container = this.menuItem.getParent();
            if (container != null && container instanceof JComponent) {
                JComponent jComponent2 = (JComponent)container;
                Integer n8 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
                int n9 = n8 != null ? n8 : BasicMenuItemUI.acceleratorRect.width;
                n7 = n9 - BasicMenuItemUI.acceleratorRect.width;
            }
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground != null) {
                    graphics.setColor(this.disabledForeground);
                    SwingUtilities2.drawString((JComponent)jMenuItem, graphics, string, BasicMenuItemUI.acceleratorRect.x - n7, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    SwingUtilities2.drawString((JComponent)jMenuItem, graphics, string, BasicMenuItemUI.acceleratorRect.x - n7, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    SwingUtilities2.drawString((JComponent)jMenuItem, graphics, string, BasicMenuItemUI.acceleratorRect.x - n7 - 1, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(this.acceleratorSelectionForeground);
                } else {
                    graphics.setColor(this.acceleratorForeground);
                }
                SwingUtilities2.drawString((JComponent)jMenuItem, graphics, string, BasicMenuItemUI.acceleratorRect.x - n7, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (this.useCheckAndArrow()) {
                icon2.paintIcon(jComponent, graphics, BasicMenuItemUI.arrowIconRect.x, BasicMenuItemUI.arrowIconRect.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n2 = jMenuItem.getWidth();
        int n3 = jMenuItem.getHeight();
        if (jMenuItem.isOpaque()) {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n2, n3);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n2, n3);
            }
            graphics.setColor(color2);
        } else if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n2, n3);
            graphics.setColor(color2);
        }
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jMenuItem, graphics);
        int n2 = jMenuItem.getDisplayedMnemonicIndex();
        if (!buttonModel.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(jMenuItem.getBackground().brighter());
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getBackground().darker());
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        } else {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    private String layoutMenuItem(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n6, int n7) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, string, icon, n2, n3, n4, n5, rectangle, rectangle2, rectangle3, n6);
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities2.stringWidth(this.menuItem, fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (icon2 != null) {
                rectangle5.width = icon2.getIconWidth();
                rectangle5.height = icon2.getIconHeight();
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        if (BasicGraphicsUtils.isLeftToRight(this.menuItem)) {
            rectangle3.x += n7;
            rectangle2.x += n7;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n7 - rectangle4.width;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + n7;
                rectangle3.x += n7 + rectangle5.width;
                rectangle2.x += n7 + rectangle5.width;
                rectangle6.x = rectangle.x + rectangle.width - n7 - rectangle6.width;
            }
        } else {
            rectangle3.x -= n7;
            rectangle2.x -= n7;
            rectangle4.x = rectangle.x + rectangle6.width + n7;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + rectangle.width - n7 - rectangle5.width;
                rectangle3.x -= n7 + rectangle5.width;
                rectangle2.x -= n7 + rectangle5.width;
                rectangle6.x = rectangle.x + n7;
            }
        }
        rectangle4.y = rectangle7.y + rectangle7.height / 2 - rectangle4.height / 2;
        if (this.useCheckAndArrow()) {
            rectangle6.y = rectangle7.y + rectangle7.height / 2 - rectangle6.height / 2;
            rectangle5.y = rectangle7.y + rectangle7.height / 2 - rectangle5.height / 2;
        }
        return string;
    }

    private boolean useCheckAndArrow() {
        boolean bl2 = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            bl2 = false;
        }
        return bl2;
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n2 = menuElementArray2.length;
        if (n2 == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n2 - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n2 + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2);
            menuElementArray[n2] = this.menuItem;
        } else {
            int n3;
            for (n3 = menuElementArray2.length - 1; n3 >= 0 && menuElementArray2[n3].getComponent() != container; --n3) {
            }
            menuElementArray = new MenuElement[n3 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n3 + 1);
            menuElementArray[n3 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    void printMenuElementArray(MenuElement[] menuElementArray, boolean bl2) {
        System.out.println("Path is(");
        int n2 = menuElementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 <= i2; ++i3) {
                System.out.print("  ");
            }
            MenuElement menuElement = menuElementArray[i2];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
                continue;
            }
            if (menuElement == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + menuElement + ", ");
        }
        System.out.println(")");
        if (bl2) {
            Thread.dumpStack();
        }
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        if (!this.isInternalFrameSystemMenu()) {
            BasicLookAndFeel.playSound(this.menuItem, this.getPropertyPrefix() + ".commandSound");
        }
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String string = this.menuItem.getActionCommand();
        return string == "Close" || string == "Minimize" || string == "Restore" || string == "Maximize";
    }

    private static class Actions
    extends UIAction {
        private static final String CLICK = "doClick";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    class Handler
    implements MenuDragMouseListener,
    MouseInputListener,
    PropertyChangeListener {
        Handler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n2 = mouseEvent.getModifiers();
            if ((n2 & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                menuSelectionManager.setSelectedPath(BasicMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n2 = mouseEvent.getModifiers();
            if ((n2 & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 1 && menuElementArray[menuElementArray.length - 1] == BasicMenuItemUI.this.menuItem) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                    int n3 = menuElementArray.length - 1;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        menuElementArray2[i2] = menuElementArray[i2];
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "labelFor" || string == "displayedMnemonic" || string == "accelerator") {
                BasicMenuItemUI.this.updateAcceleratorBinding();
            } else if (string == "text" || "font" == string || "foreground" == string) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseClicked(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseReleased(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseEntered(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseExited(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseMoved(mouseEvent);
        }
    }
}

