/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import javax.swing.AbstractSpinnerModel;

public class SpinnerNumberModel
extends AbstractSpinnerModel
implements Serializable {
    private Number stepSize;
    private Number value;
    private Comparable minimum;
    private Comparable maximum;

    public SpinnerNumberModel(Number number, Comparable comparable, Comparable comparable2, Number number2) {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("value and stepSize must be non-null");
        }
        if (comparable != null && comparable.compareTo(number) > 0 || comparable2 != null && comparable2.compareTo(number) < 0) {
            throw new IllegalArgumentException("(minimum <= value <= maximum) is false");
        }
        this.value = number;
        this.minimum = comparable;
        this.maximum = comparable2;
        this.stepSize = number2;
    }

    public SpinnerNumberModel(int n2, int n3, int n4, int n5) {
        this(new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5));
    }

    public SpinnerNumberModel(double d2, double d3, double d4, double d5) {
        this(new Double(d2), new Double(d3), new Double(d4), new Double(d5));
    }

    public SpinnerNumberModel() {
        this(new Integer(0), null, null, new Integer(1));
    }

    public void setMinimum(Comparable comparable) {
        if (comparable == null ? this.minimum != null : !comparable.equals(this.minimum)) {
            this.minimum = comparable;
            this.fireStateChanged();
        }
    }

    public Comparable getMinimum() {
        return this.minimum;
    }

    public void setMaximum(Comparable comparable) {
        if (comparable == null ? this.maximum != null : !comparable.equals(this.maximum)) {
            this.maximum = comparable;
            this.fireStateChanged();
        }
    }

    public Comparable getMaximum() {
        return this.maximum;
    }

    public void setStepSize(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("null stepSize");
        }
        if (!number.equals(this.stepSize)) {
            this.stepSize = number;
            this.fireStateChanged();
        }
    }

    public Number getStepSize() {
        return this.stepSize;
    }

    private Number incrValue(int n2) {
        Number number;
        if (this.value instanceof Float || this.value instanceof Double) {
            double d2 = this.value.doubleValue() + this.stepSize.doubleValue() * (double)n2;
            number = this.value instanceof Double ? (Number)new Double(d2) : (Number)new Float(d2);
        } else {
            long l2 = this.value.longValue() + this.stepSize.longValue() * (long)n2;
            number = this.value instanceof Long ? (Number)new Long(l2) : (Number)(this.value instanceof Integer ? (Number)new Integer((int)l2) : (Number)(this.value instanceof Short ? (Number)new Short((short)l2) : (Number)new Byte((byte)l2)));
        }
        if (this.maximum != null && this.maximum.compareTo(number) < 0) {
            return null;
        }
        if (this.minimum != null && this.minimum.compareTo(number) > 0) {
            return null;
        }
        return number;
    }

    public Object getNextValue() {
        return this.incrValue(1);
    }

    public Object getPreviousValue() {
        return this.incrValue(-1);
    }

    public Number getNumber() {
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (object == null || !(object instanceof Number)) {
            throw new IllegalArgumentException("illegal value");
        }
        if (!object.equals(this.value)) {
            this.value = (Number)object;
            this.fireStateChanged();
        }
    }
}

