/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

public class BorderFactory {
    static final Border sharedRaisedBevel = new BevelBorder(0);
    static final Border sharedLoweredBevel = new BevelBorder(1);
    static final Border sharedEtchedBorder = new EtchedBorder();
    private static Border sharedRaisedEtchedBorder;
    static final Border emptyBorder;

    private BorderFactory() {
    }

    public static Border createLineBorder(Color color) {
        return new LineBorder(color, 1);
    }

    public static Border createLineBorder(Color color, int n2) {
        return new LineBorder(color, n2);
    }

    public static Border createRaisedBevelBorder() {
        return BorderFactory.createSharedBevel(0);
    }

    public static Border createLoweredBevelBorder() {
        return BorderFactory.createSharedBevel(1);
    }

    public static Border createBevelBorder(int n2) {
        return BorderFactory.createSharedBevel(n2);
    }

    public static Border createBevelBorder(int n2, Color color, Color color2) {
        return new BevelBorder(n2, color, color2);
    }

    public static Border createBevelBorder(int n2, Color color, Color color2, Color color3, Color color4) {
        return new BevelBorder(n2, color, color2, color3, color4);
    }

    static Border createSharedBevel(int n2) {
        if (n2 == 0) {
            return sharedRaisedBevel;
        }
        if (n2 == 1) {
            return sharedLoweredBevel;
        }
        return null;
    }

    public static Border createEtchedBorder() {
        return sharedEtchedBorder;
    }

    public static Border createEtchedBorder(Color color, Color color2) {
        return new EtchedBorder(color, color2);
    }

    public static Border createEtchedBorder(int n2) {
        switch (n2) {
            case 0: {
                if (sharedRaisedEtchedBorder == null) {
                    sharedRaisedEtchedBorder = new EtchedBorder(0);
                }
                return sharedRaisedEtchedBorder;
            }
            case 1: {
                return sharedEtchedBorder;
            }
        }
        throw new IllegalArgumentException("type must be one of EtchedBorder.RAISED or EtchedBorder.LOWERED");
    }

    public static Border createEtchedBorder(int n2, Color color, Color color2) {
        return new EtchedBorder(n2, color, color2);
    }

    public static TitledBorder createTitledBorder(String string) {
        return new TitledBorder(string);
    }

    public static TitledBorder createTitledBorder(Border border) {
        return new TitledBorder(border);
    }

    public static TitledBorder createTitledBorder(Border border, String string) {
        return new TitledBorder(border, string);
    }

    public static TitledBorder createTitledBorder(Border border, String string, int n2, int n3) {
        return new TitledBorder(border, string, n2, n3);
    }

    public static TitledBorder createTitledBorder(Border border, String string, int n2, int n3, Font font) {
        return new TitledBorder(border, string, n2, n3, font);
    }

    public static TitledBorder createTitledBorder(Border border, String string, int n2, int n3, Font font, Color color) {
        return new TitledBorder(border, string, n2, n3, font, color);
    }

    public static Border createEmptyBorder() {
        return emptyBorder;
    }

    public static Border createEmptyBorder(int n2, int n3, int n4, int n5) {
        return new EmptyBorder(n2, n3, n4, n5);
    }

    public static CompoundBorder createCompoundBorder() {
        return new CompoundBorder();
    }

    public static CompoundBorder createCompoundBorder(Border border, Border border2) {
        return new CompoundBorder(border, border2);
    }

    public static MatteBorder createMatteBorder(int n2, int n3, int n4, int n5, Color color) {
        return new MatteBorder(n2, n3, n4, n5, color);
    }

    public static MatteBorder createMatteBorder(int n2, int n3, int n4, int n5, Icon icon) {
        return new MatteBorder(n2, n3, n4, n5, icon);
    }

    static {
        emptyBorder = new EmptyBorder(0, 0, 0, 0);
    }
}

