/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import javax.security.auth.kerberos.KrbServicePermissionCollection;

public final class ServicePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -1227585031618624935L;
    private static final int INITIATE = 1;
    private static final int ACCEPT = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private String actions;

    public ServicePermission(String string, String string2) {
        super(string);
        this.init(string, ServicePermission.getMask(string2));
    }

    private void init(String string, int n2) {
        if (string == null) {
            throw new NullPointerException("service principal can't be null");
        }
        if ((n2 & 3) != n2) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.mask = n2;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        return (this.mask & servicePermission.mask) == servicePermission.mask && this.impliesIgnoreMask(servicePermission);
    }

    boolean impliesIgnoreMask(ServicePermission servicePermission) {
        return this.getName().equals("*") || this.getName().equals(servicePermission.getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)object;
        return (this.mask & servicePermission.mask) == servicePermission.mask && this.getName().equals(servicePermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.mask;
    }

    private static String getActions(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        if ((n2 & 1) == 1) {
            if (bl2) {
                stringBuilder.append(',');
            } else {
                bl2 = true;
            }
            stringBuilder.append("initiate");
        }
        if ((n2 & 2) == 2) {
            if (bl2) {
                stringBuilder.append(',');
            } else {
                bl2 = true;
            }
            stringBuilder.append("accept");
        }
        return stringBuilder.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = ServicePermission.getActions(this.mask);
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new KrbServicePermissionCollection();
    }

    int getMask() {
        return this.mask;
    }

    private static int getMask(String string) {
        if (string == null) {
            throw new NullPointerException("action can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("action can't be empty");
        }
        int n2 = 0;
        if (string == null) {
            return n2;
        }
        char[] cArray = string.toCharArray();
        int n3 = cArray.length - 1;
        if (n3 < 0) {
            return n2;
        }
        while (n3 != -1) {
            int n4;
            char c2;
            while (n3 != -1 && ((c2 = cArray[n3]) == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\t')) {
                --n3;
            }
            if (!(n3 < 7 || cArray[n3 - 7] != 'i' && cArray[n3 - 7] != 'I' || cArray[n3 - 6] != 'n' && cArray[n3 - 6] != 'N' || cArray[n3 - 5] != 'i' && cArray[n3 - 5] != 'I' || cArray[n3 - 4] != 't' && cArray[n3 - 4] != 'T' || cArray[n3 - 3] != 'i' && cArray[n3 - 3] != 'I' || cArray[n3 - 2] != 'a' && cArray[n3 - 2] != 'A' || cArray[n3 - 1] != 't' && cArray[n3 - 1] != 'T' || cArray[n3] != 'e' && cArray[n3] != 'E')) {
                n4 = 8;
                n2 |= 1;
            } else if (!(n3 < 5 || cArray[n3 - 5] != 'a' && cArray[n3 - 5] != 'A' || cArray[n3 - 4] != 'c' && cArray[n3 - 4] != 'C' || cArray[n3 - 3] != 'c' && cArray[n3 - 3] != 'C' || cArray[n3 - 2] != 'e' && cArray[n3 - 2] != 'E' || cArray[n3 - 1] != 'p' && cArray[n3 - 1] != 'P' || cArray[n3] != 't' && cArray[n3] != 'T')) {
                n4 = 6;
                n2 |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            boolean bl2 = false;
            while (n3 >= n4 && !bl2) {
                switch (cArray[n3 - n4]) {
                    case ',': {
                        bl2 = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n3;
            }
            n3 -= n4;
        }
        return n2;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), ServicePermission.getMask(this.actions));
    }
}

