/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.print.DocFlavor;
import javax.print.StreamPrintService;
import sun.awt.AppContext;
import sun.misc.Service;

public abstract class StreamPrintServiceFactory {
    private static Services getServices() {
        Services services = (Services)AppContext.getAppContext().get(Services.class);
        if (services == null) {
            services = new Services();
            AppContext.getAppContext().put(Services.class, services);
        }
        return services;
    }

    private static ArrayList getListOfFactories() {
        return StreamPrintServiceFactory.getServices().listOfFactories;
    }

    private static ArrayList initListOfFactories() {
        ArrayList arrayList = new ArrayList();
        StreamPrintServiceFactory.getServices().listOfFactories = arrayList;
        return arrayList;
    }

    public static StreamPrintServiceFactory[] lookupStreamPrintServiceFactories(DocFlavor docFlavor, String string) {
        ArrayList arrayList = StreamPrintServiceFactory.getFactories(docFlavor, string);
        return arrayList.toArray(new StreamPrintServiceFactory[arrayList.size()]);
    }

    public abstract String getOutputFormat();

    public abstract DocFlavor[] getSupportedDocFlavors();

    public abstract StreamPrintService getPrintService(OutputStream var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getAllFactories() {
        Class<StreamPrintServiceFactory> clazz = StreamPrintServiceFactory.class;
        synchronized (StreamPrintServiceFactory.class) {
            ArrayList arrayList = StreamPrintServiceFactory.getListOfFactories();
            if (arrayList != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return arrayList;
            }
            arrayList = StreamPrintServiceFactory.initListOfFactories();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        Iterator iterator = Service.providers(StreamPrintServiceFactory.class);
                        ArrayList arrayList = StreamPrintServiceFactory.getListOfFactories();
                        while (iterator.hasNext()) {
                            try {
                                StreamPrintServiceFactory streamPrintServiceFactory = (StreamPrintServiceFactory)iterator.next();
                                arrayList.add(streamPrintServiceFactory);
                            }
                            catch (Exception exception) {}
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            return arrayList;
        }
    }

    private static boolean isMember(DocFlavor docFlavor, DocFlavor[] docFlavorArray) {
        for (int i2 = 0; i2 < docFlavorArray.length; ++i2) {
            if (!docFlavor.equals(docFlavorArray[i2])) continue;
            return true;
        }
        return false;
    }

    private static ArrayList getFactories(DocFlavor docFlavor, String string) {
        if (docFlavor == null && string == null) {
            return StreamPrintServiceFactory.getAllFactories();
        }
        ArrayList<StreamPrintServiceFactory> arrayList = new ArrayList<StreamPrintServiceFactory>();
        for (StreamPrintServiceFactory streamPrintServiceFactory : StreamPrintServiceFactory.getAllFactories()) {
            if (string != null && !string.equalsIgnoreCase(streamPrintServiceFactory.getOutputFormat()) || docFlavor != null && !StreamPrintServiceFactory.isMember(docFlavor, streamPrintServiceFactory.getSupportedDocFlavors())) continue;
            arrayList.add(streamPrintServiceFactory);
        }
        return arrayList;
    }

    static class Services {
        private ArrayList listOfFactories = null;

        Services() {
        }
    }
}

