/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundName
implements Name {
    protected transient NameImpl impl;
    protected transient Properties mySyntax;
    private static final long serialVersionUID = 3513100557083972036L;

    protected CompoundName(Enumeration<String> enumeration, Properties properties) {
        if (properties == null) {
            throw new NullPointerException();
        }
        this.mySyntax = properties;
        this.impl = new NameImpl(properties, enumeration);
    }

    public CompoundName(String string, Properties properties) throws InvalidNameException {
        if (properties == null) {
            throw new NullPointerException();
        }
        this.mySyntax = properties;
        this.impl = new NameImpl(properties, string);
    }

    public String toString() {
        return this.impl.toString();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof CompoundName && this.impl.equals(((CompoundName)object).impl);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    @Override
    public Object clone() {
        return new CompoundName(this.getAll(), this.mySyntax);
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof CompoundName)) {
            throw new ClassCastException("Not a CompoundName");
        }
        return this.impl.compareTo(((CompoundName)object).impl);
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public Enumeration<String> getAll() {
        return this.impl.getAll();
    }

    @Override
    public String get(int n2) {
        return this.impl.get(n2);
    }

    @Override
    public Name getPrefix(int n2) {
        Enumeration enumeration = this.impl.getPrefix(n2);
        return new CompoundName(enumeration, this.mySyntax);
    }

    @Override
    public Name getSuffix(int n2) {
        Enumeration enumeration = this.impl.getSuffix(n2);
        return new CompoundName(enumeration, this.mySyntax);
    }

    @Override
    public boolean startsWith(Name name) {
        if (name instanceof CompoundName) {
            return this.impl.startsWith(name.size(), name.getAll());
        }
        return false;
    }

    @Override
    public boolean endsWith(Name name) {
        if (name instanceof CompoundName) {
            return this.impl.endsWith(name.size(), name.getAll());
        }
        return false;
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        if (name instanceof CompoundName) {
            this.impl.addAll(name.getAll());
            return this;
        }
        throw new InvalidNameException("Not a compound name: " + name.toString());
    }

    @Override
    public Name addAll(int n2, Name name) throws InvalidNameException {
        if (name instanceof CompoundName) {
            this.impl.addAll(n2, name.getAll());
            return this;
        }
        throw new InvalidNameException("Not a compound name: " + name.toString());
    }

    @Override
    public Name add(String string) throws InvalidNameException {
        this.impl.add(string);
        return this;
    }

    @Override
    public Name add(int n2, String string) throws InvalidNameException {
        this.impl.add(n2, string);
        return this;
    }

    @Override
    public Object remove(int n2) throws InvalidNameException {
        return this.impl.remove(n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.mySyntax);
        objectOutputStream.writeInt(this.size());
        Enumeration<String> enumeration = this.getAll();
        while (enumeration.hasMoreElements()) {
            objectOutputStream.writeObject(enumeration.nextElement());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mySyntax = (Properties)objectInputStream.readObject();
        this.impl = new NameImpl(this.mySyntax);
        int n2 = objectInputStream.readInt();
        try {
            while (--n2 >= 0) {
                this.add((String)objectInputStream.readObject());
            }
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name");
        }
    }
}

