/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import javax.management.loading.MLet;

class MLetObjectInputStream
extends ObjectInputStream {
    private MLet loader;

    public MLetObjectInputStream(InputStream inputStream, MLet mLet) throws IOException, StreamCorruptedException {
        super(inputStream);
        if (mLet == null) {
            throw new IllegalArgumentException("Illegal null argument to MLetObjectInputStream");
        }
        this.loader = mLet;
    }

    private Class primitiveType(char c2) {
        switch (c2) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (string.startsWith("[")) {
            Class<?> clazz;
            int n2 = 1;
            while (string.charAt(n2) == '[') {
                ++n2;
            }
            if (string.charAt(n2) == 'L') {
                clazz = this.loader.loadClass(string.substring(n2 + 1, string.length() - 1));
            } else {
                if (string.length() != n2 + 1) {
                    throw new ClassNotFoundException(string);
                }
                clazz = this.primitiveType(string.charAt(n2));
            }
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = 0;
            }
            return Array.newInstance(clazz, nArray).getClass();
        }
        return this.loader.loadClass(string);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

