/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BetweenQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -2933597532866307444L;
    private ValueExp exp1;
    private ValueExp exp2;
    private ValueExp exp3;

    public BetweenQueryExp() {
    }

    public BetweenQueryExp(ValueExp valueExp, ValueExp valueExp2, ValueExp valueExp3) {
        this.exp1 = valueExp;
        this.exp2 = valueExp2;
        this.exp3 = valueExp3;
    }

    public ValueExp getCheckedValue() {
        return this.exp1;
    }

    public ValueExp getLowerBound() {
        return this.exp2;
    }

    public ValueExp getUpperBound() {
        return this.exp3;
    }

    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp valueExp = this.exp1.apply(objectName);
        ValueExp valueExp2 = this.exp2.apply(objectName);
        ValueExp valueExp3 = this.exp3.apply(objectName);
        boolean bl2 = valueExp instanceof NumericValueExp;
        if (bl2) {
            if (((NumericValueExp)valueExp).isLong()) {
                long l2 = ((NumericValueExp)valueExp).longValue();
                long l3 = ((NumericValueExp)valueExp2).longValue();
                long l4 = ((NumericValueExp)valueExp3).longValue();
                return l3 <= l2 && l2 <= l4;
            }
            double d2 = ((NumericValueExp)valueExp).doubleValue();
            double d3 = ((NumericValueExp)valueExp2).doubleValue();
            double d4 = ((NumericValueExp)valueExp3).doubleValue();
            return d3 <= d2 && d2 <= d4;
        }
        String string = ((StringValueExp)valueExp).toString();
        String string2 = ((StringValueExp)valueExp2).toString();
        String string3 = ((StringValueExp)valueExp3).toString();
        return string2.compareTo(string) <= 0 && string.compareTo(string3) <= 0;
    }

    public String toString() {
        return "(" + this.exp1 + ") between (" + this.exp2 + ") and (" + this.exp3 + ")";
    }
}

