/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicBoolean
implements Serializable {
    private static final long serialVersionUID = 4654671469794556979L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    private volatile int value;

    public AtomicBoolean(boolean bl2) {
        this.value = bl2 ? 1 : 0;
    }

    public AtomicBoolean() {
    }

    public final boolean get() {
        return this.value != 0;
    }

    public final boolean compareAndSet(boolean bl2, boolean bl3) {
        int n2 = bl2 ? 1 : 0;
        int n3 = bl3 ? 1 : 0;
        return unsafe.compareAndSwapInt(this, valueOffset, n2, n3);
    }

    public boolean weakCompareAndSet(boolean bl2, boolean bl3) {
        int n2 = bl2 ? 1 : 0;
        int n3 = bl3 ? 1 : 0;
        return unsafe.compareAndSwapInt(this, valueOffset, n2, n3);
    }

    public final void set(boolean bl2) {
        this.value = bl2 ? 1 : 0;
    }

    public final boolean getAndSet(boolean bl2) {
        boolean bl3;
        while (!this.compareAndSet(bl3 = this.get(), bl2)) {
        }
        return bl3;
    }

    public String toString() {
        return Boolean.toString(this.get());
    }

    static {
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicBoolean.class.getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

