/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.security.AccessController;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final Runnable[] EMPTY_RUNNABLE_ARRAY = new Runnable[0];
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final HashSet<Worker> workers = new HashSet();
    private volatile long keepAliveTime;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();

    void reject(Runnable runnable) {
        this.handler.rejectedExecution(runnable, this);
    }

    private Thread addThread(Runnable runnable) {
        Worker worker = new Worker(runnable);
        Thread thread = this.threadFactory.newThread(worker);
        if (thread != null) {
            worker.thread = thread;
            this.workers.add(worker);
            int n2 = ++this.poolSize;
            if (n2 > this.largestPoolSize) {
                this.largestPoolSize = n2;
            }
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfUnderCorePoolSize(Runnable runnable) {
        Thread thread = null;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            if (this.poolSize < this.corePoolSize) {
                thread = this.addThread(runnable);
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (thread == null) {
            return false;
        }
        thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable addIfUnderMaximumPoolSize(Runnable runnable) {
        Thread thread = null;
        Runnable runnable2 = null;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            if (this.poolSize < this.maximumPoolSize) {
                runnable2 = (Runnable)this.workQueue.poll();
                if (runnable2 == null) {
                    runnable2 = runnable;
                }
                thread = this.addThread(runnable2);
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (thread == null) {
            return null;
        }
        thread.start();
        return runnable2;
    }

    Runnable getTask() throws InterruptedException {
        block7: while (true) {
            switch (this.runState) {
                case 0: {
                    if (this.poolSize <= this.corePoolSize) {
                        return this.workQueue.take();
                    }
                    long l2 = this.keepAliveTime;
                    if (l2 <= 0L) {
                        return null;
                    }
                    Runnable runnable = this.workQueue.poll(l2, TimeUnit.NANOSECONDS);
                    if (runnable != null) {
                        return runnable;
                    }
                    if (this.poolSize <= this.corePoolSize) continue block7;
                    return null;
                }
                case 1: {
                    Runnable runnable = (Runnable)this.workQueue.poll();
                    if (runnable != null) {
                        return runnable;
                    }
                    if (this.workQueue.isEmpty()) {
                        this.interruptIdleWorkers();
                        return null;
                    }
                    try {
                        return this.workQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        continue block7;
                    }
                }
                case 2: {
                    return null;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIdleWorkers() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            for (Worker worker : this.workers) {
                worker.interruptIfIdle();
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerDone(Worker worker) {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.completedTaskCount += worker.completedTasks;
            this.workers.remove(worker);
            if (--this.poolSize > 0) {
                return;
            }
            int n2 = this.runState;
            assert (n2 != 3);
            if (n2 != 2) {
                if (!this.workQueue.isEmpty()) {
                    Thread thread = this.addThread(null);
                    if (thread != null) {
                        thread.start();
                    }
                    return;
                }
                if (n2 == 0) {
                    return;
                }
            }
            this.termination.signalAll();
            this.runState = 3;
        }
        finally {
            reentrantLock.unlock();
        }
        assert (this.runState == 3);
        this.terminated();
    }

    public ThreadPoolExecutor(int n2, int n3, long l2, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        this(n2, n3, l2, timeUnit, blockingQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int n2, int n3, long l2, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        this(n2, n3, l2, timeUnit, blockingQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int n2, int n3, long l2, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        this(n2, n3, l2, timeUnit, blockingQueue, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public ThreadPoolExecutor(int n2, int n3, long l2, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (n2 < 0 || n3 <= 0 || n3 < n2 || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (blockingQueue == null || threadFactory == null || rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = n2;
        this.maximumPoolSize = n3;
        this.workQueue = blockingQueue;
        this.keepAliveTime = timeUnit.toNanos(l2);
        this.threadFactory = threadFactory;
        this.handler = rejectedExecutionHandler;
    }

    @Override
    public void execute(Runnable runnable) {
        Runnable runnable2;
        if (runnable == null) {
            throw new NullPointerException();
        }
        do {
            if (this.runState != 0) {
                this.reject(runnable);
                return;
            }
            if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(runnable)) {
                return;
            }
            if (this.workQueue.offer(runnable)) {
                return;
            }
            runnable2 = this.addIfUnderMaximumPoolSize(runnable);
            if (runnable2 != runnable) continue;
            return;
        } while (runnable2 != null);
        this.reject(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        boolean bl2;
        block12: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                AccessController.checkPermission(shutdownPerm);
            }
            bl2 = false;
            ReentrantLock reentrantLock = this.mainLock;
            reentrantLock.lock();
            try {
                if (this.workers.size() > 0) {
                    int n2;
                    if (securityManager != null) {
                        for (Worker object : this.workers) {
                            securityManager.checkAccess(object.thread);
                        }
                    }
                    if ((n2 = this.runState) == 0) {
                        this.runState = 1;
                    }
                    try {
                        for (Worker worker : this.workers) {
                            worker.interruptIfIdle();
                        }
                        break block12;
                    }
                    catch (SecurityException securityException) {
                        this.runState = n2;
                        throw securityException;
                    }
                }
                bl2 = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            finally {
                reentrantLock.unlock();
            }
        }
        if (bl2) {
            this.terminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        boolean bl2;
        block12: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                AccessController.checkPermission(shutdownPerm);
            }
            bl2 = false;
            ReentrantLock reentrantLock = this.mainLock;
            reentrantLock.lock();
            try {
                if (this.workers.size() > 0) {
                    int n2;
                    if (securityManager != null) {
                        for (Worker object : this.workers) {
                            securityManager.checkAccess(object.thread);
                        }
                    }
                    if ((n2 = this.runState) != 3) {
                        this.runState = 2;
                    }
                    try {
                        for (Worker worker : this.workers) {
                            worker.interruptNow();
                        }
                        break block12;
                    }
                    catch (SecurityException securityException) {
                        this.runState = n2;
                        throw securityException;
                    }
                }
                bl2 = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            finally {
                reentrantLock.unlock();
            }
        }
        if (bl2) {
            this.terminated();
        }
        return Arrays.asList(this.workQueue.toArray(EMPTY_RUNNABLE_ARRAY));
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    public boolean isTerminating() {
        return this.runState == 2;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            while (true) {
                if (this.runState == 3) {
                    boolean bl2 = true;
                    return bl2;
                }
                if (l3 <= 0L) {
                    boolean bl3 = false;
                    return bl3;
                }
                l3 = this.termination.awaitNanos(l3);
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        if (rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.handler = rejectedExecutionHandler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable runnable) {
        return this.getQueue().remove(runnable);
    }

    public void purge() {
        try {
            Iterator iterator = this.getQueue().iterator();
            while (iterator.hasNext()) {
                Future future;
                Runnable runnable = (Runnable)iterator.next();
                if (!(runnable instanceof Future) || !(future = (Future)((Object)runnable)).isCancelled()) continue;
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n3 = this.corePoolSize - n2;
            this.corePoolSize = n2;
            if (n3 < 0) {
                Thread thread;
                int n4 = this.workQueue.size();
                while (n3++ < 0 && n4-- > 0 && this.poolSize < n2 && (thread = this.addThread(null)) != null) {
                    thread.start();
                }
            } else if (n3 > 0 && this.poolSize > n2) {
                Iterator<Worker> iterator = this.workers.iterator();
                while (iterator.hasNext() && n3-- > 0 && this.poolSize > n2 && this.workQueue.remainingCapacity() == 0) {
                    iterator.next().interruptIfIdle();
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    public int prestartAllCoreThreads() {
        int n2 = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int n2) {
        if (n2 <= 0 || n2 < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n3;
            this.maximumPoolSize = n2;
            if (n3 > 0 && this.poolSize > n2) {
                Iterator<Worker> iterator = this.workers.iterator();
                for (n3 = this.maximumPoolSize - n2; iterator.hasNext() && n3 > 0 && this.poolSize > n2; --n3) {
                    iterator.next().interruptIfIdle();
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long l2, TimeUnit timeUnit) {
        if (l2 < 0L) {
            throw new IllegalArgumentException();
        }
        this.keepAliveTime = timeUnit.toNanos(l2);
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n2 = 0;
            for (Worker worker : this.workers) {
                if (!worker.isActive()) continue;
                ++n2;
            }
            int n3 = n2;
            return n3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLargestPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n2 = this.largestPoolSize;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l2 = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l2 += worker.completedTasks;
                if (!worker.isActive()) continue;
                ++l2;
            }
            long l3 = l2 + (long)this.workQueue.size();
            return l3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l2 = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l2 += worker.completedTasks;
            }
            long l3 = l2;
            return l3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
    }

    protected void afterExecute(Runnable runnable, Throwable throwable) {
    }

    protected void terminated() {
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            throw new RejectedExecutionException();
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                runnable.run();
            }
        }
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                threadPoolExecutor.getQueue().poll();
                threadPoolExecutor.execute(runnable);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    private class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        private Runnable firstTask;
        volatile long completedTasks;
        Thread thread;

        Worker(Runnable runnable) {
            this.firstTask = runnable;
        }

        boolean isActive() {
            return this.runLock.isLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptIfIdle() {
            ReentrantLock reentrantLock = this.runLock;
            if (reentrantLock.tryLock()) {
                try {
                    this.thread.interrupt();
                }
                finally {
                    reentrantLock.unlock();
                }
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask(Runnable runnable) {
            ReentrantLock reentrantLock = this.runLock;
            reentrantLock.lock();
            try {
                if (ThreadPoolExecutor.this.runState == 2) {
                    return;
                }
                Thread.interrupted();
                boolean bl2 = false;
                ThreadPoolExecutor.this.beforeExecute(this.thread, runnable);
                try {
                    runnable.run();
                    bl2 = true;
                    ThreadPoolExecutor.this.afterExecute(runnable, null);
                    ++this.completedTasks;
                }
                catch (RuntimeException runtimeException) {
                    if (!bl2) {
                        ThreadPoolExecutor.this.afterExecute(runnable, runtimeException);
                    }
                    throw runtimeException;
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runnable runnable = this.firstTask;
                this.firstTask = null;
                while (runnable != null || (runnable = ThreadPoolExecutor.this.getTask()) != null) {
                    this.runTask(runnable);
                    runnable = null;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                ThreadPoolExecutor.this.workerDone(this);
            }
        }
    }
}

