/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Sync sync;

    public Semaphore(int n2) {
        this.sync = new NonfairSync(n2);
    }

    public Semaphore(int n2, boolean bl2) {
        this.sync = bl2 ? new FairSync(n2) : new NonfairSync(n2);
    }

    public void acquire() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public void acquireUninterruptibly() {
        this.sync.acquireShared(1);
    }

    public boolean tryAcquire() {
        return this.sync.nonfairTryAcquireShared(1) >= 0;
    }

    public boolean tryAcquire(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(l2));
    }

    public void release() {
        this.sync.releaseShared(1);
    }

    public void acquire(int n2) throws InterruptedException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireSharedInterruptibly(n2);
    }

    public void acquireUninterruptibly(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireShared(n2);
    }

    public boolean tryAcquire(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return this.sync.nonfairTryAcquireShared(n2) >= 0;
    }

    public boolean tryAcquire(int n2, long l2, TimeUnit timeUnit) throws InterruptedException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return this.sync.tryAcquireSharedNanos(n2, timeUnit.toNanos(l2));
    }

    public void release(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.releaseShared(n2);
    }

    public int availablePermits() {
        return this.sync.getPermits();
    }

    public int drainPermits() {
        return this.sync.drainPermits();
    }

    protected void reducePermits(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.reducePermits(n2);
    }

    public boolean isFair() {
        return this.sync instanceof FairSync;
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.sync.getPermits() + "]";
    }

    static final class FairSync
    extends Sync {
        FairSync(int n2) {
            super(n2);
        }

        protected int tryAcquireShared(int n2) {
            int n3;
            int n4;
            Thread thread = Thread.currentThread();
            do {
                Thread thread2;
                if ((thread2 = this.getFirstQueuedThread()) == null || thread2 == thread) continue;
                return -1;
            } while ((n4 = (n3 = this.getState()) - n2) >= 0 && !this.compareAndSetState(n3, n4));
            return n4;
        }
    }

    static final class NonfairSync
    extends Sync {
        NonfairSync(int n2) {
            super(n2);
        }

        protected int tryAcquireShared(int n2) {
            return this.nonfairTryAcquireShared(n2);
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        Sync(int n2) {
            this.setState(n2);
        }

        final int getPermits() {
            return this.getState();
        }

        final int nonfairTryAcquireShared(int n2) {
            int n3;
            int n4;
            while ((n4 = (n3 = this.getState()) - n2) >= 0 && !this.compareAndSetState(n3, n4)) {
            }
            return n4;
        }

        protected final boolean tryReleaseShared(int n2) {
            int n3;
            while (!this.compareAndSetState(n3 = this.getState(), n3 + n2)) {
            }
            return true;
        }

        final void reducePermits(int n2) {
            int n3;
            int n4;
            while (!this.compareAndSetState(n4 = this.getState(), n3 = n4 - n2)) {
            }
        }

        final int drainPermits() {
            int n2;
            while ((n2 = this.getState()) != 0 && !this.compareAndSetState(n2, 0)) {
            }
            return n2;
        }
    }
}

