/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exchanger<V> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition taken = this.lock.newCondition();
    private V item;
    private int arrivalCount;

    private V doExchange(V v2, boolean bl2, long l2) throws InterruptedException, TimeoutException {
        this.lock.lock();
        try {
            int n2;
            while (this.arrivalCount == 2) {
                if (!bl2) {
                    this.taken.await();
                    continue;
                }
                if (l2 > 0L) {
                    l2 = this.taken.awaitNanos(l2);
                    continue;
                }
                throw new TimeoutException();
            }
            if ((n2 = ++this.arrivalCount) == 2) {
                V v3 = this.item;
                this.item = v2;
                this.taken.signal();
                V v4 = v3;
                return v4;
            }
            this.item = v2;
            InterruptedException interruptedException = null;
            try {
                while (this.arrivalCount != 2) {
                    if (!bl2) {
                        this.taken.await();
                        continue;
                    }
                    if (l2 > 0L) {
                        l2 = this.taken.awaitNanos(l2);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException2) {
                interruptedException = interruptedException2;
            }
            V v5 = this.item;
            this.item = null;
            n2 = this.arrivalCount;
            this.arrivalCount = 0;
            this.taken.signal();
            if (n2 == 2) {
                if (interruptedException != null) {
                    Thread.currentThread().interrupt();
                }
                V v6 = v5;
                return v6;
            }
            if (interruptedException != null) {
                throw interruptedException;
            }
            throw new TimeoutException();
        }
        finally {
            this.lock.unlock();
        }
    }

    public V exchange(V v2) throws InterruptedException {
        try {
            return this.doExchange(v2, false, 0L);
        }
        catch (TimeoutException timeoutException) {
            throw new Error(timeoutException);
        }
    }

    public V exchange(V v2, long l2, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        return this.doExchange(v2, true, timeUnit.toNanos(l2));
    }
}

