/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ParseException;
import java.text.PatternEntry;
import java.util.ArrayList;

final class MergeCollation {
    ArrayList patterns = new ArrayList();
    private transient PatternEntry saveEntry = null;
    private transient PatternEntry lastEntry = null;
    private transient StringBuffer excess = new StringBuffer();
    private transient byte[] statusArray = new byte[8192];
    private final byte BITARRAYMASK = 1;
    private final int BYTEPOWER = 3;
    private final int BYTEMASK = 7;

    public MergeCollation(String string) throws ParseException {
        for (int i2 = 0; i2 < this.statusArray.length; ++i2) {
            this.statusArray[i2] = 0;
        }
        this.setPattern(string);
    }

    public String getPattern() {
        return this.getPattern(true);
    }

    public String getPattern(boolean bl2) {
        PatternEntry patternEntry;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        PatternEntry patternEntry2 = null;
        ArrayList<PatternEntry> arrayList = null;
        for (n2 = 0; n2 < this.patterns.size(); ++n2) {
            patternEntry = (PatternEntry)this.patterns.get(n2);
            if (patternEntry.extension.length() != 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList<PatternEntry>();
                }
                arrayList.add(patternEntry);
                continue;
            }
            if (arrayList != null) {
                PatternEntry patternEntry3 = this.findLastWithNoExtension(n2 - 1);
                for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                    patternEntry2 = (PatternEntry)arrayList.get(i2);
                    patternEntry2.addToBuffer(stringBuffer, false, bl2, patternEntry3);
                }
                arrayList = null;
            }
            patternEntry.addToBuffer(stringBuffer, false, bl2, null);
        }
        if (arrayList != null) {
            patternEntry = this.findLastWithNoExtension(n2 - 1);
            for (int i3 = arrayList.size() - 1; i3 >= 0; --i3) {
                patternEntry2 = (PatternEntry)arrayList.get(i3);
                patternEntry2.addToBuffer(stringBuffer, false, bl2, patternEntry);
            }
            arrayList = null;
        }
        return stringBuffer.toString();
    }

    private final PatternEntry findLastWithNoExtension(int n2) {
        --n2;
        while (n2 >= 0) {
            PatternEntry patternEntry = (PatternEntry)this.patterns.get(n2);
            if (patternEntry.extension.length() == 0) {
                return patternEntry;
            }
            --n2;
        }
        return null;
    }

    public String emitPattern() {
        return this.emitPattern(true);
    }

    public String emitPattern(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.patterns.size(); ++i2) {
            PatternEntry patternEntry = (PatternEntry)this.patterns.get(i2);
            if (patternEntry == null) continue;
            patternEntry.addToBuffer(stringBuffer, true, bl2, null);
        }
        return stringBuffer.toString();
    }

    public void setPattern(String string) throws ParseException {
        this.patterns.clear();
        this.addPattern(string);
    }

    public void addPattern(String string) throws ParseException {
        if (string == null) {
            return;
        }
        PatternEntry.Parser parser2 = new PatternEntry.Parser(string);
        PatternEntry patternEntry = parser2.next();
        while (patternEntry != null) {
            this.fixEntry(patternEntry);
            patternEntry = parser2.next();
        }
    }

    public int getCount() {
        return this.patterns.size();
    }

    public PatternEntry getItemAt(int n2) {
        return (PatternEntry)this.patterns.get(n2);
    }

    private final void fixEntry(PatternEntry patternEntry) throws ParseException {
        if (this.lastEntry != null && patternEntry.chars.equals(this.lastEntry.chars) && patternEntry.extension.equals(this.lastEntry.extension)) {
            if (patternEntry.strength != 3 && patternEntry.strength != -2) {
                throw new ParseException("The entries " + this.lastEntry + " and " + patternEntry + " are adjacent in the rules, but have conflicting " + "strengths: A character can't be unequal to itself.", -1);
            }
            return;
        }
        boolean bl2 = true;
        if (patternEntry.strength != -2) {
            int n2;
            int n3 = -1;
            if (patternEntry.chars.length() == 1) {
                n2 = patternEntry.chars.charAt(0);
                int n4 = n2 >> 3;
                byte by = this.statusArray[n4];
                byte by2 = (byte)(1 << (n2 & 7));
                if (by != 0 && (by & by2) != 0) {
                    n3 = this.patterns.lastIndexOf(patternEntry);
                } else {
                    this.statusArray[n4] = (byte)(by | by2);
                }
            } else {
                n3 = this.patterns.lastIndexOf(patternEntry);
            }
            if (n3 != -1) {
                this.patterns.remove(n3);
            }
            this.excess.setLength(0);
            n2 = this.findLastEntry(this.lastEntry, this.excess);
            if (this.excess.length() != 0) {
                patternEntry.extension = this.excess + patternEntry.extension;
                if (n2 != this.patterns.size()) {
                    this.lastEntry = this.saveEntry;
                    bl2 = false;
                }
            }
            if (n2 == this.patterns.size()) {
                this.patterns.add(patternEntry);
                this.saveEntry = patternEntry;
            } else {
                this.patterns.add(n2, patternEntry);
            }
        }
        if (bl2) {
            this.lastEntry = patternEntry;
        }
    }

    private final int findLastEntry(PatternEntry patternEntry, StringBuffer stringBuffer) throws ParseException {
        int n2;
        if (patternEntry == null) {
            return 0;
        }
        if (patternEntry.strength != -2) {
            int n3 = -1;
            if (patternEntry.chars.length() == 1) {
                int n4 = patternEntry.chars.charAt(0) >> 3;
                if ((this.statusArray[n4] & 1 << (patternEntry.chars.charAt(0) & 7)) != 0) {
                    n3 = this.patterns.lastIndexOf(patternEntry);
                }
            } else {
                n3 = this.patterns.lastIndexOf(patternEntry);
            }
            if (n3 == -1) {
                throw new ParseException("couldn't find last entry: " + patternEntry, n3);
            }
            return n3 + 1;
        }
        for (n2 = this.patterns.size() - 1; n2 >= 0; --n2) {
            PatternEntry patternEntry2 = (PatternEntry)this.patterns.get(n2);
            if (!patternEntry2.chars.regionMatches(0, patternEntry.chars, 0, patternEntry2.chars.length())) continue;
            stringBuffer.append(patternEntry.chars.substring(patternEntry2.chars.length(), patternEntry.chars.length()));
            break;
        }
        if (n2 == -1) {
            throw new ParseException("couldn't find: " + patternEntry, n2);
        }
        return n2 + 1;
    }
}

