/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.text.BreakDictionary;
import java.text.CharacterIterator;
import java.text.RuleBasedBreakIterator;
import java.util.Stack;
import java.util.Vector;

class DictionaryBasedBreakIterator
extends RuleBasedBreakIterator {
    private BreakDictionary dictionary;
    private boolean[] categoryFlags;
    private int dictionaryCharCount;
    private int[] cachedBreakPositions;
    private int positionInCache;

    public DictionaryBasedBreakIterator(String string, String string2) throws IOException {
        super(string);
        byte[] byArray = super.getAdditionalData();
        if (byArray != null) {
            this.prepareCategoryFlags(byArray);
            super.setAdditionalData(null);
        }
        this.dictionary = new BreakDictionary(string2);
    }

    private void prepareCategoryFlags(byte[] byArray) {
        this.categoryFlags = new boolean[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.categoryFlags[i2] = byArray[i2] == 1;
        }
    }

    public void setText(CharacterIterator characterIterator) {
        super.setText(characterIterator);
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
    }

    public int first() {
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
        return super.first();
    }

    public int last() {
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
        return super.last();
    }

    public int previous() {
        CharacterIterator characterIterator = this.getText();
        if (this.cachedBreakPositions != null && this.positionInCache > 0) {
            --this.positionInCache;
            characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
            return this.cachedBreakPositions[this.positionInCache];
        }
        this.cachedBreakPositions = null;
        int n2 = super.previous();
        if (this.cachedBreakPositions != null) {
            this.positionInCache = this.cachedBreakPositions.length - 2;
        }
        return n2;
    }

    public int preceding(int n2) {
        CharacterIterator characterIterator = this.getText();
        DictionaryBasedBreakIterator.checkOffset(n2, characterIterator);
        if (this.cachedBreakPositions == null || n2 <= this.cachedBreakPositions[0] || n2 > this.cachedBreakPositions[this.cachedBreakPositions.length - 1]) {
            this.cachedBreakPositions = null;
            return super.preceding(n2);
        }
        this.positionInCache = 0;
        while (this.positionInCache < this.cachedBreakPositions.length && n2 > this.cachedBreakPositions[this.positionInCache]) {
            ++this.positionInCache;
        }
        --this.positionInCache;
        characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
        return characterIterator.getIndex();
    }

    public int following(int n2) {
        CharacterIterator characterIterator = this.getText();
        DictionaryBasedBreakIterator.checkOffset(n2, characterIterator);
        if (this.cachedBreakPositions == null || n2 < this.cachedBreakPositions[0] || n2 >= this.cachedBreakPositions[this.cachedBreakPositions.length - 1]) {
            this.cachedBreakPositions = null;
            return super.following(n2);
        }
        this.positionInCache = 0;
        while (this.positionInCache < this.cachedBreakPositions.length && n2 >= this.cachedBreakPositions[this.positionInCache]) {
            ++this.positionInCache;
        }
        characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
        return characterIterator.getIndex();
    }

    protected int handleNext() {
        CharacterIterator characterIterator = this.getText();
        if (this.cachedBreakPositions == null || this.positionInCache == this.cachedBreakPositions.length - 1) {
            int n2 = characterIterator.getIndex();
            this.dictionaryCharCount = 0;
            int n3 = super.handleNext();
            if (this.dictionaryCharCount > 1 && n3 - n2 > 1) {
                this.divideUpDictionaryRange(n2, n3);
            } else {
                this.cachedBreakPositions = null;
                return n3;
            }
        }
        if (this.cachedBreakPositions != null) {
            ++this.positionInCache;
            characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
            return this.cachedBreakPositions[this.positionInCache];
        }
        return -9999;
    }

    protected int lookupCategory(int n2) {
        int n3 = super.lookupCategory(n2);
        if (n3 != -1 && this.categoryFlags[n3]) {
            ++this.dictionaryCharCount;
        }
        return n3;
    }

    private void divideUpDictionaryRange(int n2, int n3) {
        CharacterIterator characterIterator = this.getText();
        characterIterator.setIndex(n2);
        int n4 = this.getCurrent();
        int n5 = this.lookupCategory(n4);
        while (n5 == -1 || !this.categoryFlags[n5]) {
            n4 = this.getNext();
            n5 = this.lookupCategory(n4);
        }
        Stack stack = new Stack();
        Stack<Integer> stack2 = new Stack<Integer>();
        Vector vector = new Vector();
        int n6 = 0;
        int n7 = characterIterator.getIndex();
        Stack stack3 = null;
        n4 = this.getCurrent();
        while (true) {
            if (this.dictionary.getNextState(n6, 0) == -1) {
                stack2.push(new Integer(characterIterator.getIndex()));
            }
            if ((n6 = (int)this.dictionary.getNextStateFromCharacter(n6, n4)) == -1) {
                stack.push(new Integer(characterIterator.getIndex()));
                break;
            }
            if (n6 == 0 || characterIterator.getIndex() >= n3) {
                if (characterIterator.getIndex() > n7) {
                    n7 = characterIterator.getIndex();
                    stack3 = (Stack)stack.clone();
                }
                Object var12_12 = null;
                while (!stack2.isEmpty() && vector.contains(stack2.peek())) {
                    stack2.pop();
                }
                if (stack2.isEmpty()) {
                    if (stack3 != null) {
                        stack = stack3;
                        if (n7 >= n3) break;
                        characterIterator.setIndex(n7 + 1);
                    } else {
                        if ((stack.size() == 0 || ((Integer)stack.peek()).intValue() != characterIterator.getIndex()) && characterIterator.getIndex() != n2) {
                            stack.push(new Integer(characterIterator.getIndex()));
                        }
                        this.getNext();
                        stack.push(new Integer(characterIterator.getIndex()));
                    }
                } else {
                    Integer n8 = (Integer)stack2.pop();
                    Object e2 = null;
                    while (!stack.isEmpty() && n8 < (Integer)stack.peek()) {
                        e2 = stack.pop();
                        vector.addElement(e2);
                    }
                    stack.push(n8);
                    characterIterator.setIndex((Integer)stack.peek());
                }
                n4 = this.getCurrent();
                if (characterIterator.getIndex() < n3) continue;
                break;
            }
            n4 = this.getNext();
        }
        if (!stack.isEmpty()) {
            stack.pop();
        }
        stack.push(new Integer(n3));
        this.cachedBreakPositions = new int[stack.size() + 1];
        this.cachedBreakPositions[0] = n2;
        for (int i2 = 0; i2 < stack.size(); ++i2) {
            this.cachedBreakPositions[i2 + 1] = (Integer)stack.elementAt(i2);
        }
        this.positionInCache = 0;
    }
}

