/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.text.Utility;
import sun.text.resources.LocaleData;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] eras = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] ampms = null;
    String[][] zoneStrings = null;
    static final String patternChars = "GyMdkHmsSEDFwWahKzZ";
    String localPatternChars = null;
    static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    private static Hashtable cachedLocaleData = new Hashtable(3);
    private static Hashtable cachedZoneData = new Hashtable();

    public DateFormatSymbols() {
        this.initializeData(Locale.getDefault());
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(locale);
    }

    public String[] getEras() {
        return this.duplicate(this.eras);
    }

    public void setEras(String[] stringArray) {
        this.eras = this.duplicate(stringArray);
    }

    public String[] getMonths() {
        return this.duplicate(this.months);
    }

    public void setMonths(String[] stringArray) {
        this.months = this.duplicate(stringArray);
    }

    public String[] getShortMonths() {
        return this.duplicate(this.shortMonths);
    }

    public void setShortMonths(String[] stringArray) {
        this.shortMonths = this.duplicate(stringArray);
    }

    public String[] getWeekdays() {
        return this.duplicate(this.weekdays);
    }

    public void setWeekdays(String[] stringArray) {
        this.weekdays = this.duplicate(stringArray);
    }

    public String[] getShortWeekdays() {
        return this.duplicate(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] stringArray) {
        this.shortWeekdays = this.duplicate(stringArray);
    }

    public String[] getAmPmStrings() {
        return this.duplicate(this.ampms);
    }

    public void setAmPmStrings(String[] stringArray) {
        this.ampms = this.duplicate(stringArray);
    }

    public String[][] getZoneStrings() {
        String[][] stringArray = new String[this.zoneStrings.length][];
        for (int i2 = 0; i2 < this.zoneStrings.length; ++i2) {
            stringArray[i2] = this.duplicate(this.zoneStrings[i2]);
        }
        return stringArray;
    }

    public void setZoneStrings(String[][] stringArray) {
        String[][] stringArrayArray = new String[stringArray.length][];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArrayArray[i2] = this.duplicate(stringArray[i2]);
        }
        this.zoneStrings = stringArrayArray;
    }

    public String getLocalPatternChars() {
        return new String(this.localPatternChars);
    }

    public void setLocalPatternChars(String string) {
        this.localPatternChars = new String(string);
    }

    public Object clone() {
        try {
            DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)super.clone();
            this.copyMembers(this, dateFormatSymbols);
            return dateFormatSymbols;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.zoneStrings[0].length; ++i2) {
            n2 ^= this.zoneStrings[0][i2].hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)object;
        return Utility.arrayEquals(this.eras, (Object)dateFormatSymbols.eras) && Utility.arrayEquals(this.months, (Object)dateFormatSymbols.months) && Utility.arrayEquals(this.shortMonths, (Object)dateFormatSymbols.shortMonths) && Utility.arrayEquals(this.weekdays, (Object)dateFormatSymbols.weekdays) && Utility.arrayEquals(this.shortWeekdays, (Object)dateFormatSymbols.shortWeekdays) && Utility.arrayEquals(this.ampms, (Object)dateFormatSymbols.ampms) && Utility.arrayEquals((Object[])this.zoneStrings, (Object)dateFormatSymbols.zoneStrings) && Utility.arrayEquals(this.localPatternChars, (Object)dateFormatSymbols.localPatternChars);
    }

    private ResourceBundle[] cacheLookup(Locale locale) {
        ResourceBundle[] resourceBundleArray = new ResourceBundle[2];
        SoftReference[] softReferenceArray = (SoftReference[])cachedLocaleData.get(locale);
        if (softReferenceArray == null) {
            resourceBundleArray[0] = LocaleData.getLocaleElements(locale);
            resourceBundleArray[1] = LocaleData.getDateFormatZoneData(locale);
            softReferenceArray = new SoftReference[]{new SoftReference<ResourceBundle>(resourceBundleArray[0]), new SoftReference<ResourceBundle>(resourceBundleArray[1])};
            cachedLocaleData.put(locale, softReferenceArray);
        } else {
            ResourceBundle resourceBundle = (ResourceBundle)softReferenceArray[0].get();
            if (resourceBundle == null) {
                resourceBundle = LocaleData.getLocaleElements(locale);
                softReferenceArray[0] = new SoftReference<ResourceBundle>(resourceBundle);
            }
            resourceBundleArray[0] = resourceBundle;
            resourceBundle = (ResourceBundle)softReferenceArray[1].get();
            if (resourceBundle == null) {
                resourceBundle = LocaleData.getDateFormatZoneData(locale);
                softReferenceArray[1] = new SoftReference<ResourceBundle>(resourceBundle);
            }
            resourceBundleArray[1] = resourceBundle;
        }
        return resourceBundleArray;
    }

    private String[][] loadZoneStrings(Locale locale, ResourceBundle resourceBundle) {
        String[][] stringArray;
        SoftReference<String[][]> softReference = (SoftReference<String[][]>)cachedZoneData.get(locale);
        if (softReference == null || (stringArray = (String[][])softReference.get()) == null) {
            Vector<Object> vector = new Vector<Object>();
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (string.equals("localPatternChars") || string.equals("zoneStrings")) continue;
                vector.add(resourceBundle.getObject(string));
            }
            stringArray = new String[vector.size()][];
            vector.toArray((T[])stringArray);
            softReference = new SoftReference<String[][]>(stringArray);
            cachedZoneData.put(locale, softReference);
        }
        return stringArray;
    }

    private void initializeData(Locale locale) {
        int n2;
        ResourceBundle[] resourceBundleArray = this.cacheLookup(locale);
        ResourceBundle resourceBundle = resourceBundleArray[0];
        ResourceBundle resourceBundle2 = resourceBundleArray[1];
        this.eras = (String[])resourceBundle.getObject("Eras");
        this.months = resourceBundle.getStringArray("MonthNames");
        this.shortMonths = resourceBundle.getStringArray("MonthAbbreviations");
        String[] stringArray = resourceBundle.getStringArray("DayNames");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.weekdays[n2 + 1] = stringArray[n2];
        }
        String[] stringArray2 = resourceBundle.getStringArray("DayAbbreviations");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            this.shortWeekdays[n2 + 1] = stringArray2[n2];
        }
        this.ampms = resourceBundle.getStringArray("AmPmMarkers");
        this.zoneStrings = this.loadZoneStrings(locale, resourceBundle2);
        this.localPatternChars = (String)resourceBundle2.getObject("localPatternChars");
    }

    final int getZoneIndex(String string) {
        for (int i2 = 0; i2 < this.zoneStrings.length; ++i2) {
            if (!string.equalsIgnoreCase(this.zoneStrings[i2][0])) continue;
            return i2;
        }
        return -1;
    }

    private final String[] duplicate(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private final void copyMembers(DateFormatSymbols dateFormatSymbols, DateFormatSymbols dateFormatSymbols2) {
        dateFormatSymbols2.eras = this.duplicate(dateFormatSymbols.eras);
        dateFormatSymbols2.months = this.duplicate(dateFormatSymbols.months);
        dateFormatSymbols2.shortMonths = this.duplicate(dateFormatSymbols.shortMonths);
        dateFormatSymbols2.weekdays = this.duplicate(dateFormatSymbols.weekdays);
        dateFormatSymbols2.shortWeekdays = this.duplicate(dateFormatSymbols.shortWeekdays);
        dateFormatSymbols2.ampms = this.duplicate(dateFormatSymbols.ampms);
        for (int i2 = 0; i2 < dateFormatSymbols2.zoneStrings.length; ++i2) {
            dateFormatSymbols2.zoneStrings[i2] = this.duplicate(dateFormatSymbols.zoneStrings[i2]);
        }
        dateFormatSymbols2.localPatternChars = new String(dateFormatSymbols.localPatternChars);
    }

    private final boolean equals(String[] stringArray, String[] stringArray2) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2].equals(stringArray2[i2])) continue;
            return false;
        }
        return true;
    }
}

