/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import sun.misc.VM;

public class ThreadGroup
implements Thread.UncaughtExceptionHandler {
    ThreadGroup parent;
    String name;
    int maxPriority;
    boolean destroyed;
    boolean daemon;
    boolean vmAllowSuspension;
    int nUnstartedThreads = 0;
    int nthreads;
    Thread[] threads;
    int ngroups;
    ThreadGroup[] groups;

    private ThreadGroup() {
        this.name = "system";
        this.maxPriority = 10;
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        if (threadGroup == null) {
            throw new NullPointerException();
        }
        threadGroup.checkAccess();
        this.name = string;
        this.maxPriority = threadGroup.maxPriority;
        this.daemon = threadGroup.daemon;
        this.vmAllowSuspension = threadGroup.vmAllowSuspension;
        this.parent = threadGroup;
        threadGroup.add(this);
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        if (this.parent != null) {
            this.parent.checkAccess();
        }
        return this.parent;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public final void setDaemon(boolean bl2) {
        this.checkAccess();
        this.daemon = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxPriority(int n2) {
        ThreadGroup[] threadGroupArray;
        int n3;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (n2 < 1) {
                this.maxPriority = 1;
            } else if (n2 < this.maxPriority) {
                this.maxPriority = n2;
            }
            n3 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n3];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n3);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            threadGroupArray[i2].setMaxPriority(n2);
        }
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        while (threadGroup != null) {
            if (threadGroup == this) {
                return true;
            }
            threadGroup = threadGroup.parent;
        }
        return false;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeCount() {
        ThreadGroup[] threadGroupArray;
        int n2;
        int n3;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n3 = this.nthreads;
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += threadGroupArray[i2].activeCount();
        }
        return n3;
    }

    public int enumerate(Thread[] threadArray) {
        this.checkAccess();
        return this.enumerate(threadArray, 0, true);
    }

    public int enumerate(Thread[] threadArray, boolean bl2) {
        this.checkAccess();
        return this.enumerate(threadArray, 0, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(Thread[] threadArray, int n2, boolean bl2) {
        int n3 = 0;
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            int n4 = this.nthreads;
            if (n4 > threadArray.length - n2) {
                n4 = threadArray.length - n2;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                if (!this.threads[i2].isAlive()) continue;
                threadArray[n2++] = this.threads[i2];
            }
            if (bl2) {
                n3 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray = new ThreadGroup[n3];
                    System.arraycopy(this.groups, 0, threadGroupArray, 0, n3);
                } else {
                    threadGroupArray = null;
                }
            }
        }
        if (bl2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                n2 = threadGroupArray[i3].enumerate(threadArray, n2, true);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeGroupCount() {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += threadGroupArray[i2].activeGroupCount();
        }
        return n3;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, 0, true);
    }

    public int enumerate(ThreadGroup[] threadGroupArray, boolean bl2) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, 0, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(ThreadGroup[] threadGroupArray, int n2, boolean bl2) {
        int n3 = 0;
        ThreadGroup[] threadGroupArray2 = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            int n4 = this.ngroups;
            if (n4 > threadGroupArray.length - n2) {
                n4 = threadGroupArray.length - n2;
            }
            if (n4 > 0) {
                System.arraycopy(this.groups, 0, threadGroupArray, n2, n4);
                n2 += n4;
            }
            if (bl2) {
                n3 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray2 = new ThreadGroup[n3];
                    System.arraycopy(this.groups, 0, threadGroupArray2, 0, n3);
                } else {
                    threadGroupArray2 = null;
                }
            }
        }
        if (bl2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 = threadGroupArray2[i2].enumerate(threadGroupArray, n2, true);
            }
        }
        return n2;
    }

    @Deprecated
    public final void stop() {
        if (this.stopOrSuspend(false)) {
            Thread.currentThread().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            for (int i2 = 0; i2 < this.nthreads; ++i2) {
                this.threads[i2].interrupt();
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            threadGroupArray[i3].interrupt();
        }
    }

    @Deprecated
    public final void suspend() {
        if (this.stopOrSuspend(true)) {
            Thread.currentThread().suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopOrSuspend(boolean bl2) {
        int n2;
        boolean bl3 = false;
        Thread thread = Thread.currentThread();
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            for (int i2 = 0; i2 < this.nthreads; ++i2) {
                if (this.threads[i2] == thread) {
                    bl3 = true;
                    continue;
                }
                if (bl2) {
                    this.threads[i2].suspend();
                    continue;
                }
                this.threads[i2].stop();
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            }
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            bl3 = threadGroupArray[i3].stopOrSuspend(bl2) || bl3;
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void resume() {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            for (int i2 = 0; i2 < this.nthreads; ++i2) {
                this.threads[i2].resume();
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            threadGroupArray[i3].resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (this.destroyed || this.nthreads > 0) {
                throw new IllegalThreadStateException();
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
            if (this.parent != null) {
                this.destroyed = true;
                this.ngroups = 0;
                this.groups = null;
                this.nthreads = 0;
                this.threads = null;
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            threadGroupArray[i2].destroy();
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void add(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.groups == null) {
                this.groups = new ThreadGroup[4];
            } else if (this.ngroups == this.groups.length) {
                ThreadGroup[] threadGroupArray = new ThreadGroup[this.ngroups * 2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, this.ngroups);
                this.groups = threadGroupArray;
            }
            this.groups[this.ngroups] = threadGroup;
            ++this.ngroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                return;
            }
            for (int i2 = 0; i2 < this.ngroups; ++i2) {
                if (this.groups[i2] != threadGroup) continue;
                --this.ngroups;
                System.arraycopy(this.groups, i2 + 1, this.groups, i2, this.ngroups - i2);
                this.groups[this.ngroups] = null;
                break;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.nUnstartedThreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnstarted() {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            ++this.nUnstartedThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.threads == null) {
                this.threads = new Thread[4];
            } else if (this.nthreads == this.threads.length) {
                Thread[] threadArray = new Thread[this.nthreads * 2];
                System.arraycopy(this.threads, 0, threadArray, 0, this.nthreads);
                this.threads = threadArray;
            }
            this.threads[this.nthreads] = thread;
            ++this.nthreads;
            --this.nUnstartedThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return;
            }
            for (int i2 = 0; i2 < this.nthreads; ++i2) {
                if (this.threads[i2] != thread) continue;
                System.arraycopy(this.threads, i2 + 1, this.threads, i2, --this.nthreads - i2);
                this.threads[this.nthreads] = null;
                break;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.nUnstartedThreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
        }
    }

    public void list() {
        this.list(System.out, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void list(PrintStream printStream, int n2) {
        ThreadGroup[] threadGroupArray;
        int n3;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                printStream.print(" ");
            }
            printStream.println(this);
            n2 += 4;
            for (n4 = 0; n4 < this.nthreads; ++n4) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    printStream.print(" ");
                }
                printStream.println(this.threads[n4]);
            }
            n3 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n3];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n3);
            } else {
                threadGroupArray = null;
            }
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            threadGroupArray[i3].list(printStream, n2);
        }
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
        } else {
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (uncaughtExceptionHandler != null) {
                uncaughtExceptionHandler.uncaughtException(thread, throwable);
            } else if (!(throwable instanceof ThreadDeath)) {
                System.err.print("Exception in thread \"" + thread.getName() + "\" ");
                throwable.printStackTrace(System.err);
            }
        }
    }

    @Deprecated
    public boolean allowThreadSuspension(boolean bl2) {
        this.vmAllowSuspension = bl2;
        if (!bl2) {
            VM.unsuspendSomeThreads();
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.getName() + ",maxpri=" + this.maxPriority + "]";
    }
}

