/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Integer
extends Number
implements Comparable<Integer> {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class<Integer> TYPE = Class.getPrimitiveClass("int");
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private final int value;
    public static final int SIZE = 32;
    private static final long serialVersionUID = 1360826667806852920L;

    public static String toString(int n2, int n3) {
        if (n3 < 2 || n3 > 36) {
            n3 = 10;
        }
        if (n3 == 10) {
            return Integer.toString(n2);
        }
        char[] cArray = new char[33];
        boolean bl2 = n2 < 0;
        int n4 = 32;
        if (!bl2) {
            n2 = -n2;
        }
        while (n2 <= -n3) {
            cArray[n4--] = digits[-(n2 % n3)];
            n2 /= n3;
        }
        cArray[n4] = digits[-n2];
        if (bl2) {
            cArray[--n4] = 45;
        }
        return new String(cArray, n4, 33 - n4);
    }

    public static String toHexString(int n2) {
        return Integer.toUnsignedString(n2, 4);
    }

    public static String toOctalString(int n2) {
        return Integer.toUnsignedString(n2, 3);
    }

    public static String toBinaryString(int n2) {
        return Integer.toUnsignedString(n2, 1);
    }

    private static String toUnsignedString(int n2, int n3) {
        char[] cArray = new char[32];
        int n4 = 32;
        int n5 = 1 << n3;
        int n6 = n5 - 1;
        do {
            cArray[--n4] = digits[n2 & n6];
        } while ((n2 >>>= n3) != 0);
        return new String(cArray, n4, 32 - n4);
    }

    public static String toString(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            return "-2147483648";
        }
        int n3 = n2 < 0 ? Integer.stringSize(-n2) + 1 : Integer.stringSize(n2);
        char[] cArray = new char[n3];
        Integer.getChars(n2, n3, cArray);
        return new String(0, n3, cArray);
    }

    static void getChars(int n2, int n3, char[] cArray) {
        int n4;
        int n5;
        int n6 = n3;
        int n7 = 0;
        if (n2 < 0) {
            n7 = 45;
            n2 = -n2;
        }
        while (n2 >= 65536) {
            n5 = n2 / 100;
            n4 = n2 - ((n5 << 6) + (n5 << 5) + (n5 << 2));
            n2 = n5;
            cArray[--n6] = DigitOnes[n4];
            cArray[--n6] = DigitTens[n4];
        }
        do {
            n5 = n2 * 52429 >>> 19;
            n4 = n2 - ((n5 << 3) + (n5 << 1));
            cArray[--n6] = digits[n4];
        } while ((n2 = n5) != 0);
        if (n7 != 0) {
            cArray[--n6] = n7;
        }
    }

    static int stringSize(int n2) {
        int n3 = 0;
        while (n2 > sizeTable[n3]) {
            ++n3;
        }
        return n3 + 1;
    }

    public static int parseInt(String string, int n2) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (n2 < 2) {
            throw new NumberFormatException("radix " + n2 + " less than Character.MIN_RADIX");
        }
        if (n2 > 36) {
            throw new NumberFormatException("radix " + n2 + " greater than Character.MAX_RADIX");
        }
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = string.length();
        if (n5 > 0) {
            int n6;
            int n7;
            if (string.charAt(0) == '-') {
                bl2 = true;
                n7 = Integer.MIN_VALUE;
                ++n4;
            } else {
                n7 = -2147483647;
            }
            int n8 = n7 / n2;
            if (n4 < n5) {
                if ((n6 = Character.digit(string.charAt(n4++), n2)) < 0) {
                    throw NumberFormatException.forInputString(string);
                }
                n3 = -n6;
            }
            while (n4 < n5) {
                if ((n6 = Character.digit(string.charAt(n4++), n2)) < 0) {
                    throw NumberFormatException.forInputString(string);
                }
                if (n3 < n8) {
                    throw NumberFormatException.forInputString(string);
                }
                if ((n3 *= n2) < n7 + n6) {
                    throw NumberFormatException.forInputString(string);
                }
                n3 -= n6;
            }
        } else {
            throw NumberFormatException.forInputString(string);
        }
        if (bl2) {
            if (n4 > 1) {
                return n3;
            }
            throw NumberFormatException.forInputString(string);
        }
        return -n3;
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static Integer valueOf(String string, int n2) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, n2));
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, 10));
    }

    public static Integer valueOf(int n2) {
        if (n2 >= -128 && n2 <= 127) {
            return IntegerCache.cache[n2 + 128];
        }
        return new Integer(n2);
    }

    public Integer(int n2) {
        this.value = n2;
    }

    public Integer(String string) throws NumberFormatException {
        this.value = Integer.parseInt(string, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Integer) {
            return this.value == (Integer)object;
        }
        return false;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n2) {
        Integer n3 = Integer.getInteger(string, null);
        return n3 == null ? new Integer(n2) : n3;
    }

    public static Integer getInteger(String string, Integer n2) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static Integer decode(String string) throws NumberFormatException {
        Integer n2;
        int n3 = 10;
        int n4 = 0;
        boolean bl2 = false;
        if (string.startsWith("-")) {
            bl2 = true;
            ++n4;
        }
        if (string.startsWith("0x", n4) || string.startsWith("0X", n4)) {
            n4 += 2;
            n3 = 16;
        } else if (string.startsWith("#", n4)) {
            ++n4;
            n3 = 16;
        } else if (string.startsWith("0", n4) && string.length() > 1 + n4) {
            ++n4;
            n3 = 8;
        }
        if (string.startsWith("-", n4)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            n2 = Integer.valueOf(string.substring(n4), n3);
            n2 = bl2 ? new Integer(-n2.intValue()) : n2;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl2 ? new String("-" + string.substring(n4)) : string.substring(n4);
            n2 = Integer.valueOf(string2, n3);
        }
        return n2;
    }

    @Override
    public int compareTo(Integer n2) {
        int n3 = this.value;
        int n4 = n2.value;
        return n3 < n4 ? -1 : (n3 == n4 ? 0 : 1);
    }

    public static int highestOneBit(int n2) {
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        return n2 - (n2 >>> 1);
    }

    public static int lowestOneBit(int n2) {
        return n2 & -n2;
    }

    public static int numberOfLeadingZeros(int n2) {
        if (n2 == 0) {
            return 32;
        }
        int n3 = 1;
        if (n2 >>> 16 == 0) {
            n3 += 16;
            n2 <<= 16;
        }
        if (n2 >>> 24 == 0) {
            n3 += 8;
            n2 <<= 8;
        }
        if (n2 >>> 28 == 0) {
            n3 += 4;
            n2 <<= 4;
        }
        if (n2 >>> 30 == 0) {
            n3 += 2;
            n2 <<= 2;
        }
        return n3 -= n2 >>> 31;
    }

    public static int numberOfTrailingZeros(int n2) {
        if (n2 == 0) {
            return 32;
        }
        int n3 = 31;
        int n4 = n2 << 16;
        if (n4 != 0) {
            n3 -= 16;
            n2 = n4;
        }
        if ((n4 = n2 << 8) != 0) {
            n3 -= 8;
            n2 = n4;
        }
        if ((n4 = n2 << 4) != 0) {
            n3 -= 4;
            n2 = n4;
        }
        if ((n4 = n2 << 2) != 0) {
            n3 -= 2;
            n2 = n4;
        }
        return n3 - (n2 << 1 >>> 31);
    }

    public static int bitCount(int n2) {
        n2 -= n2 >>> 1 & 0x55555555;
        n2 = (n2 & 0x33333333) + (n2 >>> 2 & 0x33333333);
        n2 = n2 + (n2 >>> 4) & 0xF0F0F0F;
        n2 += n2 >>> 8;
        n2 += n2 >>> 16;
        return n2 & 0x3F;
    }

    public static int rotateLeft(int n2, int n3) {
        return n2 << n3 | n2 >>> -n3;
    }

    public static int rotateRight(int n2, int n3) {
        return n2 >>> n3 | n2 << -n3;
    }

    public static int reverse(int n2) {
        n2 = (n2 & 0x55555555) << 1 | n2 >>> 1 & 0x55555555;
        n2 = (n2 & 0x33333333) << 2 | n2 >>> 2 & 0x33333333;
        n2 = (n2 & 0xF0F0F0F) << 4 | n2 >>> 4 & 0xF0F0F0F;
        n2 = n2 << 24 | (n2 & 0xFF00) << 8 | n2 >>> 8 & 0xFF00 | n2 >>> 24;
        return n2;
    }

    public static int signum(int n2) {
        return n2 >> 31 | -n2 >>> 31;
    }

    public static int reverseBytes(int n2) {
        return n2 >>> 24 | n2 >> 8 & 0xFF00 | n2 << 8 & 0xFF0000 | n2 << 24;
    }

    private static class IntegerCache {
        static final Integer[] cache = new Integer[256];

        private IntegerCache() {
        }

        static {
            for (int i2 = 0; i2 < cache.length; ++i2) {
                IntegerCache.cache[i2] = new Integer(i2 - 128);
            }
        }
    }
}

