/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedOutputStream;

public class PipedInputStream
extends InputStream {
    boolean closedByWriter = false;
    volatile boolean closedByReader = false;
    boolean connected = false;
    Thread readSide;
    Thread writeSide;
    protected static final int PIPE_SIZE = 1024;
    protected byte[] buffer = new byte[1024];
    protected int in = -1;
    protected int out = 0;

    public PipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        this.connect(pipedOutputStream);
    }

    public PipedInputStream() {
    }

    public void connect(PipedOutputStream pipedOutputStream) throws IOException {
        pipedOutputStream.connect(this);
    }

    protected synchronized void receive(int n2) throws IOException {
        this.checkStateForReceive();
        this.writeSide = Thread.currentThread();
        if (this.in == this.out) {
            this.awaitSpace();
        }
        if (this.in < 0) {
            this.in = 0;
            this.out = 0;
        }
        this.buffer[this.in++] = (byte)(n2 & 0xFF);
        if (this.in >= this.buffer.length) {
            this.in = 0;
        }
    }

    synchronized void receive(byte[] byArray, int n2, int n3) throws IOException {
        this.checkStateForReceive();
        this.writeSide = Thread.currentThread();
        int n4 = n3;
        while (n4 > 0) {
            if (this.in == this.out) {
                this.awaitSpace();
            }
            int n5 = 0;
            if (this.out < this.in) {
                n5 = this.buffer.length - this.in;
            } else if (this.in < this.out) {
                if (this.in == -1) {
                    this.out = 0;
                    this.in = 0;
                    n5 = this.buffer.length - this.in;
                } else {
                    n5 = this.out - this.in;
                }
            }
            if (n5 > n4) {
                n5 = n4;
            }
            assert (n5 > 0);
            System.arraycopy(byArray, n2, this.buffer, this.in, n5);
            n4 -= n5;
            n2 += n5;
            this.in += n5;
            if (this.in < this.buffer.length) continue;
            this.in = 0;
        }
    }

    private void checkStateForReceive() throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByWriter || this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (this.readSide != null && !this.readSide.isAlive()) {
            throw new IOException("Read end dead");
        }
    }

    private void awaitSpace() throws IOException {
        while (this.in == this.out) {
            if (this.readSide != null && !this.readSide.isAlive()) {
                throw new IOException("Pipe broken");
            }
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
    }

    synchronized void receivedLast() {
        this.closedByWriter = true;
        this.notifyAll();
    }

    public synchronized int read() throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (this.writeSide != null && !this.writeSide.isAlive() && !this.closedByWriter && this.in < 0) {
            throw new IOException("Write end dead");
        }
        this.readSide = Thread.currentThread();
        int n2 = 2;
        while (this.in < 0) {
            if (this.closedByWriter) {
                return -1;
            }
            if (this.writeSide != null && !this.writeSide.isAlive() && --n2 < 0) {
                throw new IOException("Pipe broken");
            }
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        int n3 = this.buffer[this.out++] & 0xFF;
        if (this.out >= this.buffer.length) {
            this.out = 0;
        }
        if (this.in == this.out) {
            this.in = -1;
        }
        return n3;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.read();
        if (n4 < 0) {
            return -1;
        }
        byArray[n2] = (byte)n4;
        int n5 = 1;
        while (this.in >= 0 && --n3 > 0) {
            byArray[n2 + n5] = this.buffer[this.out++];
            ++n5;
            if (this.out >= this.buffer.length) {
                this.out = 0;
            }
            if (this.in != this.out) continue;
            this.in = -1;
        }
        return n5;
    }

    public synchronized int available() throws IOException {
        if (this.in < 0) {
            return 0;
        }
        if (this.in == this.out) {
            return this.buffer.length;
        }
        if (this.in > this.out) {
            return this.in - this.out;
        }
        return this.in + this.buffer.length - this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.closedByReader = true;
        PipedInputStream pipedInputStream = this;
        synchronized (pipedInputStream) {
            this.in = -1;
        }
    }
}

