/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.MimeTypeParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class MimeTypeParameterList
implements Cloneable {
    private Hashtable parameters = new Hashtable();
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String string) throws MimeTypeParseException {
        this.parse(string);
    }

    public int hashCode() {
        int n2 = 0x2D82D82;
        String string = null;
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n2 += string.hashCode();
            n2 += this.get(string).hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MimeTypeParameterList)) {
            return false;
        }
        MimeTypeParameterList mimeTypeParameterList = (MimeTypeParameterList)object;
        if (this.size() != mimeTypeParameterList.size()) {
            return false;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        Set set = this.parameters.entrySet();
        Iterator iterator = set.iterator();
        Map.Entry entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            string2 = (String)entry.getValue();
            string3 = (String)mimeTypeParameterList.parameters.get(string);
            if (!(string2 == null || string3 == null ? string2 != string3 : !string2.equals(string3))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse(String string) throws MimeTypeParseException {
        int n2 = string.length();
        if (n2 <= 0) return;
        int n3 = MimeTypeParameterList.skipWhiteSpace(string, 0);
        int n4 = 0;
        if (n3 >= n2) return;
        char c2 = string.charAt(n3);
        while (n3 < n2 && c2 == ';') {
            String string2;
            boolean bl2;
            ++n3;
            if ((n3 = MimeTypeParameterList.skipWhiteSpace(string, n3)) >= n2) throw new MimeTypeParseException("Couldn't find parameter name");
            n4 = n3;
            c2 = string.charAt(n3);
            while (n3 < n2 && MimeTypeParameterList.isTokenChar(c2)) {
                c2 = string.charAt(++n3);
            }
            String string3 = string.substring(n4, n3).toLowerCase();
            if ((n3 = MimeTypeParameterList.skipWhiteSpace(string, n3)) >= n2 || string.charAt(n3) != '=') throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            ++n3;
            if ((n3 = MimeTypeParameterList.skipWhiteSpace(string, n3)) >= n2) throw new MimeTypeParseException("Couldn't find a value for parameter named " + string3);
            c2 = string.charAt(n3);
            if (c2 == '\"') {
                n4 = ++n3;
                if (n3 >= n2) throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                bl2 = false;
                while (n3 < n2 && !bl2) {
                    c2 = string.charAt(n3);
                    if (c2 == '\\') {
                        n3 += 2;
                        continue;
                    }
                    if (c2 == '\"') {
                        bl2 = true;
                        continue;
                    }
                    ++n3;
                }
                if (c2 != '\"') throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                string2 = MimeTypeParameterList.unquote(string.substring(n4, n3));
                ++n3;
            } else {
                if (!MimeTypeParameterList.isTokenChar(c2)) throw new MimeTypeParseException("Unexpected character encountered at index " + n3);
                n4 = n3;
                bl2 = false;
                while (n3 < n2 && !bl2) {
                    c2 = string.charAt(n3);
                    if (MimeTypeParameterList.isTokenChar(c2)) {
                        ++n3;
                        continue;
                    }
                    bl2 = true;
                }
                string2 = string.substring(n4, n3);
            }
            this.parameters.put(string3, string2);
            if ((n3 = MimeTypeParameterList.skipWhiteSpace(string, n3)) >= n2) continue;
            c2 = string.charAt(n3);
        }
        if (n3 >= n2) return;
        throw new MimeTypeParseException("More characters encountered in input than expected.");
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String get(String string) {
        return (String)this.parameters.get(string.trim().toLowerCase());
    }

    public void set(String string, String string2) {
        this.parameters.put(string.trim().toLowerCase(), string2);
    }

    public void remove(String string) {
        this.parameters.remove(string.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(this.parameters.size() * 16);
        Enumeration enumeration = this.parameters.keys();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("; ");
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(MimeTypeParameterList.quote((String)this.parameters.get(string)));
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        MimeTypeParameterList mimeTypeParameterList = null;
        try {
            mimeTypeParameterList = (MimeTypeParameterList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        mimeTypeParameterList.parameters = (Hashtable)this.parameters.clone();
        return mimeTypeParameterList;
    }

    private static boolean isTokenChar(char c2) {
        return c2 > ' ' && c2 < '\u007f' && TSPECIALS.indexOf(c2) < 0;
    }

    private static int skipWhiteSpace(String string, int n2) {
        int n3 = string.length();
        if (n2 < n3) {
            char c2 = string.charAt(n2);
            while (n2 < n3 && Character.isWhitespace(c2)) {
                c2 = string.charAt(++n2);
            }
        }
        return n2;
    }

    private static String quote(String string) {
        boolean bl2 = false;
        int n2 = string.length();
        for (int i2 = 0; i2 < n2 && !bl2; ++i2) {
            bl2 = !MimeTypeParameterList.isTokenChar(string.charAt(i2));
        }
        if (bl2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.ensureCapacity((int)((double)n2 * 1.5));
            stringBuffer.append('\"');
            for (int i3 = 0; i3 < n2; ++i3) {
                char c2 = string.charAt(i3);
                if (c2 == '\\' || c2 == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
            }
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    private static String unquote(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n2);
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (!bl2 && c2 != '\\') {
                stringBuffer.append(c2);
                continue;
            }
            if (bl2) {
                stringBuffer.append(c2);
                bl2 = false;
                continue;
            }
            bl2 = true;
        }
        return stringBuffer.toString();
    }
}

