/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollPanePeer;
import java.io.Serializable;

class PeerFixer
implements AdjustmentListener,
Serializable {
    private ScrollPane scroller;

    PeerFixer(ScrollPane scrollPane) {
        this.scroller = scrollPane;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        int n2 = adjustmentEvent.getValue();
        ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.scroller.peer;
        if (scrollPanePeer != null) {
            scrollPanePeer.setValue(adjustable, n2);
        }
        Component component = this.scroller.getComponent(0);
        switch (adjustable.getOrientation()) {
            case 1: {
                component.move(component.getLocation().x, -n2);
                break;
            }
            case 0: {
                component.move(-n2, component.getLocation().y);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal adjustable orientation");
            }
        }
    }
}

