/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.xs;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.dv.util.HexBin;
import com.sun.org.apache.xerces.internal.impl.dv.xs.TypeValidator;

public class HexBinaryDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2079;
    }

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        byte[] byArray = HexBin.decode(string);
        if (byArray == null) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "hexBinary"});
        }
        return new XHex(byArray);
    }

    public int getDataLength(Object object) {
        return ((XHex)object).length();
    }

    private static final class XHex {
        final byte[] data;
        private String canonical;

        public XHex(byte[] byArray) {
            this.data = byArray;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.canonical = HexBin.encode(this.data);
            }
            return this.canonical;
        }

        public int length() {
            return this.data.length;
        }

        public boolean equals(Object object) {
            if (!(object instanceof XHex)) {
                return false;
            }
            int n2 = this.data.length;
            byte[] byArray = ((XHex)object).data;
            if (n2 != byArray.length) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.data[i2] == byArray[i2]) continue;
                return false;
            }
            return true;
        }
    }
}

