/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DirectAudioDevice;
import com.sun.media.sound.Platform;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class DirectAudioDeviceProvider
extends MixerProvider {
    private static DirectAudioDeviceInfo[] infos;
    private static DirectAudioDevice[] devices;

    public DirectAudioDeviceProvider() {
        if (Platform.isDirectAudioEnabled()) {
            DirectAudioDeviceProvider.init();
        } else {
            infos = new DirectAudioDeviceInfo[0];
            devices = new DirectAudioDevice[0];
        }
    }

    private static synchronized void init() {
        int n2 = DirectAudioDeviceProvider.nGetNumDevices();
        if (infos == null || infos.length != n2) {
            infos = new DirectAudioDeviceInfo[n2];
            devices = new DirectAudioDevice[n2];
            for (int i2 = 0; i2 < infos.length; ++i2) {
                DirectAudioDeviceProvider.infos[i2] = DirectAudioDeviceProvider.nNewDirectAudioDeviceInfo(i2);
            }
        }
    }

    public Mixer.Info[] getMixerInfo() {
        Mixer.Info[] infoArray = new Mixer.Info[infos.length];
        System.arraycopy(infos, 0, infoArray, 0, infos.length);
        return infoArray;
    }

    public Mixer getMixer(Mixer.Info info) {
        int n2;
        if (info == null) {
            for (n2 = 0; n2 < infos.length; ++n2) {
                Mixer mixer = this.getDevice(infos[n2]);
                if (mixer.getSourceLineInfo().length <= 0) continue;
                return mixer;
            }
        }
        for (n2 = 0; n2 < infos.length; ++n2) {
            if (!infos[n2].equals(info)) continue;
            return this.getDevice(infos[n2]);
        }
        throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
    }

    private Mixer getDevice(DirectAudioDeviceInfo directAudioDeviceInfo) {
        int n2 = directAudioDeviceInfo.getIndex();
        if (devices[n2] == null) {
            DirectAudioDeviceProvider.devices[n2] = new DirectAudioDevice(directAudioDeviceInfo);
        }
        return devices[n2];
    }

    private static native int nGetNumDevices();

    private static native DirectAudioDeviceInfo nNewDirectAudioDeviceInfo(int var0);

    static {
        Platform.initialize();
    }

    static class DirectAudioDeviceInfo
    extends Mixer.Info {
        private int index;
        private int maxSimulLines;
        private int deviceID;

        private DirectAudioDeviceInfo(int n2, int n3, int n4, String string, String string2, String string3, String string4) {
            super(string, string2, "Direct Audio Device: " + string3, string4);
            this.index = n2;
            this.maxSimulLines = n4;
            this.deviceID = n3;
        }

        int getIndex() {
            return this.index;
        }

        int getMaxSimulLines() {
            return this.maxSimulLines;
        }

        int getDeviceID() {
            return this.deviceID;
        }
    }
}

